/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.interfaces.RacingEventServiceOperation;
import com.sap.sailing.server.operationaltransformation.WaypointOperation;
import com.sap.sse.common.Util;
import java.util.logging.Logger;

public class RemoveWaypoint
extends WaypointOperation {
    private static final Logger logger = Logger.getLogger(RemoveWaypoint.class.getName());
    private static final long serialVersionUID = 7461197139000309999L;

    public RemoveWaypoint(RegattaAndRaceIdentifier raceIdentifier, int zeroBasedIndex, Waypoint waypoint) {
        super(raceIdentifier, zeroBasedIndex, waypoint);
    }

    public Void internalApplyTo(RacingEventService toState) throws Exception {
        boolean apply;
        RaceDefinition race = toState.getRace(this.getRaceIdentifier());
        Course course = race.getCourse();
        course.lockForRead();
        try {
            Waypoint waypointAtIndexInCourse = (Waypoint)Util.get((Iterable)course.getWaypoints(), (int)this.getZeroBasedIndex());
            if (waypointAtIndexInCourse != this.getWaypoint()) {
                apply = false;
                logger.info("Not applying operation " + RemoveWaypoint.class.getName() + "(" + this.getZeroBasedIndex() + ", " + this.getWaypoint().getName() + ") because the current course " + course + " contains waypoint " + waypointAtIndexInCourse + " at index " + this.getZeroBasedIndex() + " which is different, so perhaps the initial load on this replica (is this a replica?) already contained the change.");
            } else {
                apply = true;
            }
        }
        finally {
            course.unlockAfterRead();
        }
        if (apply) {
            course.removeWaypoint(this.getZeroBasedIndex());
        }
        return null;
    }

    public RacingEventServiceOperation<?> transformClientOp(RacingEventServiceOperation<?> serverOp) {
        return null;
    }

    public RacingEventServiceOperation<?> transformServerOp(RacingEventServiceOperation<?> clientOp) {
        return null;
    }
}

