/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.operationaltransformation.RecordMarkGPSFix;
import java.io.Serializable;
import java.util.logging.Logger;

public class RecordMarkGPSFixForExistingTrack
extends RecordMarkGPSFix {
    private static final Logger logger = Logger.getLogger(RecordMarkGPSFixForExistingTrack.class.getName());
    private static final long serialVersionUID = -3953907832324217209L;
    private final Serializable markId;

    public RecordMarkGPSFixForExistingTrack(RegattaAndRaceIdentifier raceIdentifier, Mark mark, GPSFix fix) {
        super(raceIdentifier, fix);
        this.markId = mark.getId();
    }

    private Mark getMarkById(DynamicTrackedRace trackedRace) {
        Mark result = null;
        for (Mark mark : trackedRace.getMarks()) {
            if (!mark.getId().equals(this.markId)) continue;
            result = mark;
            break;
        }
        return result;
    }

    public Void internalApplyTo(RacingEventService toState) throws Exception {
        DynamicTrackedRace trackedRace = this.getTrackedRace(toState);
        if (trackedRace != null) {
            Mark mark = this.getMarkById(trackedRace);
            if (mark != null) {
                trackedRace.recordFix(mark, this.getFix(), false);
            } else {
                logger.warning("Received GPS fix for mark with ID " + this.markId + " which was not found in tracked race " + trackedRace.getRace().getName() + " in regatta " + trackedRace.getTrackedRegatta().getRegatta().getName() + ". Maybe this event was processed after the mark had been removed.");
            }
        }
        return null;
    }

    public boolean requiresSynchronousExecution() {
        return false;
    }

    @Override
    protected Object getRaceSpecificKeyComponentForAsynchronousExecution() {
        return this.markId;
    }
}

