/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.tracking.SensorFix;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.interfaces.RacingEventServiceOperation;
import com.sap.sailing.server.operationaltransformation.AbstractRaceOperation;
import com.sap.sse.common.Util;
import java.io.Serializable;

public class RecordCompetitorSensorFix
extends AbstractRaceOperation<Void> {
    private static final long serialVersionUID = -7092704633177037511L;
    private final Serializable competitorID;
    private final SensorFix fix;
    private final String trackName;

    public RecordCompetitorSensorFix(RegattaAndRaceIdentifier raceIdentifier, Competitor competitor, String trackName, SensorFix fix) {
        super(raceIdentifier);
        this.trackName = trackName;
        this.competitorID = competitor.getId();
        this.fix = fix;
    }

    public boolean requiresSynchronousExecution() {
        return false;
    }

    @Override
    protected Object getRaceSpecificKeyComponentForAsynchronousExecution() {
        return new Util.Pair((Object)this.competitorID, (Object)this.trackName);
    }

    public Void internalApplyTo(RacingEventService toState) throws Exception {
        DynamicTrackedRace trackedRace = toState.getExistingTrackedRace(this.getRaceIdentifier());
        if (trackedRace != null) {
            Competitor competitor = trackedRace.getRace().getCompetitorById(this.competitorID);
            trackedRace.recordSensorFix(competitor, this.trackName, this.fix, false);
        }
        return null;
    }

    public RacingEventServiceOperation<?> transformClientOp(RacingEventServiceOperation<?> serverOp) {
        return null;
    }

    public RacingEventServiceOperation<?> transformServerOp(RacingEventServiceOperation<?> clientOp) {
        return null;
    }
}

