/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.common.RegattaIdentifier;
import com.sap.sailing.domain.common.RegattaName;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboard;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.interfaces.RacingEventServiceOperation;
import com.sap.sailing.server.operationaltransformation.AbstractLeaderboardOperation;
import java.util.logging.Logger;

public class CreateRegattaLeaderboard
extends AbstractLeaderboardOperation<RegattaLeaderboard> {
    private static final Logger logger = Logger.getLogger(CreateRegattaLeaderboard.class.getName());
    private static final long serialVersionUID = 891352705068098580L;
    private final int[] discardThresholds;
    private final RegattaIdentifier regattaIdentifier;
    private final String leaderboardDisplayName;

    public CreateRegattaLeaderboard(RegattaIdentifier regattaIdentifier, String leaderboardDisplayName, int[] discardThresholds) {
        super(((RegattaName)regattaIdentifier).getRegattaName());
        this.leaderboardDisplayName = leaderboardDisplayName;
        this.regattaIdentifier = regattaIdentifier;
        this.discardThresholds = discardThresholds;
    }

    public RegattaLeaderboard internalApplyTo(RacingEventService toState) {
        RegattaLeaderboard result = null;
        if (toState.getLeaderboardByName(this.getLeaderboardName()) == null) {
            result = toState.addRegattaLeaderboard(this.regattaIdentifier, this.leaderboardDisplayName, this.discardThresholds);
        } else {
            logger.warning("Cannot replicate creation of flexible leaderboard " + this.getLeaderboardName() + " because it already exists in the replica");
        }
        return result;
    }

    public RacingEventServiceOperation<?> transformClientOp(RacingEventServiceOperation<?> serverOp) {
        return serverOp.transformAddRegattaLeaderboardClientOp(this);
    }

    public RacingEventServiceOperation<?> transformServerOp(RacingEventServiceOperation<?> clientOp) {
        return clientOp.transformAddRegattaLeaderboardServerOp(this);
    }
}

