/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.leaderboard.FlexibleLeaderboard;
import com.sap.sailing.domain.leaderboard.ScoringScheme;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.interfaces.RacingEventServiceOperation;
import com.sap.sailing.server.operationaltransformation.AbstractLeaderboardOperation;
import com.sap.sse.common.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class CreateFlexibleLeaderboard
extends AbstractLeaderboardOperation<FlexibleLeaderboard> {
    private static final Logger logger = Logger.getLogger(CreateFlexibleLeaderboard.class.getName());
    private static final long serialVersionUID = 891352705068098580L;
    private final int[] discardThresholds;
    private final ScoringScheme scoringScheme;
    private final String leaderboardDisplayName;
    private final List<Serializable> courseAreaIds;

    public CreateFlexibleLeaderboard(String leaderboardName, String leaderboardDisplayName, int[] discardThresholds, ScoringScheme scoringScheme, Iterable<? extends Serializable> courseAreaIds) {
        super(leaderboardName);
        this.leaderboardDisplayName = leaderboardDisplayName;
        this.discardThresholds = discardThresholds;
        this.scoringScheme = scoringScheme;
        this.courseAreaIds = new ArrayList<Serializable>();
        if (courseAreaIds != null) {
            Util.addAll(courseAreaIds, this.courseAreaIds);
        }
    }

    public FlexibleLeaderboard internalApplyTo(RacingEventService toState) {
        FlexibleLeaderboard result = null;
        if (toState.getLeaderboardByName(this.getLeaderboardName()) == null) {
            result = toState.addFlexibleLeaderboard(this.getLeaderboardName(), this.leaderboardDisplayName, this.discardThresholds, this.scoringScheme, this.courseAreaIds);
        } else {
            logger.warning("Cannot replicate creation of flexible leaderboard " + this.getLeaderboardName() + " because it already exists in the replica");
        }
        return result;
    }

    public RacingEventServiceOperation<?> transformClientOp(RacingEventServiceOperation<?> serverOp) {
        return serverOp.transformAddFlexibleLeaderboardClientOp(this);
    }

    public RacingEventServiceOperation<?> transformServerOp(RacingEventServiceOperation<?> clientOp) {
        return clientOp.transformAddFlexibleLeaderboardServerOp(this);
    }
}

