/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.Series;
import com.sap.sailing.domain.base.impl.FleetImpl;
import com.sap.sailing.domain.base.impl.SeriesImpl;
import com.sap.sailing.domain.common.CompetitorRegistrationType;
import com.sap.sailing.domain.common.RankingMetrics;
import com.sap.sailing.domain.common.dto.FleetDTO;
import com.sap.sailing.domain.common.dto.RegattaCreationParametersDTO;
import com.sap.sailing.domain.common.dto.SeriesCreationParametersDTO;
import com.sap.sailing.domain.leaderboard.ScoringScheme;
import com.sap.sailing.domain.leaderboard.ThresholdBasedResultDiscardingRule;
import com.sap.sailing.domain.leaderboard.impl.ThresholdBasedResultDiscardingRuleImpl;
import com.sap.sailing.domain.ranking.RankingMetricsFactory;
import com.sap.sailing.domain.tracking.TrackedRegattaRegistry;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.interfaces.RacingEventServiceOperation;
import com.sap.sailing.server.operationaltransformation.AbstractAddRegattaOperation;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class AddSpecificRegatta
extends AbstractAddRegattaOperation {
    private static final long serialVersionUID = -8018855620167669352L;
    private final RegattaCreationParametersDTO seriesNamesWithFleetNamesAndFleetOrderingAndMedalAndStartsWithZeroScoreAndDiscardingThresholds;
    private final boolean persistent;
    private final ScoringScheme scoringScheme;
    private final List<Serializable> courseAreaIds;
    private final Double buoyZoneRadiusInHullLengths;
    private final boolean useStartTimeInference;
    private final boolean controlTrackingFromStartAndFinishTimes;
    private final boolean autoRestartTrackingUponCompetitorSetChange;
    private final boolean canBoatsOfCompetitorsChangePerRace;
    private final CompetitorRegistrationType competitorRegistrationType;
    private final RankingMetrics rankingMetricType;
    private final String registrationLinkSecret;

    public AddSpecificRegatta(String regattaName, String boatClassName, boolean canBoatsOfCompetitorsChangePerRace, CompetitorRegistrationType competitorRegistrationType, String registrationLinkSecret, TimePoint startDate, TimePoint endDate, Serializable id, RegattaCreationParametersDTO seriesNamesWithFleetNamesAndFleetOrderingAndMedalAndDiscardingThresholds, boolean persistent, ScoringScheme scoringScheme, Iterable<? extends Serializable> courseAreaIds, Double buoyZoneRadiusInHullLengths, boolean useStartTimeInference, boolean controlTrackingFromStartAndFinishTimes, boolean autoRestartTrackingUponCompetitorSetChange, RankingMetrics rankingMetricType) {
        super(regattaName, boatClassName, startDate, endDate, id);
        this.canBoatsOfCompetitorsChangePerRace = canBoatsOfCompetitorsChangePerRace;
        this.competitorRegistrationType = competitorRegistrationType;
        this.seriesNamesWithFleetNamesAndFleetOrderingAndMedalAndStartsWithZeroScoreAndDiscardingThresholds = seriesNamesWithFleetNamesAndFleetOrderingAndMedalAndDiscardingThresholds;
        this.persistent = persistent;
        this.scoringScheme = scoringScheme;
        this.courseAreaIds = new ArrayList<Serializable>();
        if (courseAreaIds != null) {
            Util.addAll(courseAreaIds, this.courseAreaIds);
        }
        this.useStartTimeInference = useStartTimeInference;
        this.controlTrackingFromStartAndFinishTimes = controlTrackingFromStartAndFinishTimes;
        this.autoRestartTrackingUponCompetitorSetChange = autoRestartTrackingUponCompetitorSetChange;
        this.rankingMetricType = rankingMetricType;
        this.buoyZoneRadiusInHullLengths = buoyZoneRadiusInHullLengths;
        this.registrationLinkSecret = registrationLinkSecret;
    }

    public Regatta internalApplyTo(RacingEventService toState) throws Exception {
        Regatta regatta = toState.createRegatta(this.getRegattaName(), this.getBoatClassName(), this.canBoatsOfCompetitorsChangePerRace, this.competitorRegistrationType, this.registrationLinkSecret, this.getStartDate(), this.getEndDate(), this.getId(), this.createSeries(toState), this.persistent, this.scoringScheme, this.courseAreaIds, this.buoyZoneRadiusInHullLengths, this.useStartTimeInference, this.controlTrackingFromStartAndFinishTimes, this.autoRestartTrackingUponCompetitorSetChange, RankingMetricsFactory.getRankingMetricConstructor((RankingMetrics)this.rankingMetricType));
        return regatta;
    }

    private Iterable<? extends Series> createSeries(TrackedRegattaRegistry trackedRegattaRegistry) {
        ArrayList<SeriesImpl> result = new ArrayList<SeriesImpl>();
        for (Map.Entry e : this.seriesNamesWithFleetNamesAndFleetOrderingAndMedalAndStartsWithZeroScoreAndDiscardingThresholds.getSeriesCreationParameters().entrySet()) {
            List emptyRaceColumnNamesList = Collections.emptyList();
            SeriesImpl s = new SeriesImpl((String)e.getKey(), ((SeriesCreationParametersDTO)e.getValue()).isMedal(), ((SeriesCreationParametersDTO)e.getValue()).isFleetsCanRunInParallel(), this.createFleets(((SeriesCreationParametersDTO)e.getValue()).getFleets()), emptyRaceColumnNamesList, trackedRegattaRegistry);
            if (((SeriesCreationParametersDTO)e.getValue()).getDiscardingThresholds() != null) {
                s.setResultDiscardingRule((ThresholdBasedResultDiscardingRule)new ThresholdBasedResultDiscardingRuleImpl(((SeriesCreationParametersDTO)e.getValue()).getDiscardingThresholds()));
            }
            s.setStartsWithZeroScore(((SeriesCreationParametersDTO)e.getValue()).isStartsWithZero());
            s.setSplitFleetContiguousScoring(((SeriesCreationParametersDTO)e.getValue()).hasSplitFleetContiguousScoring());
            s.setFirstColumnIsNonDiscardableCarryForward(((SeriesCreationParametersDTO)e.getValue()).isFirstColumnIsNonDiscardableCarryForward());
            s.setMaximumNumberOfDiscards(((SeriesCreationParametersDTO)e.getValue()).getMaximumNumberOfDiscards());
            s.setOneAlwaysStaysOne(((SeriesCreationParametersDTO)e.getValue()).isOneAlwaysStaysOne());
            result.add(s);
        }
        return result;
    }

    private Iterable<? extends Fleet> createFleets(List<FleetDTO> fleetNamesAndOrderingAndColor) {
        ArrayList<FleetImpl> result = new ArrayList<FleetImpl>();
        for (FleetDTO fleetNameAndOrderingAndColor : fleetNamesAndOrderingAndColor) {
            FleetImpl fleet = new FleetImpl(fleetNameAndOrderingAndColor.getName(), fleetNameAndOrderingAndColor.getOrderNo(), fleetNameAndOrderingAndColor.getColor());
            result.add(fleet);
        }
        return result;
    }

    public RacingEventServiceOperation<?> transformClientOp(RacingEventServiceOperation<?> serverOp) {
        return null;
    }

    public RacingEventServiceOperation<?> transformServerOp(RacingEventServiceOperation<?> clientOp) {
        return null;
    }
}

