/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.interfaces.RacingEventServiceOperation;
import com.sap.sailing.server.operationaltransformation.AbstractRacingEventServiceOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import java.util.logging.Logger;

public class AddLeaderboardGroupToEvent
extends AbstractRacingEventServiceOperation<Iterable<LeaderboardGroup>> {
    private static Logger logger = Logger.getLogger(AddLeaderboardGroupToEvent.class.getName());
    private static final long serialVersionUID = 5061411909275963501L;
    private final UUID eventId;
    private final UUID[] leaderboardGroupIds;

    public AddLeaderboardGroupToEvent(UUID eventId, UUID ... leaderboardGroupIds) {
        this.eventId = eventId;
        this.leaderboardGroupIds = leaderboardGroupIds;
    }

    public Iterable<LeaderboardGroup> internalApplyTo(RacingEventService toState) throws Exception {
        boolean updated = false;
        Event event = toState.getEvent(this.eventId);
        ArrayList<LeaderboardGroup> result = new ArrayList<LeaderboardGroup>();
        if (event != null) {
            UUID[] uUIDArray = this.leaderboardGroupIds;
            int n = this.leaderboardGroupIds.length;
            int n2 = 0;
            while (n2 < n) {
                UUID leaderboardGroupId = uUIDArray[n2];
                LeaderboardGroup leaderboardGroup = toState.getLeaderboardGroupByID(leaderboardGroupId);
                if (leaderboardGroup != null) {
                    event.addLeaderboardGroup(leaderboardGroup);
                    result.add(leaderboardGroup);
                    updated = true;
                } else {
                    logger.info("Leaderboard group with ID " + leaderboardGroupId + " not found. Cannot add leaderboard group to event with ID " + this.eventId);
                }
                ++n2;
            }
        } else {
            logger.info("Event with ID " + this.eventId + " not found. Cannot add leaderboard groups with IDs " + Arrays.toString(this.leaderboardGroupIds) + " to it.");
        }
        if (updated) {
            toState.getMongoObjectFactory().storeEvent(event);
        }
        return result;
    }

    public RacingEventServiceOperation<?> transformClientOp(RacingEventServiceOperation<?> serverOp) {
        return null;
    }

    public RacingEventServiceOperation<?> transformServerOp(RacingEventServiceOperation<?> clientOp) {
        return null;
    }
}

