/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.operationaltransformation.AbstractRacingEventServiceOperation;
import com.sap.sse.common.Util;

public abstract class AbstractRaceOperation<ResultType>
extends AbstractRacingEventServiceOperation<ResultType> {
    private static final long serialVersionUID = -1162468486451355784L;
    private RegattaAndRaceIdentifier raceIdentifier;

    public AbstractRaceOperation(RegattaAndRaceIdentifier raceIdentifier) {
        this.raceIdentifier = raceIdentifier;
    }

    public boolean isRequiresExplicitTransitiveReplication() {
        return false;
    }

    protected RegattaAndRaceIdentifier getRaceIdentifier() {
        return this.raceIdentifier;
    }

    protected DynamicTrackedRace getTrackedRace(RacingEventService racingEventService) {
        DynamicTrackedRace trackedRace = racingEventService.getExistingTrackedRace(this.getRaceIdentifier());
        return trackedRace;
    }

    public Object getKeyForAsynchronousExecution() {
        return new Util.Triple(this.getClass(), (Object)this.raceIdentifier, this.getRaceSpecificKeyComponentForAsynchronousExecution());
    }

    protected Object getRaceSpecificKeyComponentForAsynchronousExecution() {
        return null;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " [raceIdentifier=" + this.raceIdentifier + "]";
    }
}

