/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceColumnInSeries;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.Series;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.operationaltransformation.AbstractRaceLogOperation;

public abstract class AbstractRaceLogOnRegattaOperation<T>
extends AbstractRaceLogOperation<T> {
    private static final long serialVersionUID = -7174569054572099191L;
    private final String regattaName;

    public AbstractRaceLogOnRegattaOperation(String regattaName, String raceColumnName, String fleetName) {
        super(raceColumnName, fleetName);
        this.regattaName = regattaName;
    }

    protected String getRegattaName() {
        return this.regattaName;
    }

    @Override
    protected RaceColumn getRaceColumn(RacingEventService toState) {
        Regatta regatta = toState.getRegattaByName(this.regattaName);
        RaceColumnInSeries raceColumn = null;
        for (Series series : regatta.getSeries()) {
            raceColumn = series.getRaceColumnByName(this.getRaceColumnName());
            if (raceColumn != null) break;
        }
        return raceColumn;
    }
}

