/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.filestorage.impl;

import com.sap.sse.common.TypeBasedServiceFinder;
import com.sap.sse.filestorage.FileStorageManagementService;
import com.sap.sse.filestorage.FileStorageService;
import com.sap.sse.filestorage.impl.AmazonS3FileStorageServiceImpl;
import com.sap.sse.filestorage.impl.FileStorageManagementServiceImpl;
import com.sap.sse.filestorage.impl.LocalFileStorageServiceImpl;
import com.sap.sse.filestorage.impl.MongoFileStorageServicePropertyStoreImpl;
import com.sap.sse.filestorage.impl.ServiceAddedListenerWrappingCustomizer;
import com.sap.sse.mongodb.MongoDBConfiguration;
import com.sap.sse.osgi.CachedOsgiTypeBasedServiceFinderFactory;
import com.sap.sse.replication.Replicable;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private ServiceTracker<FileStorageService, FileStorageService> tracker;

    public void start(BundleContext context) throws Exception {
        MongoDBConfiguration dbConfig = MongoDBConfiguration.getDefaultConfiguration();
        dbConfig.getService().registerExclusively(MongoFileStorageServicePropertyStoreImpl.class, "FileStorageServiceProperties");
        dbConfig.getService().registerExclusively(MongoFileStorageServicePropertyStoreImpl.class, "ActiveFileStorageService");
        MongoFileStorageServicePropertyStoreImpl propertyStore = new MongoFileStorageServicePropertyStoreImpl(dbConfig.getService());
        Hashtable<String, String> dict = new Hashtable<String, String>();
        ((Dictionary)dict).put("type", "Amazon S3");
        context.registerService(FileStorageService.class, (Object)new AmazonS3FileStorageServiceImpl(context), dict);
        Hashtable<String, String> localStorageDict = new Hashtable<String, String>();
        ((Dictionary)localStorageDict).put("type", "Local Storage");
        context.registerService(FileStorageService.class, (Object)new LocalFileStorageServiceImpl(context), localStorageDict);
        FileStorageManagementServiceImpl mgmtService = new FileStorageManagementServiceImpl((TypeBasedServiceFinder<FileStorageService>)new CachedOsgiTypeBasedServiceFinderFactory(context).createServiceFinder(FileStorageService.class), propertyStore);
        context.registerService(FileStorageManagementService.class, (Object)mgmtService, null);
        Hashtable<String, String> replicableServiceProperties = new Hashtable<String, String>();
        ((Dictionary)replicableServiceProperties).put("ID", mgmtService.getId().toString());
        context.registerService(Replicable.class.getName(), (Object)mgmtService, replicableServiceProperties);
        this.tracker = new ServiceTracker(context, FileStorageService.class, new ServiceAddedListenerWrappingCustomizer<FileStorageService>(context, mgmtService));
        this.tracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.tracker != null) {
            this.tracker.close();
        }
    }
}

