/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl.functions.criterias;

import com.sap.sse.datamining.functions.Function;
import com.sap.sse.datamining.impl.functions.criterias.AbstractFunctionFilterCriterion;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;

public class IsDeclaringTypeFilterCriterion
extends AbstractFunctionFilterCriterion {
    private final Collection<Class<?>> expectingTypes;

    public IsDeclaringTypeFilterCriterion(Class<?> expectingType) {
        this.expectingTypes = this.getSupertypesOf(expectingType);
        this.expectingTypes.add(expectingType);
    }

    private Collection<Class<?>> getSupertypesOf(Class<?> type) {
        HashSet supertypesToAdd;
        HashSet supertypes = new HashSet();
        boolean supertypeAdded = supertypes.addAll(this.getInterfacesOf(type));
        if (this.isSuperclassValid(type)) {
            boolean superclassAdded = supertypes.add(type.getSuperclass());
            supertypeAdded = supertypeAdded ? true : superclassAdded;
        }
        do {
            supertypesToAdd = new HashSet();
            for (Class clazz : supertypes) {
                supertypesToAdd.addAll(this.getSupertypesOf(clazz));
            }
        } while (supertypeAdded = supertypes.addAll(supertypesToAdd));
        return supertypes;
    }

    private boolean isSuperclassValid(Class<?> type) {
        return type.getSuperclass() != null && !type.getSuperclass().equals(Object.class);
    }

    private Collection<Class<?>> getInterfacesOf(Class<?> type) {
        return Arrays.asList(type.getInterfaces());
    }

    @Override
    public boolean matches(Function<?> function) {
        for (Class<?> expectingType : this.expectingTypes) {
            if (!this.isDeclaringTypeMatching(function, expectingType)) continue;
            return true;
        }
        return false;
    }

    private boolean isDeclaringTypeMatching(Function<?> function, Class<?> expectingType) {
        return function.getDeclaringType().equals(expectingType);
    }
}

