/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl.data;

import com.sap.sse.datamining.data.Cluster;
import com.sap.sse.datamining.data.ClusterGroup;
import com.sap.sse.datamining.impl.data.ClusterWithLowerAndUpperBoundaries;
import com.sap.sse.datamining.impl.data.ClusterWithSingleBoundary;
import com.sap.sse.datamining.impl.data.ComparableClusterBoundary;
import com.sap.sse.datamining.impl.data.ComparisonStrategy;
import java.util.HashMap;
import java.util.Map;

public class LinearDoubleClusterGroup
implements ClusterGroup<Double> {
    private static final long serialVersionUID = 1559316450183865115L;
    private final double lowerBound;
    private final double upperBound;
    private final double stepSize;
    private final boolean hardBounds;
    private final transient Map<Integer, Cluster<Double>> clusterCache;
    private final int lastClusterIndex;

    public LinearDoubleClusterGroup(double lowerBound, double upperBound, double stepSize, boolean hardBounds) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.stepSize = stepSize;
        this.hardBounds = hardBounds;
        this.clusterCache = new HashMap<Integer, Cluster<Double>>();
        this.lastClusterIndex = LinearDoubleClusterGroup.calculateLastClusterIndex(this.upperBound, this.stepSize);
    }

    private static int calculateLastClusterIndex(double upperBound, double stepSize) {
        double doubleIndex = upperBound / stepSize;
        int index = (int)doubleIndex;
        double fractionalPart = doubleIndex - (double)index;
        if (fractionalPart <= 1.0E-4) {
            --index;
        }
        return index;
    }

    @Override
    public Cluster<Double> getClusterFor(Double valueObject) {
        double value = valueObject;
        if (value < this.lowerBound) {
            return this.hardBounds ? null : this.getCluster(0);
        }
        if (value > this.upperBound) {
            return this.hardBounds ? null : this.getCluster(this.lastClusterIndex);
        }
        if (Math.abs(this.upperBound - value) < 1.0E-4) {
            return this.getCluster(this.lastClusterIndex);
        }
        return this.getCluster((int)(value / this.stepSize));
    }

    private Cluster<Double> getCluster(int index) {
        if (!this.clusterCache.containsKey(index)) {
            this.clusterCache.put(index, this.createCluster(index));
        }
        return this.clusterCache.get(index);
    }

    private Cluster<Double> createCluster(int index) {
        if (index == 0 && !this.hardBounds) {
            return new ClusterWithSingleBoundary<Double>(this.createUpperBound(index, ComparisonStrategy.LOWER_THAN));
        }
        if (index == this.lastClusterIndex && !this.hardBounds) {
            return new ClusterWithSingleBoundary<Double>(this.createLowerBound(index, ComparisonStrategy.GREATER_EQUALS_THAN));
        }
        ComparisonStrategy upperComparisonStrategy = index == this.lastClusterIndex ? ComparisonStrategy.LOWER_EQUALS_THAN : ComparisonStrategy.LOWER_THAN;
        return new ClusterWithLowerAndUpperBoundaries<Double>(this.createLowerBound(index, ComparisonStrategy.GREATER_EQUALS_THAN), this.createUpperBound(index, upperComparisonStrategy));
    }

    private ComparableClusterBoundary<Double> createLowerBound(int index, ComparisonStrategy comparisonStrategy) {
        return new ComparableClusterBoundary<Double>(this.lowerBound + this.stepSize * (double)index, comparisonStrategy);
    }

    private ComparableClusterBoundary<Double> createUpperBound(int index, ComparisonStrategy comparisonStrategy) {
        return new ComparableClusterBoundary<Double>(this.lowerBound + this.stepSize * ((double)index + 1.0), comparisonStrategy);
    }

    @Override
    public Class<Double> getClusterElementsType() {
        return Double.class;
    }

    public double getLowerGroupBound() {
        return this.lowerBound;
    }

    public double getUpperGroupBound() {
        return this.upperBound;
    }

    public double getStepSize() {
        return this.stepSize;
    }

    public boolean isHardBounds() {
        return this.hardBounds;
    }
}

