/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl.components.management;

import com.sap.sse.common.Util;
import com.sap.sse.datamining.annotations.Connector;
import com.sap.sse.datamining.components.DataRetrieverChainDefinition;
import com.sap.sse.datamining.components.FilterCriterion;
import com.sap.sse.datamining.components.management.FunctionProvider;
import com.sap.sse.datamining.components.management.FunctionRegistry;
import com.sap.sse.datamining.exceptions.MultipleDataMiningComponentsFoundForDTOException;
import com.sap.sse.datamining.factories.DataMiningDTOFactory;
import com.sap.sse.datamining.factories.FunctionFactory;
import com.sap.sse.datamining.functions.Function;
import com.sap.sse.datamining.impl.components.DataRetrieverLevel;
import com.sap.sse.datamining.impl.components.management.ReducedDimensions;
import com.sap.sse.datamining.impl.functions.ConcatenatingCompoundFunction;
import com.sap.sse.datamining.impl.functions.IdentityFunction;
import com.sap.sse.datamining.impl.functions.MethodWrappingFunction;
import com.sap.sse.datamining.impl.functions.criterias.MethodIsValidConnectorFilterCriterion;
import com.sap.sse.datamining.impl.functions.criterias.MethodIsValidDimensionFilterCriterion;
import com.sap.sse.datamining.impl.functions.criterias.MethodIsValidExternalFunctionFilterCriterion;
import com.sap.sse.datamining.impl.functions.criterias.MethodIsValidStatisticFilterCriterion;
import com.sap.sse.datamining.shared.impl.dto.FunctionDTO;
import com.sap.sse.datamining.util.ClassUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class FunctionManager
implements FunctionRegistry,
FunctionProvider {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final FilterCriterion<Method> isValidDimension = new MethodIsValidDimensionFilterCriterion();
    private final FilterCriterion<Method> isValidStatistic = new MethodIsValidStatisticFilterCriterion();
    private final FilterCriterion<Method> isValidConnector = new MethodIsValidConnectorFilterCriterion();
    private final FilterCriterion<Method> isValidExternalFunction = new MethodIsValidExternalFunctionFilterCriterion();
    private final FunctionFactory functionFactory = new FunctionFactory();
    protected final IdentityFunction identityFunction = new IdentityFunction();
    protected final FunctionDTO identityFunctionDTO = new DataMiningDTOFactory().createFunctionDTO(this.identityFunction);
    protected final Map<Class<?>, Set<Function<?>>> statistics = new HashMap();
    protected final Map<Class<?>, Set<Function<?>>> dimensions = new HashMap();
    protected final Map<Class<?>, Set<Function<?>>> externalFunctions = new HashMap();
    private final Collection<Map<Class<?>, Set<Function<?>>>> functionMaps = new ArrayList();

    public FunctionManager() {
        this.functionMaps.add(this.statistics);
        this.functionMaps.add(this.dimensions);
        this.functionMaps.add(this.externalFunctions);
    }

    @Override
    public boolean registerAllClasses(Iterable<Class<?>> internalClassesToScan) {
        boolean functionsHaveBeenRegistered = false;
        for (Class<?> internalClass : internalClassesToScan) {
            this.logger.info("Registering functions of class " + internalClass.getName() + " with internal policy");
            boolean functionsOfClassHaveBeenRegistered = this.scanInternalClass(internalClass);
            boolean bl = functionsHaveBeenRegistered = functionsHaveBeenRegistered ? true : functionsOfClassHaveBeenRegistered;
            if (functionsOfClassHaveBeenRegistered) {
                this.logger.info("Finished the registration of class " + internalClass.getName() + " with internal policy");
                continue;
            }
            this.logger.info("Couldn't find any functions for class " + internalClass.getName() + " with internal policy");
        }
        return functionsHaveBeenRegistered;
    }

    private boolean scanInternalClass(Class<?> internalClass) {
        return this.scanInternalClass(internalClass, new ArrayList(), true);
    }

    private boolean scanInternalClass(Class<?> internalClass, List<Function<?>> previousFunctions, boolean scanForStatistics) {
        boolean functionsHaveBeenRegistered = false;
        Method[] methodArray = internalClass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            boolean functionHasBeenRegistered = false;
            if (this.isValidDimension.matches(method) || scanForStatistics && this.isValidStatistic.matches(method)) {
                functionHasBeenRegistered = this.registerFunction(previousFunctions, method);
            }
            if (this.isValidConnector.matches(method)) {
                functionHasBeenRegistered = this.handleConnectorMethod(method, previousFunctions, scanForStatistics);
            }
            functionsHaveBeenRegistered = functionsHaveBeenRegistered ? true : functionHasBeenRegistered;
            ++n2;
        }
        return functionsHaveBeenRegistered;
    }

    private boolean registerFunction(List<Function<?>> previousFunctions, Method method) {
        Function<Object> function = this.functionFactory.createMethodWrappingFunction(method);
        if (!previousFunctions.isEmpty()) {
            function = this.functionFactory.createCompoundFunction(previousFunctions, function);
        }
        if (function.isDimension()) {
            return this.addDimension(function);
        }
        return this.addStatistic(function);
    }

    private boolean addDimension(Function<?> dimension) {
        Class<?> declaringType = dimension.getDeclaringType();
        if (!this.dimensions.containsKey(declaringType)) {
            this.dimensions.put(declaringType, new HashSet());
        }
        this.logger.finer("Registering dimension " + dimension + " for the internal class " + declaringType.getName());
        return this.dimensions.get(declaringType).add(dimension);
    }

    private boolean addStatistic(Function<?> statistic) {
        Class<?> declaringType = statistic.getDeclaringType();
        if (!this.statistics.containsKey(declaringType)) {
            this.statistics.put(declaringType, new HashSet());
        }
        this.logger.finer("Registering statistic " + statistic + " for the internal class " + declaringType.getName());
        return this.statistics.get(declaringType).add(statistic);
    }

    private boolean handleConnectorMethod(Method method, List<Function<?>> previousFunctions, boolean scanForStatistics) {
        MethodWrappingFunction function = this.functionFactory.createMethodWrappingFunction(method);
        Class<?> returnType = method.getReturnType();
        ArrayList previousFunctionsClone = new ArrayList(previousFunctions);
        previousFunctionsClone.add(function);
        return this.scanInternalClass(returnType, previousFunctionsClone, !scanForStatistics ? false : method.getAnnotation(Connector.class).scanForStatistics());
    }

    @Override
    public boolean registerAllWithExternalFunctionPolicy(Iterable<Class<?>> externalClassesToScan) {
        boolean functionsHaveBeenRegistered = false;
        for (Class<?> externalClass : externalClassesToScan) {
            this.logger.info("Registering functions of class " + externalClass.getName() + " with external policy");
            Method[] methodArray = externalClass.getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (this.isValidExternalFunction.matches(method)) {
                    MethodWrappingFunction function = this.functionFactory.createMethodWrappingFunction(method);
                    boolean functionsOfClassHaveBeenRegistered = this.addExternalFunction(function);
                    functionsHaveBeenRegistered = functionsHaveBeenRegistered ? true : functionsOfClassHaveBeenRegistered;
                }
                ++n2;
            }
            if (functionsHaveBeenRegistered) {
                this.logger.info("Finished the registration of class " + externalClass.getName() + " with external policy");
                continue;
            }
            this.logger.info("Couldn't find any functions for class " + externalClass.getName() + " with external policy");
        }
        return functionsHaveBeenRegistered;
    }

    private boolean addExternalFunction(Function<?> function) {
        Class<?> declaringType = function.getDeclaringType();
        if (!this.externalFunctions.containsKey(declaringType)) {
            this.externalFunctions.put(declaringType, new HashSet());
        }
        this.logger.finer("Registering external function " + function + " for the external class " + declaringType.getName());
        return this.externalFunctions.get(declaringType).add(function);
    }

    @Override
    public boolean unregisterAllFunctionsOf(Iterable<Class<?>> classesToUnregister) {
        boolean functionsHaveBeenUnregistered = false;
        for (Class<?> classToUnregister : classesToUnregister) {
            boolean functionsOfClassHaveBeenUnregistered = this.unregisterAllFunctionsOf(classToUnregister);
            boolean bl = functionsHaveBeenUnregistered = functionsHaveBeenUnregistered ? true : functionsOfClassHaveBeenUnregistered;
        }
        return functionsHaveBeenUnregistered;
    }

    private boolean unregisterAllFunctionsOf(Class<?> classToUnregister) {
        boolean functionsHaveBeenUnregistered = false;
        for (Map<Class<?>, Set<Function<?>>> functionMap : this.functionMaps) {
            boolean functionsOfClassHaveBeenUnregistered = functionMap.remove(classToUnregister) != null;
            boolean bl = functionsHaveBeenUnregistered = functionsHaveBeenUnregistered ? true : functionsOfClassHaveBeenUnregistered;
        }
        return functionsHaveBeenUnregistered;
    }

    @Override
    public IdentityFunction getIdentityFunction() {
        return this.identityFunction;
    }

    @Override
    public Collection<Function<?>> getAllStatistics() {
        return this.asSet(this.statistics);
    }

    private Collection<Function<?>> getStatisticsOf(Class<?> declaringType) {
        return this.statistics.get(declaringType);
    }

    private Collection<Function<?>> getDimensionsOf(Class<?> declaringType) {
        return this.dimensions.get(declaringType);
    }

    private Collection<Function<?>> getExternalFunctionsOf(Class<?> declaringType) {
        return this.externalFunctions.get(declaringType);
    }

    protected Collection<Function<?>> asSet(Map<?, Set<Function<?>>> map) {
        HashSet set = new HashSet();
        for (Map.Entry<?, Set<Function<?>>> entry : map.entrySet()) {
            set.addAll((Collection)entry.getValue());
        }
        return set;
    }

    @Override
    public Collection<Function<?>> getFunctionsFor(Class<?> sourceType) {
        return this.getFunctionsFor(sourceType, Arrays.asList(FunctionRetrievalStrategies.values()));
    }

    @Override
    public Collection<Function<?>> getDimensionsFor(Class<?> sourceType) {
        return this.getFunctionsFor(sourceType, Collections.singleton(FunctionRetrievalStrategies.Dimensions));
    }

    @Override
    public Collection<Function<?>> getStatisticsFor(Class<?> sourceType) {
        return this.getFunctionsFor(sourceType, Collections.singleton(FunctionRetrievalStrategies.Statistics));
    }

    @Override
    public Collection<Function<?>> getExternalFunctionsFor(Class<?> sourceType) {
        return this.getFunctionsFor(sourceType, Collections.singleton(FunctionRetrievalStrategies.ExternalFunctions));
    }

    private Collection<Function<?>> getFunctionsFor(Class<?> sourceType, Iterable<FunctionRetrievalStrategies> retrievalStrategies) {
        Collection<Class<?>> typesToRetrieve = ClassUtils.getSupertypesOf(sourceType);
        typesToRetrieve.remove(Object.class);
        typesToRetrieve.add(sourceType);
        return this.getFunctionsFor(typesToRetrieve, retrievalStrategies);
    }

    private Collection<Function<?>> getFunctionsFor(Collection<Class<?>> typesToRetrieve, Iterable<FunctionRetrievalStrategies> retrievalStrategies) {
        HashSet functions = new HashSet();
        for (Class<?> typeToRetrieve : typesToRetrieve) {
            for (FunctionRetrievalStrategies retrievalStrategy : retrievalStrategies) {
                Collection<Function<?>> typeSpecificFunctions = retrievalStrategy.retrieveFunctions(typeToRetrieve, this);
                if (typeSpecificFunctions == null) continue;
                functions.addAll(typeSpecificFunctions);
            }
        }
        return functions;
    }

    @Override
    public Map<DataRetrieverLevel<?, ?>, Iterable<Function<?>>> getDimensionsMappedByLevelFor(DataRetrieverChainDefinition<?, ?> dataRetrieverChainDefinition) {
        HashMap dimensions = new HashMap();
        List<DataRetrieverLevel<?, ?>> dataRetrieverLevels = dataRetrieverChainDefinition.getDataRetrieverLevels();
        for (DataRetrieverLevel<?, ?> dataRetrieverLevel : dataRetrieverLevels) {
            dimensions.put(dataRetrieverLevel, this.getDimensionsFor(dataRetrieverLevel.getRetrievedDataType()));
        }
        return dimensions;
    }

    @Override
    public ReducedDimensions getReducedDimensionsMappedByLevelFor(DataRetrieverChainDefinition<?, ?> dataRetrieverChainDefinition) {
        Map<DataRetrieverLevel<?, ?>, Iterable<Function<?>>> dimensionsMappedByLevel = this.getDimensionsMappedByLevelFor(dataRetrieverChainDefinition);
        List<DataRetrieverLevel<?, ?>> retrieverLevels = dataRetrieverChainDefinition.getDataRetrieverLevels();
        ReducedDimensions reducedDimensions = new ReducedDimensions();
        for (DataRetrieverLevel<?, ?> retrieverLevel : retrieverLevels) {
            ReducedDimensions reducedDimensionsForLevel;
            DataRetrieverLevel<?, ?> previousRetrieverLevel;
            Iterable<Function<?>> dimensionsOfLevel = dimensionsMappedByLevel.get(retrieverLevel);
            DataRetrieverLevel<?, ?> dataRetrieverLevel = previousRetrieverLevel = retrieverLevel.getLevel() > 0 ? retrieverLevels.get(retrieverLevel.getLevel() - 1) : null;
            if (previousRetrieverLevel == null) {
                assert (reducedDimensions.getReducedDimensions().isEmpty());
                HashMap currentLevelToAllItsDimensions = new HashMap();
                HashMap fromOriginalToReducedDimension = new HashMap();
                currentLevelToAllItsDimensions.put(retrieverLevel, dimensionsOfLevel);
                for (Function<?> dimension : dimensionsOfLevel) {
                    fromOriginalToReducedDimension.put(dimension, dimension);
                }
                reducedDimensionsForLevel = new ReducedDimensions(currentLevelToAllItsDimensions, fromOriginalToReducedDimension);
            } else {
                reducedDimensionsForLevel = this.reduce(dimensionsOfLevel, previousRetrieverLevel, dimensionsMappedByLevel.get(previousRetrieverLevel), retrieverLevel);
            }
            reducedDimensions = reducedDimensions.createByAdd(reducedDimensionsForLevel, true);
        }
        return reducedDimensions;
    }

    private ReducedDimensions reduce(Iterable<Function<?>> dimensionsToReduce, DataRetrieverLevel<?, ?> previousRetrieverLevel, Iterable<Function<?>> previousDimensions, DataRetrieverLevel<?, ?> currentRetrieverLevel) {
        Iterable<Function<?>> reducedDimensions;
        HashMap fromOriginalToReducedDimensions = new HashMap();
        if (Util.isEmpty(previousDimensions)) {
            reducedDimensions = dimensionsToReduce;
            for (Function<?> dimensionToReduce : dimensionsToReduce) {
                fromOriginalToReducedDimensions.put(dimensionToReduce, dimensionToReduce);
            }
        } else {
            HashSet modifiableReducedDimensions = new HashSet();
            reducedDimensions = modifiableReducedDimensions;
            for (Function<?> dimension : dimensionsToReduce) {
                boolean isAllowed = true;
                if (ConcatenatingCompoundFunction.class.isAssignableFrom(dimension.getClass())) {
                    ConcatenatingCompoundFunction compoundDimension = (ConcatenatingCompoundFunction)dimension;
                    List<MethodWrappingFunction<?>> simpleFunctions = compoundDimension.getSimpleFunctions();
                    if (previousRetrieverLevel.getRetrievedDataType().isAssignableFrom(simpleFunctions.get(0).getReturnType())) {
                        Function subFunction;
                        List<MethodWrappingFunction<?>> subList = simpleFunctions.subList(1, simpleFunctions.size());
                        Function function = subFunction = subList.size() == 1 ? (Function)subList.get(0) : this.functionFactory.createCompoundFunction(subList);
                        if (Util.contains(previousDimensions, subFunction)) {
                            isAllowed = false;
                            for (Function<?> previousDimension : previousDimensions) {
                                if (!previousDimension.equals(subFunction)) continue;
                                fromOriginalToReducedDimensions.put(dimension, previousDimension);
                                break;
                            }
                        }
                    }
                }
                if (!isAllowed) continue;
                modifiableReducedDimensions.add(dimension);
                fromOriginalToReducedDimensions.put(dimension, dimension);
            }
        }
        HashMap reducedDimensionsPerRetrieverLevel = new HashMap();
        reducedDimensionsPerRetrieverLevel.put(currentRetrieverLevel, reducedDimensions);
        return new ReducedDimensions(reducedDimensionsPerRetrieverLevel, fromOriginalToReducedDimensions);
    }

    @Override
    public Function<?> getFunctionForDTO(FunctionDTO functionDTO, ClassLoader classLoader) {
        if (this.identityFunctionDTO.equals((Object)functionDTO)) {
            return this.identityFunction;
        }
        Function function = null;
        if (functionDTO != null) {
            try {
                Class<?> sourceType = ClassUtils.getClassForName(functionDTO.getSourceTypeName(), true, classLoader);
                Collection<Function<?>> possibleFunctions = functionDTO.isDimension() ? this.getDimensionsFor(sourceType) : this.getFunctionsFor(sourceType, Arrays.asList(FunctionRetrievalStrategies.ExternalFunctions, FunctionRetrievalStrategies.Statistics));
                if (!possibleFunctions.isEmpty()) {
                    Class<?> returnType = ClassUtils.getClassForName(functionDTO.getReturnTypeName(), true, classLoader);
                    HashSet matchingFunctions = new HashSet();
                    for (Function<?> possibleFunction : possibleFunctions) {
                        if (!returnType.equals(possibleFunction.getReturnType()) || !functionDTO.getFunctionName().equals(possibleFunction.getSimpleName())) continue;
                        matchingFunctions.add(possibleFunction);
                    }
                    if (matchingFunctions.size() == 1) {
                        function = (Function)matchingFunctions.iterator().next();
                    } else if (matchingFunctions.size() > 1) {
                        throw new MultipleDataMiningComponentsFoundForDTOException(functionDTO, matchingFunctions);
                    }
                }
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Couldn't get classes for the function DTO " + functionDTO, e);
            }
        }
        return function;
    }

    private static enum FunctionRetrievalStrategies {
        Dimensions{

            @Override
            public Collection<Function<?>> retrieveFunctions(Class<?> declaringType, FunctionManager manager) {
                return manager.getDimensionsOf(declaringType);
            }
        }
        ,
        Statistics{

            @Override
            public Collection<Function<?>> retrieveFunctions(Class<?> declaringType, FunctionManager manager) {
                return manager.getStatisticsOf(declaringType);
            }
        }
        ,
        ExternalFunctions{

            @Override
            public Collection<Function<?>> retrieveFunctions(Class<?> declaringType, FunctionManager manager) {
                return manager.getExternalFunctionsOf(declaringType);
            }
        };


        public abstract Collection<Function<?>> retrieveFunctions(Class<?> var1, FunctionManager var2);
    }
}

