/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl.components.management;

import com.sap.sse.datamining.components.DataRetrieverChainDefinition;
import com.sap.sse.datamining.components.management.DataRetrieverChainDefinitionRegistry;
import com.sap.sse.datamining.exceptions.MultipleDataMiningComponentsFoundForDTOException;
import com.sap.sse.datamining.impl.components.DataRetrieverLevel;
import com.sap.sse.datamining.shared.impl.dto.DataRetrieverChainDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.DataRetrieverLevelDTO;
import com.sap.sse.datamining.util.ClassUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataRetrieverChainDefinitionManager
implements DataRetrieverChainDefinitionRegistry {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final Map<Class<?>, Set<DataRetrieverChainDefinition<?, ?>>> chainDefinitionsMappedBySourceType = new HashMap();
    private final Map<Class<?>, Set<DataRetrieverChainDefinition<?, ?>>> chainDefinitionsMappedByDataType = new HashMap();

    @Override
    public boolean register(DataRetrieverChainDefinition<?, ?> dataRetrieverChainDefinition) {
        Class<?> sourceType = dataRetrieverChainDefinition.getDataSourceType();
        Class<?> retrievedDataType = dataRetrieverChainDefinition.getRetrievedDataType();
        boolean changedBySource = this.registerToByTypeMap(sourceType, this.chainDefinitionsMappedBySourceType, dataRetrieverChainDefinition);
        boolean changedByData = this.registerToByTypeMap(retrievedDataType, this.chainDefinitionsMappedByDataType, dataRetrieverChainDefinition);
        if (changedByData || changedBySource) {
            StringBuilder logBuilder = new StringBuilder("Registering the data retriever chain definition " + dataRetrieverChainDefinition + " for the ");
            if (changedByData && changedBySource) {
                logBuilder.append("source type " + sourceType.getSimpleName() + " and the retrieved data type " + retrievedDataType.getSimpleName());
            } else if (changedByData) {
                logBuilder.append("retrieved data type " + retrievedDataType.getSimpleName());
            } else {
                logBuilder.append("source type " + sourceType.getSimpleName());
            }
            this.logger.info(logBuilder.toString());
        }
        return changedByData || changedBySource;
    }

    private boolean registerToByTypeMap(Class<?> key, Map<Class<?>, Set<DataRetrieverChainDefinition<?, ?>>> byTypeMap, DataRetrieverChainDefinition<?, ?> dataRetrieverChainDefinition) {
        if (!byTypeMap.containsKey(key)) {
            byTypeMap.put(key, new HashSet());
        }
        return byTypeMap.get(key).add(dataRetrieverChainDefinition);
    }

    @Override
    public boolean unregister(DataRetrieverChainDefinition<?, ?> dataRetrieverChainDefinition) {
        Class<?> sourceType = dataRetrieverChainDefinition.getDataSourceType();
        Class<?> retrievedDataType = dataRetrieverChainDefinition.getRetrievedDataType();
        boolean changedBySource = this.unregisterFromByTypeMap(sourceType, this.chainDefinitionsMappedBySourceType, dataRetrieverChainDefinition);
        boolean changedByData = this.unregisterFromByTypeMap(retrievedDataType, this.chainDefinitionsMappedByDataType, dataRetrieverChainDefinition);
        if (changedByData || changedBySource) {
            StringBuilder logBuilder = new StringBuilder("Unregistering the data retriever chain definition " + dataRetrieverChainDefinition + " for the ");
            if (changedByData && changedBySource) {
                logBuilder.append("source type " + sourceType.getSimpleName() + " and the retrieved data type " + retrievedDataType.getSimpleName());
            } else if (changedByData) {
                logBuilder.append("retrieved data type " + retrievedDataType.getSimpleName());
            } else {
                logBuilder.append("source type " + sourceType.getSimpleName());
            }
            this.logger.info(logBuilder.toString());
        }
        return changedByData || changedBySource;
    }

    private boolean unregisterFromByTypeMap(Class<?> key, Map<Class<?>, Set<DataRetrieverChainDefinition<?, ?>>> byTypeMap, DataRetrieverChainDefinition<?, ?> dataRetrieverChainDefinition) {
        if (byTypeMap.containsKey(key)) {
            return byTypeMap.get(key).remove(dataRetrieverChainDefinition);
        }
        return false;
    }

    @Override
    public Iterable<DataRetrieverChainDefinition<?, ?>> getAll() {
        HashSet chainDefinitions = new HashSet();
        for (Collection collection : this.chainDefinitionsMappedBySourceType.values()) {
            chainDefinitions.addAll(collection);
        }
        for (Collection collection : this.chainDefinitionsMappedByDataType.values()) {
            chainDefinitions.addAll(collection);
        }
        return Collections.unmodifiableSet(chainDefinitions);
    }

    @Override
    public <DataSourceType> Iterable<DataRetrieverChainDefinition<DataSourceType, ?>> getBySourceType(Class<DataSourceType> dataSourceType) {
        if (!this.chainDefinitionsMappedBySourceType.containsKey(dataSourceType)) {
            return new HashSet();
        }
        Set<DataRetrieverChainDefinition<DataSourceType, ?>> retrieverChains = Collections.unmodifiableSet(this.chainDefinitionsMappedBySourceType.get(dataSourceType));
        return retrieverChains;
    }

    @Override
    public <DataType> Iterable<DataRetrieverChainDefinition<?, DataType>> getByDataType(Class<DataType> retrievedDataType) {
        if (!this.chainDefinitionsMappedByDataType.containsKey(retrievedDataType)) {
            return new HashSet();
        }
        Set<DataRetrieverChainDefinition<?, DataType>> retrieverChains = Collections.unmodifiableSet(this.chainDefinitionsMappedByDataType.get(retrievedDataType));
        return retrieverChains;
    }

    @Override
    public <DataSourceType, DataType> Iterable<DataRetrieverChainDefinition<DataSourceType, DataType>> get(Class<DataSourceType> dataSourceType, Class<DataType> retrievedDataType) {
        return Collections.unmodifiableSet(this.getInternalFor(dataSourceType, retrievedDataType));
    }

    @Override
    public <DataSourceType, DataType> DataRetrieverChainDefinition<DataSourceType, DataType> getForDTO(DataRetrieverChainDefinitionDTO retrieverChainDTO, ClassLoader classLoader) {
        DataRetrieverChainDefinition chainDefinition = null;
        if (retrieverChainDTO != null) {
            try {
                Class<?> dataSourceType = ClassUtils.getClassForName(retrieverChainDTO.getDataSourceTypeName(), true, classLoader);
                Class<?> retrievedDataType = ClassUtils.getClassForName(retrieverChainDTO.getRetrievedDataTypeName(), true, classLoader);
                Set<DataRetrieverChainDefinition<?, ?>> possibleChainDefinitions = this.getInternalFor(dataSourceType, retrievedDataType);
                if (!possibleChainDefinitions.isEmpty()) {
                    HashSet matchingChainDefinitions = new HashSet();
                    for (DataRetrieverChainDefinition<?, ?> possibleChainDefinition : possibleChainDefinitions) {
                        List<DataRetrieverLevel<?, ?>> retrieverLevels = possibleChainDefinition.getDataRetrieverLevels();
                        if (retrieverLevels.size() != retrieverChainDTO.getLevelAmount()) continue;
                        boolean matches = true;
                        for (DataRetrieverLevel<?, ?> retrieverLevel : retrieverLevels) {
                            DataRetrieverLevelDTO retrieverLevelDTO = retrieverChainDTO.getRetrieverLevel(retrieverLevel.getLevel());
                            Class<?> retrieverType = ClassUtils.getClassForName(retrieverLevelDTO.getRetrieverTypeName(), true, classLoader);
                            if (retrieverLevel.getRetrieverType().isAssignableFrom(retrieverType)) continue;
                            matches = false;
                            break;
                        }
                        if (!matches) continue;
                        matchingChainDefinitions.add(possibleChainDefinition);
                    }
                    if (matchingChainDefinitions.size() == 1) {
                        chainDefinition = (DataRetrieverChainDefinition)matchingChainDefinitions.iterator().next();
                    } else if (matchingChainDefinitions.size() > 1) {
                        throw new MultipleDataMiningComponentsFoundForDTOException(retrieverChainDTO, matchingChainDefinitions);
                    }
                }
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Couldn't get classes for the retriever chain DTO " + retrieverChainDTO, e);
            }
            if (chainDefinition == null) {
                this.logger.log(Level.WARNING, "No retriever chain definition found for the DTO: " + retrieverChainDTO);
            }
        }
        return chainDefinition;
    }

    private <DataSourceType, DataType> Set<DataRetrieverChainDefinition<DataSourceType, DataType>> getInternalFor(Class<DataSourceType> dataSourceType, Class<DataType> retrievedDataType) {
        HashSet<DataRetrieverChainDefinition<DataSourceType, DataType>> chainDefinitions = new HashSet<DataRetrieverChainDefinition<DataSourceType, DataType>>();
        for (DataRetrieverChainDefinition<DataSourceType, ?> dataRetrieverChainDefinition : this.getBySourceType(dataSourceType)) {
            if (!Objects.equals(retrievedDataType, dataRetrieverChainDefinition.getRetrievedDataType())) continue;
            chainDefinitions.add(dataRetrieverChainDefinition);
        }
        return chainDefinitions;
    }
}

