/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl.components.aggregators;

import com.sap.sse.common.Util;
import com.sap.sse.datamining.components.AggregationProcessorDefinition;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.GroupedDataEntry;
import com.sap.sse.datamining.impl.components.SimpleAggregationProcessorDefinition;
import com.sap.sse.datamining.impl.components.aggregators.AbstractParallelGroupedDataStoringAggregationProcessor;
import com.sap.sse.datamining.shared.GroupKey;
import com.sap.sse.datamining.shared.data.PairWithStats;
import com.sap.sse.datamining.shared.impl.PairWithStatsImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;

public class ParallelGroupedNumberPairAverageAggregationProcessor
extends AbstractParallelGroupedDataStoringAggregationProcessor<Util.Pair, PairWithStats<Number>> {
    private static final Class<?> _c = PairWithStats.class;
    private static final Class<PairWithStats<Number>> _cc = _c;
    private static final AggregationProcessorDefinition<Util.Pair, PairWithStats<Number>> DEFINITION = new SimpleAggregationProcessorDefinition<Util.Pair, PairWithStats<Number>>(Util.Pair.class, _cc, "Average", ParallelGroupedNumberPairAverageAggregationProcessor.class);
    private final Map<GroupKey, Util.Pair<Number, Number>> sumPerKey;
    private final Map<GroupKey, Util.Pair<Number, Number>> minPerKey;
    private final Map<GroupKey, Util.Pair<Number, Number>> maxPerKey;
    private final Map<GroupKey, AtomicLong> elementAmountPerKey = new HashMap<GroupKey, AtomicLong>();

    public static AggregationProcessorDefinition<Util.Pair, PairWithStats<Number>> getDefinition() {
        return DEFINITION;
    }

    public ParallelGroupedNumberPairAverageAggregationProcessor(ExecutorService executor, Collection<Processor<Map<GroupKey, PairWithStats<Number>>, ?>> resultReceivers) {
        super(executor, resultReceivers, "PairAverage");
        this.sumPerKey = new HashMap<GroupKey, Util.Pair<Number, Number>>();
        this.minPerKey = new HashMap<GroupKey, Util.Pair<Number, Number>>();
        this.maxPerKey = new HashMap<GroupKey, Util.Pair<Number, Number>>();
    }

    @Override
    protected void storeElement(GroupedDataEntry<Util.Pair> element) {
        if (element.getDataEntry() != null) {
            Double doubleValueB;
            this.incrementElementAmount(element);
            Util.Pair aggregate = this.sumPerKey.get(element.getKey());
            Number a = (Number)element.getDataEntry().getA();
            Number b = (Number)element.getDataEntry().getB();
            Double doubleValueA = a == null ? null : Double.valueOf(a.doubleValue());
            Double d = doubleValueB = b == null ? null : Double.valueOf(b.doubleValue());
            if (doubleValueA != null && doubleValueB != null) {
                if (aggregate == null) {
                    aggregate = new Util.Pair((Object)doubleValueA, (Object)doubleValueB);
                    this.sumPerKey.put(element.getKey(), (Util.Pair<Number, Number>)aggregate);
                } else {
                    this.sumPerKey.put(element.getKey(), (Util.Pair<Number, Number>)new Util.Pair((Object)(doubleValueA + ((Number)aggregate.getA()).doubleValue()), (Object)(doubleValueB + ((Number)aggregate.getB()).doubleValue())));
                }
                if (!this.minPerKey.containsKey(element.getKey()) || doubleValueA < ((Number)this.minPerKey.get(element.getKey()).getA()).doubleValue() && doubleValueB < ((Number)this.minPerKey.get(element.getKey()).getB()).doubleValue()) {
                    this.minPerKey.put(element.getKey(), (Util.Pair<Number, Number>)new Util.Pair((Object)doubleValueA, (Object)doubleValueB));
                }
                if (!this.maxPerKey.containsKey(element.getKey()) || doubleValueA > ((Number)this.maxPerKey.get(element.getKey()).getA()).doubleValue() && doubleValueB > ((Number)this.maxPerKey.get(element.getKey()).getB()).doubleValue()) {
                    this.maxPerKey.put(element.getKey(), (Util.Pair<Number, Number>)new Util.Pair((Object)doubleValueA, (Object)doubleValueB));
                }
            }
        }
    }

    private void incrementElementAmount(GroupedDataEntry<Util.Pair> element) {
        GroupKey key = element.getKey();
        AtomicLong currentAmount = this.elementAmountPerKey.get(key);
        if (currentAmount == null) {
            this.elementAmountPerKey.put(key, new AtomicLong(1L));
        } else {
            currentAmount.incrementAndGet();
        }
    }

    @Override
    protected Map<GroupKey, PairWithStats<Number>> aggregateResult() {
        HashMap<GroupKey, PairWithStats<Number>> result = new HashMap<GroupKey, PairWithStats<Number>>();
        for (Map.Entry<GroupKey, Util.Pair<Number, Number>> sumAggregationEntry : this.sumPerKey.entrySet()) {
            if (this.isAborted()) break;
            GroupKey key = sumAggregationEntry.getKey();
            result.put(key, (PairWithStats<Number>)new PairWithStatsImpl(new Util.Pair(sumAggregationEntry.getValue().getA() != null ? Double.valueOf(((Number)sumAggregationEntry.getValue().getA()).doubleValue() / (double)this.elementAmountPerKey.get(key).get()) : null, sumAggregationEntry.getValue().getB() != null ? Double.valueOf(((Number)sumAggregationEntry.getValue().getB()).doubleValue() / (double)this.elementAmountPerKey.get(key).get()) : null), this.minPerKey.get(key), this.maxPerKey.get(key), null, null, null, this.elementAmountPerKey.get(key).get(), Util.Pair.class.getName()));
        }
        return result;
    }
}

