/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl.components.aggregators;

import com.sap.sse.datamining.components.AggregationProcessorDefinition;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.GroupedDataEntry;
import com.sap.sse.datamining.impl.components.SimpleAggregationProcessorDefinition;
import com.sap.sse.datamining.impl.components.aggregators.AbstractParallelGroupedDataStoringAggregationProcessor;
import com.sap.sse.datamining.shared.GroupKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class ParallelGroupedNumberDataMedianAggregationProcessor
extends AbstractParallelGroupedDataStoringAggregationProcessor<Number, Number> {
    private static final AggregationProcessorDefinition<Number, Number> DEFINITION = new SimpleAggregationProcessorDefinition<Number, Number>(Number.class, Number.class, "Median", ParallelGroupedNumberDataMedianAggregationProcessor.class);
    private Map<GroupKey, List<Number>> groupedValues = new HashMap<GroupKey, List<Number>>();

    public static AggregationProcessorDefinition<Number, Number> getDefinition() {
        return DEFINITION;
    }

    public ParallelGroupedNumberDataMedianAggregationProcessor(ExecutorService executor, Collection<Processor<Map<GroupKey, Number>, ?>> resultReceivers) {
        super(executor, resultReceivers, "Median");
    }

    @Override
    protected void storeElement(GroupedDataEntry<Number> element) {
        GroupKey key = element.getKey();
        if (!this.groupedValues.containsKey(key)) {
            this.groupedValues.put(key, new ArrayList());
        }
        this.groupedValues.get(key).add(element.getDataEntry());
    }

    @Override
    protected Map<GroupKey, Number> aggregateResult() {
        HashMap<GroupKey, Number> result = new HashMap<GroupKey, Number>();
        for (Map.Entry<GroupKey, List<Number>> groupedValuesEntry : this.groupedValues.entrySet()) {
            if (this.isAborted()) break;
            result.put(groupedValuesEntry.getKey(), this.getMedianOf(groupedValuesEntry.getValue()));
        }
        return result;
    }

    private Double getMedianOf(List<Number> values) {
        Collections.sort(values, new Comparator<Number>(){

            @Override
            public int compare(Number n1, Number n2) {
                return Double.compare(n1.doubleValue(), n2.doubleValue());
            }
        });
        if (this.listSizeIsEven(values)) {
            int index1 = values.size() / 2 - 1;
            int index2 = index1 + 1;
            return (values.get(index1).doubleValue() + values.get(index2).doubleValue()) / 2.0;
        }
        int index = (values.size() + 1) / 2 - 1;
        return values.get(index).doubleValue();
    }

    private boolean listSizeIsEven(List<?> values) {
        return values.size() % 2 == 0;
    }
}

