/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl.components.aggregators;

import com.sap.sse.datamining.components.AdditionalResultDataBuilder;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.components.ProcessorInstruction;
import com.sap.sse.datamining.impl.components.AbstractParallelProcessor;
import com.sap.sse.datamining.impl.components.AbstractProcessorInstruction;
import com.sap.sse.datamining.impl.components.ProcessorInstructionPriority;
import java.util.Collection;
import java.util.concurrent.ExecutorService;

public abstract class AbstractParallelAggregationProcessor<InputType, AggregatedType>
extends AbstractParallelProcessor<InputType, AggregatedType> {
    private final String aggregationNameMessageKey;
    private final Object monitor;

    public AbstractParallelAggregationProcessor(Class<InputType> inputType, Class<AggregatedType> resultType, ExecutorService executor, Collection<Processor<AggregatedType, ?>> resultReceivers, String aggregationNameMessageKey) {
        super(inputType, resultType, executor, resultReceivers);
        this.aggregationNameMessageKey = aggregationNameMessageKey;
        this.monitor = new Object();
    }

    @Override
    protected ProcessorInstruction<AggregatedType> createInstruction(final InputType element) {
        if (this.needsSynchronization()) {
            return new AbstractProcessorInstruction<AggregatedType>(this, ProcessorInstructionPriority.Aggregation){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public AggregatedType computeResult() {
                    Object object = AbstractParallelAggregationProcessor.this.monitor;
                    synchronized (object) {
                        AbstractParallelAggregationProcessor.this.handleElement(element);
                    }
                    return AbstractParallelAggregationProcessor.super.createInvalidResult();
                }
            };
        }
        return new AbstractProcessorInstruction<AggregatedType>(this, ProcessorInstructionPriority.Aggregation){

            @Override
            protected AggregatedType computeResult() throws Exception {
                AbstractParallelAggregationProcessor.this.handleElement(element);
                return AbstractParallelAggregationProcessor.super.createInvalidResult();
            }
        };
    }

    protected boolean needsSynchronization() {
        return true;
    }

    protected abstract void handleElement(InputType var1);

    @Override
    public void finish() throws InterruptedException {
        super.sleepUntilAllInstructionsFinished();
        super.forwardResultToReceivers(this.getResult());
        super.tellResultReceiversToFinish();
    }

    protected abstract AggregatedType getResult();

    @Override
    protected void setAdditionalData(AdditionalResultDataBuilder additionalDataBuilder) {
        additionalDataBuilder.setAggregationNameMessageKey(this.aggregationNameMessageKey);
    }
}

