/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl.components;

import com.sap.sse.datamining.components.AdditionalResultDataBuilder;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.components.ProcessorInstruction;
import com.sap.sse.datamining.functions.Function;
import com.sap.sse.datamining.functions.ParameterProvider;
import com.sap.sse.datamining.impl.components.AbstractParallelProcessor;
import com.sap.sse.datamining.impl.components.AbstractProcessorInstruction;
import com.sap.sse.datamining.impl.components.GroupedDataEntry;
import com.sap.sse.datamining.impl.components.ProcessorInstructionPriority;
import java.util.Collection;
import java.util.concurrent.ExecutorService;

public class ParallelGroupedElementsValueExtractionProcessor<DataType, FunctionReturnType>
extends AbstractParallelProcessor<GroupedDataEntry<DataType>, GroupedDataEntry<FunctionReturnType>> {
    private final Function<FunctionReturnType> extractionFunction;
    private final ParameterProvider parameterProvider;

    public ParallelGroupedElementsValueExtractionProcessor(ExecutorService executor, Collection<Processor<GroupedDataEntry<FunctionReturnType>, ?>> resultReceivers, Function<FunctionReturnType> extractionFunction) {
        this(executor, resultReceivers, extractionFunction, ParameterProvider.NULL);
    }

    public ParallelGroupedElementsValueExtractionProcessor(ExecutorService executor, Collection<Processor<GroupedDataEntry<FunctionReturnType>, ?>> resultReceivers, Function<FunctionReturnType> extractionFunction, ParameterProvider parameterProvider) {
        super(GroupedDataEntry.class, GroupedDataEntry.class, executor, resultReceivers);
        this.extractionFunction = extractionFunction;
        this.parameterProvider = parameterProvider;
    }

    @Override
    protected ProcessorInstruction<GroupedDataEntry<FunctionReturnType>> createInstruction(final GroupedDataEntry<DataType> element) {
        return new AbstractProcessorInstruction<GroupedDataEntry<FunctionReturnType>>(this, ProcessorInstructionPriority.Extraction){

            @Override
            public GroupedDataEntry<FunctionReturnType> computeResult() {
                Object value = ParallelGroupedElementsValueExtractionProcessor.this.extractionFunction.tryToInvoke(element.getDataEntry(), ParallelGroupedElementsValueExtractionProcessor.this.parameterProvider);
                return value != null ? new GroupedDataEntry(element.getKey(), value) : (GroupedDataEntry)ParallelGroupedElementsValueExtractionProcessor.super.createInvalidResult();
            }
        };
    }

    @Override
    protected void setAdditionalData(AdditionalResultDataBuilder additionalDataBuilder) {
        additionalDataBuilder.setExtractionFunction(this.extractionFunction);
    }
}

