/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl.components;

import com.sap.sse.datamining.components.AdditionalResultDataBuilder;
import com.sap.sse.datamining.components.FilterCriterion;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.components.ProcessorInstruction;
import com.sap.sse.datamining.impl.components.AbstractParallelProcessor;
import com.sap.sse.datamining.impl.components.AbstractProcessorInstruction;
import com.sap.sse.datamining.impl.components.ProcessorInstructionPriority;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;

public class ParallelFilteringProcessor<InputType>
extends AbstractParallelProcessor<InputType, InputType> {
    private final FilterCriterion<InputType> filterCriterion;
    private final AtomicInteger filteredDataAmount;

    public ParallelFilteringProcessor(Class<InputType> inputType, ExecutorService executor, Collection<Processor<InputType, ?>> resultReceivers, FilterCriterion<InputType> filterCriterion) {
        super(inputType, inputType, executor, resultReceivers);
        this.filterCriterion = filterCriterion;
        this.filteredDataAmount = new AtomicInteger();
    }

    @Override
    protected ProcessorInstruction<InputType> createInstruction(final InputType element) {
        return new AbstractProcessorInstruction<InputType>(this, ProcessorInstructionPriority.Filtration){

            @Override
            public InputType computeResult() {
                if (ParallelFilteringProcessor.this.filterCriterion.matches(element)) {
                    return element;
                }
                ParallelFilteringProcessor.this.filteredDataAmount.incrementAndGet();
                return ParallelFilteringProcessor.super.createInvalidResult();
            }
        };
    }

    @Override
    protected void setAdditionalData(AdditionalResultDataBuilder additionalDataBuilder) {
        int retrievedDataAmount = additionalDataBuilder.getRetrievedDataAmount();
        additionalDataBuilder.setRetrievedDataAmount(retrievedDataAmount - this.filteredDataAmount.get());
    }
}

