/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.queclinkadapter.tracker;

import com.sap.sailing.domain.queclinkadapter.ByteStreamToMessageStreamConverter;
import com.sap.sailing.domain.queclinkadapter.Message;
import com.sap.sailing.domain.queclinkadapter.tracker.MessageToDeviceSender;
import com.sap.sailing.domain.queclinkadapter.tracker.MessageVisitorWithSensorFixStore;
import com.sap.sailing.domain.racelog.tracking.SensorFixStore;
import com.sap.sailing.domain.racelogtracking.SmartphoneImeiIdentifier;
import com.sap.sailing.udpconnector.UDPMessage;
import com.sap.sailing.udpconnector.UDPMessageListener;
import com.sap.sailing.udpconnector.UDPMessageParser;
import com.sap.sailing.udpconnector.UDPReceiver;
import com.sap.sse.common.Util;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;

public class QueclinkUDPTracker
implements UDPMessageListener<MessageAsUDPMessage>,
MessageToDeviceSender {
    private static final Logger logger = Logger.getLogger(QueclinkUDPTracker.class.getName());
    private final UDPReceiver<MessageAsUDPMessage, QueclinkUDPTracker> udpReceiver;
    private final Charset charset;
    private ByteStreamToMessageStreamConverter converter;
    private final SensorFixStore sensorFixStore;
    private final ConcurrentMap<String, Util.Pair<DatagramSocket, SocketAddress>> socketAddressesByImei;

    public QueclinkUDPTracker(int port, SensorFixStore sensorFixStore) throws SocketException {
        this(port, Charset.forName("ISO-8859-1"), sensorFixStore);
    }

    public QueclinkUDPTracker(int port, final Charset charset, SensorFixStore sensorFixStore) throws SocketException {
        this.charset = charset;
        this.sensorFixStore = sensorFixStore;
        this.socketAddressesByImei = new ConcurrentHashMap<String, Util.Pair<DatagramSocket, SocketAddress>>();
        this.converter = ByteStreamToMessageStreamConverter.create();
        this.udpReceiver = new UDPReceiver<MessageAsUDPMessage, QueclinkUDPTracker>(port){

            protected UDPMessageParser<MessageAsUDPMessage> getParser() {
                return new UDPMessageParser<MessageAsUDPMessage>(){

                    public MessageAsUDPMessage parse(DatagramPacket p) throws IOException {
                        logger.fine(() -> "Received a packet of length " + p.getLength() + " from " + p.getAddress());
                        try {
                            return new MessageAsUDPMessage(QueclinkUDPTracker.this.converter.convert(charset.decode(ByteBuffer.wrap(p.getData(), 0, p.getLength()))), this.getSocket(), p.getSocketAddress());
                        }
                        catch (ParseException e) {
                            throw new IOException(e);
                        }
                    }
                };
            }
        };
        this.udpReceiver.addListener((UDPMessageListener)this, true);
        Thread t = new Thread((Runnable)this.udpReceiver, "Queclink UDP receiver on port " + this.getPort());
        t.setDaemon(true);
        logger.info("Starting Queclink UDP listener thread for port " + this.getPort());
        t.start();
    }

    @Override
    public void sendToDevice(SmartphoneImeiIdentifier deviceIdentifier, Message message) throws IOException {
        String imei = deviceIdentifier.getImei();
        Util.Pair socketAddress = (Util.Pair)this.socketAddressesByImei.get(imei);
        if (socketAddress == null) {
            throw new IllegalStateException("No connection exists to the device with IMEI " + imei + "; cannot send message " + message.getMessageString());
        }
        ByteBuffer bytesToSend = this.charset.encode(message.getMessageString());
        byte[] bytes = new byte[bytesToSend.limit()];
        bytesToSend.get(bytes);
        DatagramPacket packet = new DatagramPacket(bytes, bytes.length, (SocketAddress)socketAddress.getB());
        ((DatagramSocket)socketAddress.getA()).send(packet);
    }

    public void received(MessageAsUDPMessage message) {
        logger.fine(() -> "Received a message with " + Util.size(message.getMessages()) + " Queclink messages from " + message.getSender());
        MessageVisitorWithSensorFixStore<Util.Pair> storeFixVisitor = new MessageVisitorWithSensorFixStore<Util.Pair>(this.sensorFixStore, this, this.socketAddressesByImei, new Util.Pair((Object)message.getSocket(), (Object)message.getSender()));
        message.getMessages().forEach(m -> {
            Object t = m.accept(storeFixVisitor);
        });
    }

    public int getPort() {
        return this.udpReceiver.getPort();
    }

    public void stop() throws SocketException, IOException {
        this.udpReceiver.stop();
    }

    static class MessageAsUDPMessage
    implements UDPMessage {
        private final Iterable<Message> message;
        private final DatagramSocket datagramSocket;
        private final SocketAddress sender;

        public MessageAsUDPMessage(Iterable<Message> iterable, DatagramSocket datagramSocket, SocketAddress sender) {
            this.message = iterable;
            this.datagramSocket = datagramSocket;
            this.sender = sender;
        }

        Iterable<Message> getMessages() {
            return this.message;
        }

        SocketAddress getSender() {
            return this.sender;
        }

        DatagramSocket getSocket() {
            return this.datagramSocket;
        }

        public boolean isValid() {
            return true;
        }
    }
}

