/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.serial;

import java.io.IOException;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.UTFUtils;
import org.jboss.marshalling.serial.ExtendedObjectStreamConstants;
import org.jboss.marshalling.serial.SerialMarshaller;

final class BlockMarshaller
implements Marshaller,
ExtendedObjectStreamConstants {
    private final SerialMarshaller serialMarshaller;
    private final byte[] buffer;
    private int position;

    BlockMarshaller(SerialMarshaller marshaller, int bufferSize) {
        this.serialMarshaller = marshaller;
        this.buffer = new byte[bufferSize];
    }

    @Override
    public void start(ByteOutput newOutput) throws IOException {
        throw new IllegalStateException("start() not allowed in this context");
    }

    @Override
    public void clearInstanceCache() throws IOException {
        throw new IllegalStateException("clearInstanceCache() not allowed in this context");
    }

    @Override
    public void clearClassCache() throws IOException {
        throw new IllegalStateException("clearClassCache() not allowed in this context");
    }

    @Override
    public void finish() throws IOException {
        throw new IllegalStateException("finish() not allowed in this context");
    }

    @Override
    public void writeObject(Object obj) throws IOException {
        this.doWriteObject(obj, false);
    }

    @Override
    public void writeObjectUnshared(Object obj) throws IOException {
        this.doWriteObject(obj, true);
    }

    private void doWriteObject(Object obj, boolean unshared) throws IOException {
        this.flush();
        this.serialMarshaller.doWriteObject(obj, unshared);
        this.flush();
    }

    @Override
    public void write(int v) throws IOException {
        byte[] buffer = this.buffer;
        int remaining = buffer.length - this.position;
        if (remaining == 0) {
            this.flush();
            buffer[0] = (byte)v;
            this.position = 1;
        } else {
            buffer[this.position++] = (byte)v;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        int bl = this.buffer.length;
        int position = this.position;
        if (len > bl - position || len > bl >> 1) {
            this.flush();
            if (len > 256) {
                this.serialMarshaller.write(122);
                this.serialMarshaller.writeInt(len);
                this.serialMarshaller.write(bytes, off, len);
            } else if (len > 0) {
                this.serialMarshaller.write(119);
                this.serialMarshaller.write(len);
                this.serialMarshaller.write(bytes, off, len);
            }
        } else {
            System.arraycopy(bytes, off, this.buffer, position, len);
            this.position = position + len;
        }
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        byte[] buffer = this.buffer;
        int remaining = buffer.length - this.position;
        if (remaining == 0) {
            this.flush();
            buffer[0] = (byte)(v ? 1 : 0);
            this.position = 1;
        } else {
            buffer[this.position++] = (byte)(v ? 1 : 0);
        }
    }

    @Override
    public void writeByte(int v) throws IOException {
        byte[] buffer = this.buffer;
        int remaining = buffer.length - this.position;
        if (remaining == 0) {
            this.flush();
            buffer[0] = (byte)v;
            this.position = 1;
        } else {
            buffer[this.position++] = (byte)v;
        }
    }

    @Override
    public void writeShort(int v) throws IOException {
        byte[] buffer = this.buffer;
        int remaining = buffer.length - this.position;
        if (remaining < 2) {
            this.flush();
            buffer[0] = (byte)(v >> 8);
            buffer[1] = (byte)v;
            this.position = 2;
        } else {
            int s = this.position;
            this.position = s + 2;
            buffer[s] = (byte)(v >> 8);
            buffer[s + 1] = (byte)v;
        }
    }

    @Override
    public void writeChar(int v) throws IOException {
        byte[] buffer = this.buffer;
        int remaining = buffer.length - this.position;
        if (remaining < 2) {
            this.flush();
            buffer[0] = (byte)(v >> 8);
            buffer[1] = (byte)v;
            this.position = 2;
        } else {
            int s = this.position;
            this.position = s + 2;
            buffer[s] = (byte)(v >> 8);
            buffer[s + 1] = (byte)v;
        }
    }

    @Override
    public void writeInt(int v) throws IOException {
        byte[] buffer = this.buffer;
        int remaining = buffer.length - this.position;
        if (remaining < 4) {
            this.flush();
            buffer[0] = (byte)(v >> 24);
            buffer[1] = (byte)(v >> 16);
            buffer[2] = (byte)(v >> 8);
            buffer[3] = (byte)v;
            this.position = 4;
        } else {
            int s = this.position;
            this.position = s + 4;
            buffer[s] = (byte)(v >> 24);
            buffer[s + 1] = (byte)(v >> 16);
            buffer[s + 2] = (byte)(v >> 8);
            buffer[s + 3] = (byte)v;
        }
    }

    @Override
    public void writeLong(long v) throws IOException {
        byte[] buffer = this.buffer;
        int remaining = buffer.length - this.position;
        if (remaining < 8) {
            this.flush();
            buffer[0] = (byte)(v >> 56);
            buffer[1] = (byte)(v >> 48);
            buffer[2] = (byte)(v >> 40);
            buffer[3] = (byte)(v >> 32);
            buffer[4] = (byte)(v >> 24);
            buffer[5] = (byte)(v >> 16);
            buffer[6] = (byte)(v >> 8);
            buffer[7] = (byte)v;
            this.position = 8;
        } else {
            int s = this.position;
            this.position = s + 8;
            buffer[s] = (byte)(v >> 56);
            buffer[s + 1] = (byte)(v >> 48);
            buffer[s + 2] = (byte)(v >> 40);
            buffer[s + 3] = (byte)(v >> 32);
            buffer[s + 4] = (byte)(v >> 24);
            buffer[s + 5] = (byte)(v >> 16);
            buffer[s + 6] = (byte)(v >> 8);
            buffer[s + 7] = (byte)v;
        }
    }

    @Override
    public void writeFloat(float v) throws IOException {
        int bits = Float.floatToIntBits(v);
        byte[] buffer = this.buffer;
        int remaining = buffer.length - this.position;
        if (remaining < 4) {
            this.flush();
            buffer[0] = (byte)(bits >> 24);
            buffer[1] = (byte)(bits >> 16);
            buffer[2] = (byte)(bits >> 8);
            buffer[3] = (byte)bits;
            this.position = 4;
        } else {
            int s = this.position;
            this.position = s + 4;
            buffer[s] = (byte)(bits >> 24);
            buffer[s + 1] = (byte)(bits >> 16);
            buffer[s + 2] = (byte)(bits >> 8);
            buffer[s + 3] = (byte)bits;
        }
    }

    @Override
    public void writeDouble(double v) throws IOException {
        long bits = Double.doubleToLongBits(v);
        byte[] buffer = this.buffer;
        int remaining = buffer.length - this.position;
        if (remaining < 8) {
            this.flush();
            buffer[0] = (byte)(bits >> 56);
            buffer[1] = (byte)(bits >> 48);
            buffer[2] = (byte)(bits >> 40);
            buffer[3] = (byte)(bits >> 32);
            buffer[4] = (byte)(bits >> 24);
            buffer[5] = (byte)(bits >> 16);
            buffer[6] = (byte)(bits >> 8);
            buffer[7] = (byte)bits;
            this.position = 8;
        } else {
            int s = this.position;
            this.position = s + 8;
            buffer[s] = (byte)(bits >> 56);
            buffer[s + 1] = (byte)(bits >> 48);
            buffer[s + 2] = (byte)(bits >> 40);
            buffer[s + 3] = (byte)(bits >> 32);
            buffer[s + 4] = (byte)(bits >> 24);
            buffer[s + 5] = (byte)(bits >> 16);
            buffer[s + 6] = (byte)(bits >> 8);
            buffer[s + 7] = (byte)bits;
        }
    }

    @Override
    public void writeBytes(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.write(s.charAt(i));
        }
    }

    @Override
    public void writeChars(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.writeChar(s.charAt(i));
        }
    }

    @Override
    public void writeUTF(String s) throws IOException {
        int len = UTFUtils.getShortUTFLength(s);
        int position = this.position;
        int bufsize = this.buffer.length;
        int remaining = bufsize - position;
        if (len > bufsize >> 1 || len + 2 > remaining) {
            this.flush();
            if (len < 253) {
                this.serialMarshaller.write(119);
                this.serialMarshaller.write(len + 2);
                this.serialMarshaller.writeShort(len);
                UTFUtils.writeUTFBytes(this.serialMarshaller, s);
            } else {
                this.serialMarshaller.write(122);
                this.serialMarshaller.writeInt(len + 2);
                this.serialMarshaller.writeShort(len);
                UTFUtils.writeUTFBytes(this.serialMarshaller, s);
            }
        } else {
            this.writeShort(len);
            UTFUtils.writeUTFBytes(this, s);
        }
    }

    @Override
    public void flush() throws IOException {
        int position = this.position;
        if (position > 256) {
            this.serialMarshaller.write(122);
            this.serialMarshaller.writeInt(position);
            this.serialMarshaller.writeNoBlockFlush(this.buffer, 0, position);
        } else if (position > 0) {
            this.serialMarshaller.write(119);
            this.serialMarshaller.write(position);
            this.serialMarshaller.writeNoBlockFlush(this.buffer, 0, position);
        }
        this.position = 0;
    }

    @Override
    public void close() throws IOException {
    }
}

