/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.swisstimingadapter.impl;

import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.CompetitorAndBoatStore;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.base.impl.DynamicCompetitor;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.TrackedRaceStatusEnum;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.impl.WindImpl;
import com.sap.sailing.domain.common.impl.WindSourceWithAdditionalID;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.markpassinghash.MarkPassingRaceFingerprintRegistry;
import com.sap.sailing.domain.racelog.RaceLogAndTrackedRaceResolver;
import com.sap.sailing.domain.racelog.RaceLogStore;
import com.sap.sailing.domain.regattalog.RegattaLogStore;
import com.sap.sailing.domain.shared.tracking.TrackingConnectorInfo;
import com.sap.sailing.domain.shared.tracking.impl.TrackingConnectorInfoImpl;
import com.sap.sailing.domain.swisstimingadapter.Competitor;
import com.sap.sailing.domain.swisstimingadapter.Course;
import com.sap.sailing.domain.swisstimingadapter.DomainFactory;
import com.sap.sailing.domain.swisstimingadapter.Fix;
import com.sap.sailing.domain.swisstimingadapter.Race;
import com.sap.sailing.domain.swisstimingadapter.RaceStatus;
import com.sap.sailing.domain.swisstimingadapter.RacingStatus;
import com.sap.sailing.domain.swisstimingadapter.SailMasterConnector;
import com.sap.sailing.domain.swisstimingadapter.SailMasterListener;
import com.sap.sailing.domain.swisstimingadapter.StartList;
import com.sap.sailing.domain.swisstimingadapter.SwissTimingAdapter;
import com.sap.sailing.domain.swisstimingadapter.SwissTimingFactory;
import com.sap.sailing.domain.swisstimingadapter.SwissTimingRaceTracker;
import com.sap.sailing.domain.swisstimingadapter.impl.CourseImpl;
import com.sap.sailing.domain.swisstimingadapter.impl.RaceImpl;
import com.sap.sailing.domain.swisstimingadapter.impl.SwissTimingTrackingConnectivityParameters;
import com.sap.sailing.domain.swisstimingadapter.impl.TMDMessageQueue;
import com.sap.sailing.domain.tracking.AbstractRaceTrackerImpl;
import com.sap.sailing.domain.tracking.DynamicGPSFixTrack;
import com.sap.sailing.domain.tracking.DynamicRaceDefinitionSet;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.DynamicTrackedRegatta;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.RaceHandle;
import com.sap.sailing.domain.tracking.RaceTracker;
import com.sap.sailing.domain.tracking.RaceTrackingConnectivityParameters;
import com.sap.sailing.domain.tracking.RaceTrackingHandler;
import com.sap.sailing.domain.tracking.TrackedRaceStatus;
import com.sap.sailing.domain.tracking.TrackedRegatta;
import com.sap.sailing.domain.tracking.TrackedRegattaRegistry;
import com.sap.sailing.domain.tracking.TrackingDataLoader;
import com.sap.sailing.domain.tracking.WindStore;
import com.sap.sailing.domain.tracking.impl.TrackedRaceStatusImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import difflib.PatchFailedException;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SwissTimingRaceTrackerImpl
extends AbstractRaceTrackerImpl<SwissTimingTrackingConnectivityParameters>
implements SwissTimingRaceTracker,
SailMasterListener,
TrackingDataLoader {
    private static final Logger logger = Logger.getLogger(SwissTimingRaceTrackerImpl.class.getName());
    private final SailMasterConnector connector;
    private final String raceID;
    private final String raceName;
    private final String raceDescription;
    private final BoatClass boatClass;
    private final DomainFactory domainFactory;
    private final Util.Triple<String, String, Integer> id;
    private final Regatta regatta;
    private final WindStore windStore;
    private final boolean startListFromManage2Sail;
    private final boolean useInternalMarkPassingAlgorithm;
    private volatile RaceDefinition race;
    private Course course;
    private StartList startList;
    private Map<String, com.sap.sailing.domain.base.Competitor> competitorsByBoatId;
    private DynamicTrackedRace trackedRace;
    private final DynamicTrackedRegatta trackedRegatta;
    private boolean loggedIgnore;
    private final long delayToLiveInMillis;
    private final TMDMessageQueue tmdMessageQueue;
    private final RaceLogAndTrackedRaceResolver raceLogResolver;
    private final MarkPassingRaceFingerprintRegistry markPassingRaceFingerprintRegistry;
    private final String updateURL;
    private final String apiToken;
    private final RaceTrackingHandler raceTrackingHandler;
    private final TrackedRegattaRegistry trackedRegattaRegistry;

    protected SwissTimingRaceTrackerImpl(RaceLogStore raceLogStore, RegattaLogStore regattaLogStore, WindStore windStore, DomainFactory domainFactory, SwissTimingFactory factory, TrackedRegattaRegistry trackedRegattaRegistry, RaceLogAndTrackedRaceResolver raceLogResolver, SwissTimingTrackingConnectivityParameters connectivityParams, RaceTrackingHandler raceTrackingHandler, MarkPassingRaceFingerprintRegistry markPassingRaceFingerprintRegistry) throws InterruptedException, UnknownHostException, IOException, ParseException, URISyntaxException {
        this(null, windStore, domainFactory, factory, trackedRegattaRegistry, raceLogStore, regattaLogStore, raceLogResolver, connectivityParams, raceTrackingHandler, markPassingRaceFingerprintRegistry);
    }

    protected SwissTimingRaceTrackerImpl(Regatta regatta, WindStore windStore, DomainFactory domainFactory, SwissTimingFactory factory, TrackedRegattaRegistry trackedRegattaRegistry, RaceLogStore raceLogStore, RegattaLogStore regattaLogStore, RaceLogAndTrackedRaceResolver raceLogResolver, SwissTimingTrackingConnectivityParameters connectivityParams, RaceTrackingHandler raceTrackingHandler, MarkPassingRaceFingerprintRegistry markPassingRaceFingerprintRegistry) throws InterruptedException, UnknownHostException, IOException, ParseException, URISyntaxException {
        super((RaceTrackingConnectivityParameters)connectivityParams);
        this.raceLogResolver = raceLogResolver;
        this.raceTrackingHandler = raceTrackingHandler;
        this.tmdMessageQueue = new TMDMessageQueue(this);
        this.trackedRegattaRegistry = trackedRegattaRegistry;
        this.markPassingRaceFingerprintRegistry = markPassingRaceFingerprintRegistry;
        Regatta effectiveRegatta = regatta == null ? trackedRegattaRegistry.getRememberedRegattaForRace((Serializable)((Object)connectivityParams.getRaceID())) : regatta;
        this.regatta = effectiveRegatta == null ? domainFactory.getOrCreateDefaultRegatta(raceLogStore, regattaLogStore, connectivityParams.getRaceID(), connectivityParams.getBoatClass(), trackedRegattaRegistry) : effectiveRegatta;
        this.domainFactory = domainFactory;
        this.raceID = connectivityParams.getRaceID();
        this.course = new CourseImpl(this.raceID, Collections.emptyList());
        this.raceName = connectivityParams.getRaceName();
        this.startList = connectivityParams.getStartList();
        this.startListFromManage2Sail = connectivityParams.getStartList() != null;
        this.raceDescription = connectivityParams.getRaceDescription();
        this.boatClass = connectivityParams.getBoatClass();
        this.windStore = windStore;
        this.id = SwissTimingRaceTrackerImpl.createID(connectivityParams.getRaceID(), connectivityParams.getHostname(), connectivityParams.getPort());
        this.trackedRegatta = trackedRegattaRegistry.getOrCreateTrackedRegatta(this.regatta);
        this.delayToLiveInMillis = connectivityParams.getDelayToLiveInMillis();
        this.competitorsByBoatId = new HashMap<String, com.sap.sailing.domain.base.Competitor>();
        this.useInternalMarkPassingAlgorithm = connectivityParams.isUseInternalMarkPassingAlgorithm();
        this.updateURL = connectivityParams.getUpdateURL();
        this.apiToken = connectivityParams.getApiToken();
        if (connectivityParams.getStartList() != null) {
            this.createRaceDefinition(this.course);
        }
        this.connector = factory.getOrCreateSailMasterConnector(connectivityParams.getHostname(), connectivityParams.getPort(), connectivityParams.getRaceID(), this.getRaceDataUrl(connectivityParams), connectivityParams.getRaceName(), connectivityParams.getRaceDescription(), connectivityParams.getBoatClass(), this);
    }

    private URL getRaceDataUrl(SwissTimingTrackingConnectivityParameters connectivityParams) throws MalformedURLException {
        URL result;
        if (connectivityParams.getHostname() == null) {
            URL manage2SailEventURL = new URL(connectivityParams.getManage2SailEventUrl());
            String path = manage2SailEventURL.getPath();
            String logFile = String.valueOf(path.substring(0, path.lastIndexOf(47) + 1)) + connectivityParams.getRaceID() + ".log";
            result = manage2SailEventURL.getPort() != -1 ? new URL(manage2SailEventURL.getProtocol(), manage2SailEventURL.getHost(), manage2SailEventURL.getPort(), logFile) : new URL(manage2SailEventURL.getProtocol(), manage2SailEventURL.getHost(), logFile);
        } else {
            result = null;
        }
        return result;
    }

    public DynamicTrackedRegatta getTrackedRegatta() {
        return this.trackedRegatta;
    }

    static Util.Triple<String, String, Integer> createID(String raceID, String hostname, int port) {
        return new Util.Triple((Object)raceID, (Object)hostname, (Object)port);
    }

    protected void onStop(boolean preemptive, boolean willBeRemoved) throws MalformedURLException, IOException, InterruptedException {
        if (this.isTrackedRaceStillReachable()) {
            TrackedRaceStatusImpl newStatus = new TrackedRaceStatusImpl(willBeRemoved ? TrackedRaceStatusEnum.REMOVED : TrackedRaceStatusEnum.FINISHED, 1.0);
            this.trackedRace.onStatusChanged((TrackingDataLoader)this, (TrackedRaceStatus)newStatus);
        }
        this.connector.removeSailMasterListener(this);
    }

    public RaceDefinition getRace() {
        return this.race;
    }

    public RaceHandle getRaceHandle() {
        return new RaceHandle(){

            public Regatta getRegatta() {
                return SwissTimingRaceTrackerImpl.this.getRegatta();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public RaceDefinition getRace() {
                SwissTimingRaceTrackerImpl swissTimingRaceTrackerImpl = SwissTimingRaceTrackerImpl.this;
                synchronized (swissTimingRaceTrackerImpl) {
                    while (true) {
                        if (SwissTimingRaceTrackerImpl.this.race != null) {
                            return SwissTimingRaceTrackerImpl.this.race;
                        }
                        try {
                            SwissTimingRaceTrackerImpl.this.wait();
                        }
                        catch (InterruptedException e) {
                            logger.log(Level.SEVERE, "Interrupted wait", e);
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public RaceDefinition getRace(long timeoutInMilliseconds) {
                long start = System.currentTimeMillis();
                SwissTimingRaceTrackerImpl swissTimingRaceTrackerImpl = SwissTimingRaceTrackerImpl.this;
                synchronized (swissTimingRaceTrackerImpl) {
                    RaceDefinition preResult = SwissTimingRaceTrackerImpl.this.race;
                    boolean interrupted = false;
                    while (System.currentTimeMillis() - start < timeoutInMilliseconds && !interrupted && preResult == null) {
                        try {
                            long timeToWait = timeoutInMilliseconds - (System.currentTimeMillis() - start);
                            if (timeToWait > 0L) {
                                SwissTimingRaceTrackerImpl.this.wait(timeToWait);
                            }
                            preResult = SwissTimingRaceTrackerImpl.this.race;
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                        }
                    }
                    RaceDefinition result = preResult == null ? null : preResult;
                    return result;
                }
            }

            public DynamicTrackedRegatta getTrackedRegatta() {
                return SwissTimingRaceTrackerImpl.this.getTrackedRegatta();
            }

            public RaceTracker getRaceTracker() {
                return SwissTimingRaceTrackerImpl.this;
            }
        };
    }

    public WindStore getWindStore() {
        return this.windStore;
    }

    public Regatta getRegatta() {
        return this.regatta;
    }

    @Override
    public Util.Triple<String, String, Integer> getID() {
        return this.id;
    }

    @Override
    public void receivedRacePositionData(String raceID, RaceStatus raceStatus, RacingStatus racingStatus, TimePoint timePoint, TimePoint startTime, Long millisecondsSinceRaceStart, Integer nextMarkIndexForLeader, Distance distanceToNextMarkForLeader, Collection<Fix> fixes) {
        assert (this.raceID.equals(raceID));
        if (this.isTrackedRaceStillReachable()) {
            if (this.raceID.equals(raceID)) {
                if (startTime != null) {
                    this.trackedRace.setStartTimeReceived(startTime);
                    this.tmdMessageQueue.validStartTimeReceived();
                }
                for (Fix fix : fixes) {
                    GPSFixMoving gpsFix = this.domainFactory.createGPSFix(timePoint, fix);
                    switch (fix.getTrackerType()) {
                        case UNIDENTIFIED: 
                        case COMMITTEE: 
                        case JURY: 
                        case TIMINGSCORING: 
                        case BUOY: {
                            Serializable trackerID = fix.getTrackedObjectId();
                            Mark mark = this.domainFactory.getOrCreateMark(trackerID, null);
                            this.trackedRace.recordFix(mark, (GPSFix)gpsFix);
                            break;
                        }
                        case COMPETITOR: {
                            Serializable competitorId = fix.getTrackedObjectId();
                            com.sap.sailing.domain.base.Competitor competitor = this.getDomainFactory().getBaseDomainFactory().getExistingCompetitorById(competitorId);
                            if (competitor != null) {
                                DynamicGPSFixTrack competitorTrack = this.trackedRace.getTrack(competitor);
                                competitorTrack.addGPSFix((GPSFix)gpsFix);
                                break;
                            }
                            logger.info("Unknown competitor " + competitorId + " found for race with id " + raceID);
                            break;
                        }
                        default: {
                            logger.info("Unknown tracker type " + (Object)((Object)fix.getTrackerType()));
                        }
                    }
                }
            }
        } else if (!this.loggedIgnore) {
            logger.info("Ignoring race position data " + fixes + " for SwissTiming race " + raceID + " because tracked race is no longer reachable. Was the race removed but is still tracked? " + "(Future occurrences of this message will be suppressed)");
            this.loggedIgnore = true;
        }
    }

    @Override
    public void receivedTimingData(String raceID, String competitorIdAsString, List<Util.Triple<Integer, Integer, Long>> markIndicesRanksAndTimesSinceStartInMilliseconds) {
        assert (this.raceID.equals(raceID));
        if (!this.useInternalMarkPassingAlgorithm) {
            if (this.isTrackedRaceStillReachable()) {
                com.sap.sailing.domain.base.Competitor competitor = this.domainFactory.getBaseDomainFactory().getExistingCompetitorById((Serializable)UUID.fromString(competitorIdAsString));
                if (competitor == null) {
                    logger.info("Received timing data for boat ID " + competitorIdAsString + " in race " + raceID + " but couldn't find a competitor with that boat ID in this race. Ignoring.");
                } else {
                    TreeMap<Integer, MarkPassing> markPassingsByMarkIndex = new TreeMap<Integer, MarkPassing>();
                    NavigableSet markPassings = this.trackedRace.getMarkPassings(competitor);
                    this.trackedRace.lockForRead((Iterable)markPassings);
                    try {
                        for (MarkPassing markPassing : markPassings) {
                            markPassingsByMarkIndex.put(this.trackedRace.getRace().getCourse().getIndexOfWaypoint(markPassing.getWaypoint()), markPassing);
                        }
                    }
                    finally {
                        this.trackedRace.unlockAfterRead((Iterable)markPassings);
                    }
                    for (Util.Triple triple : markIndicesRanksAndTimesSinceStartInMilliseconds) {
                        Waypoint waypoint = (Waypoint)Util.get((Iterable)this.trackedRace.getRace().getCourse().getWaypoints(), (int)((Integer)triple.getA()));
                        if (triple.getC() == null) {
                            markPassingsByMarkIndex.remove(triple.getA());
                            continue;
                        }
                        if (this.trackedRace.getStartOfRace() != null) {
                            TimePoint startTime = this.trackedRace.getStartOfRace();
                            MillisecondsTimePoint timePoint = new MillisecondsTimePoint(startTime.asMillis() + (Long)triple.getC());
                            MarkPassing markPassing = this.domainFactory.createMarkPassing((TimePoint)timePoint, waypoint, competitor);
                            markPassingsByMarkIndex.put((Integer)triple.getA(), markPassing);
                            continue;
                        }
                        logger.warning("Received mark passing with time relative to start of race " + this.trackedRace.getRace().getName() + " before having received a race start time." + " Queueing message for re-application when a start time has been received.");
                        this.tmdMessageQueue.enqueue(raceID, competitorIdAsString, markIndicesRanksAndTimesSinceStartInMilliseconds);
                    }
                    this.trackedRace.updateMarkPassings(competitor, markPassingsByMarkIndex.values());
                }
            } else if (!this.loggedIgnore) {
                logger.info("Ignoring timing data " + markIndicesRanksAndTimesSinceStartInMilliseconds + " for SwissTiming race " + raceID + " because tracked race is no longer reachable. Was the race removed but is still tracked? " + "(Future occurrences of this message will be suppressed)");
                this.loggedIgnore = true;
            }
        }
    }

    @Override
    public void storedDataProgress(String raceID, double progress, TrackedRaceStatusEnum statusAfterLoadingComplete) {
        assert (this.raceID.equals(raceID));
        if (this.isTrackedRaceStillReachable()) {
            TrackedRaceStatusImpl newStatus = progress == 0.0 ? new TrackedRaceStatusImpl(TrackedRaceStatusEnum.PREPARED, 0.0) : (progress == 1.0 ? new TrackedRaceStatusImpl(statusAfterLoadingComplete, progress) : new TrackedRaceStatusImpl(TrackedRaceStatusEnum.LOADING, progress));
            this.trackedRace.onStatusChanged((TrackingDataLoader)this, (TrackedRaceStatus)newStatus);
            if (newStatus.getStatus() == TrackedRaceStatusEnum.FINISHED) {
                try {
                    this.trackedRegattaRegistry.stopTracker(this.getRegatta(), (RaceTracker)this);
                }
                catch (IOException | InterruptedException e) {
                    logger.log(Level.SEVERE, "Error trying to stop the tracker " + this, e);
                }
            }
        }
    }

    @Override
    public void receivedClockAtMark(String raceID, List<Util.Triple<Integer, TimePoint, String>> markIndicesTimePointsAndBoatIDs) {
    }

    @Override
    public void receivedStartList(String raceID, StartList startList) throws URISyntaxException {
        if (!this.startListFromManage2Sail && this.raceID.equals(raceID)) {
            Map<com.sap.sailing.domain.base.Competitor, Boat> competitorsAndTheirBoats;
            StartList oldStartList = this.startList;
            this.startList = startList;
            if (oldStartList == null && this.course != null) {
                this.createRaceDefinition(this.course);
            } else if (this.trackedRace != null && !Util.setEquals((competitorsAndTheirBoats = this.domainFactory.createCompetitorsAndBoats(startList, raceID, this.boatClass, (RaceTrackingHandler)new RaceTrackingHandler.DefaultRaceTrackingHandler())).keySet(), (Iterable)this.getRace().getCompetitors())) {
                try {
                    this.trackedRegattaRegistry.updateRaceCompetitors(this.getRegatta(), this.getRace());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public void receivedWindData(String raceID, int zeroBasedMarkIndex, double windDirectionTrueDegrees, double windSpeedInKnots) {
        if (this.raceID.equals(raceID)) {
            DynamicTrackedRace trackedRace = this.getTrackedRace();
            if (trackedRace == null) {
                logger.warning("Received wind data at mark " + zeroBasedMarkIndex + ": " + windDirectionTrueDegrees + "deg at " + windSpeedInKnots + "kts but didn't find tracked race; ignoring");
            } else {
                Waypoint wp = (Waypoint)Util.get((Iterable)trackedRace.getRace().getCourse().getWaypoints(), (int)zeroBasedMarkIndex);
                TimePoint timePoint = this.connector.getLastRPDMessageTimePoint();
                Position waypointPosition = trackedRace.getApproximatePosition(wp, timePoint);
                WindImpl wind = new WindImpl(waypointPosition, timePoint, (SpeedWithBearing)new KnotSpeedWithBearingImpl(windSpeedInKnots, (Bearing)new DegreeBearingImpl(windDirectionTrueDegrees)));
                WindSourceWithAdditionalID windSource = new WindSourceWithAdditionalID(WindSourceType.RACECOMMITTEE, "@" + zeroBasedMarkIndex);
                trackedRace.recordWind((Wind)wind, (WindSource)windSource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRaceDefinition(Course course) throws URISyntaxException {
        assert (this.raceID.equals(this.raceID));
        assert (this.startList != null);
        assert (course != null);
        RaceImpl swissTimingRace = new RaceImpl(this.raceID, this.raceName, this.raceDescription, this.boatClass);
        try {
            SwissTimingRaceTrackerImpl swissTimingRaceTrackerImpl = this;
            synchronized (swissTimingRaceTrackerImpl) {
                this.race = this.domainFactory.createRaceDefinition(this.regatta, swissTimingRace, this.startList, course, this.raceTrackingHandler);
                this.notifyAll();
            }
            CompetitorAndBoatStore competitorStore = this.domainFactory.getBaseDomainFactory().getCompetitorAndBoatStore();
            for (Competitor c : this.startList.getCompetitors()) {
                DynamicCompetitor existingCompetitor = competitorStore.getExistingCompetitorByIdAsString(c.getIdAsString());
                if (existingCompetitor == null) continue;
                this.competitorsByBoatId.put(c.getBoatID(), (com.sap.sailing.domain.base.Competitor)existingCompetitor);
            }
            this.trackedRace = this.raceTrackingHandler.createTrackedRace((TrackedRegatta)this.getTrackedRegatta(), this.race, Collections.emptyList(), this.windStore, this.delayToLiveInMillis, 30000L, this.race.getBoatClass().getApproximateManeuverDurationInMilliseconds(), new DynamicRaceDefinitionSet(){

                public void addRaceDefinition(RaceDefinition race, DynamicTrackedRace trackedRace) {
                    if (!$assertionsDisabled && SwissTimingRaceTrackerImpl.this.race != race) {
                        throw new AssertionError();
                    }
                }
            }, this.useInternalMarkPassingAlgorithm, this.raceLogResolver, Optional.empty(), (TrackingConnectorInfo)new TrackingConnectorInfoImpl("SwissTiming", SwissTimingAdapter.DEFAULT_URL, null), this.markPassingRaceFingerprintRegistry);
            this.addUpdateHandlers();
            this.notifyRaceCreationListeners();
            logger.info("Created SwissTiming RaceDefinition and TrackedRace for " + this.race.getName());
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Error while creating race " + this.raceName + " for regatta " + this.trackedRegatta.getRegatta(), exception);
            try {
                if (this.race == null) {
                    this.trackedRegattaRegistry.stopTracker(this.regatta, (RaceTracker)this);
                } else {
                    this.trackedRegattaRegistry.stopTracking(this.regatta, this.race);
                }
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Something else went wrong while trying to notify the TrackedRegattaRegistry that the race  could not be added to the the regatta " + this.trackedRegatta.getRegatta(), e);
            }
        }
    }

    private void addUpdateHandlers() throws URISyntaxException {
        this.getDomainFactory().addUpdateHandlers(this.updateURL, this.apiToken, this.regatta.getId(), this.trackedRace.getRace(), this.trackedRace);
    }

    private boolean isTrackedRaceStillReachable() {
        return this.trackedRace != null && Util.contains((Iterable)this.getRegatta().getAllRaces(), (Object)this.trackedRace.getRace()) && this.getTrackedRegatta().getExistingTrackedRace(this.trackedRace.getRace()) == this.trackedRace;
    }

    @Override
    public void receivedCourseConfiguration(String raceID, Course course) throws URISyntaxException {
        Course oldCourse = this.course;
        if (this.trackedRace == null) {
            if (oldCourse == null && this.startList != null) {
                this.createRaceDefinition(course);
                this.course = course;
            }
        } else if (this.isTrackedRaceStillReachable()) {
            try {
                this.domainFactory.updateCourseWaypoints(this.trackedRace.getRace().getCourse(), course.getMarks());
                this.course = course;
            }
            catch (PatchFailedException e) {
                logger.info("Internal error trying to update course: " + e.getMessage());
                logger.throwing(SwissTimingRaceTrackerImpl.class.getName(), "receivedCourseConfiguration", e);
            }
        } else if (!this.loggedIgnore) {
            logger.info("Ignoring course configuration " + course + " for SwissTiming race " + raceID + " because tracked race is no longer reachable. Was the race removed but is still tracked? " + "(Future occurrences of this message will be suppressed)");
            this.loggedIgnore = true;
        }
    }

    @Override
    public void receivedAvailableRaces(Iterable<Race> races) {
    }

    protected DynamicTrackedRace getTrackedRace() {
        return this.trackedRace;
    }

    public DomainFactory getDomainFactory() {
        return this.domainFactory;
    }

    public BoatClass getBoatClass() {
        return this.boatClass;
    }
}

