/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.swisstimingadapter.impl;

import com.sap.sailing.domain.base.impl.KilometersPerHourSpeedWithBearingImpl;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.domain.swisstimingadapter.SwissTimingFormatException;
import com.sap.sailing.domain.swisstimingadapter.SwissTimingMessage;
import com.sap.sailing.domain.swisstimingadapter.SwissTimingMessageParser;
import com.sap.sailing.domain.swisstimingadapter.impl.SwissTimingMessageImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.net.DatagramPacket;

public class SwissTimingMessageParserImpl
implements SwissTimingMessageParser {
    @Override
    public SwissTimingMessage parse(byte[] message) throws SwissTimingFormatException {
        return this.parse(message, 0, message.length);
    }

    @Override
    public SwissTimingMessage parse(byte[] message, int offset, int length) throws SwissTimingFormatException {
        int i = offset;
        while (i < offset + length - 1 && (message[i] != 16 || message[i + 1] != 0)) {
            ++i;
        }
        if (i >= offset + length - 1 || message[i] != 16 || message[i + 1] != 0) {
            throw new SwissTimingFormatException("Didn't find start marker 0x1000", message);
        }
        String raceID = new String(message, i += 2, 9);
        int packetID = this.parseInt(message, i += 9);
        long timestamp = this.parseLong(message, i += 4);
        byte packetType = message[i += 8];
        if (packetType != 2) {
            throw new SwissTimingFormatException("Expected to find package type 0x02", message);
        }
        short gpsID = this.parseShort(message, ++i);
        int longitude = this.parseInt(message, i += 2);
        int latitude = this.parseInt(message, i += 4);
        int speedInDecimetersPerSecond = 0xFF & message[i += 4];
        short course = this.parseShort(message, ++i);
        int numberOfSatellites = (message[i += 2] & 0xF0) >> 4;
        int batteryPercent = 10 * (message[i] & 0xF);
        if (message[++i] != 16 || message[i + 1] != 48) {
            throw new SwissTimingFormatException("Didn't find end marker 0x1030", message);
        }
        return new SwissTimingMessageImpl(raceID, packetID, (TimePoint)new MillisecondsTimePoint(timestamp), gpsID, (Position)new DegreePosition((double)latitude / 1.0E7, (double)longitude / 1.0E7), (Speed)new KilometersPerHourSpeedWithBearingImpl(0.36 * (double)speedInDecimetersPerSecond, (Bearing)new DegreeBearingImpl((double)course)), numberOfSatellites, batteryPercent, (i += 2) - offset);
    }

    private short parseShort(byte[] message, int offset) {
        short result = 0;
        int b = 0;
        while (b < 2) {
            result = (short)(result << 8);
            result = (short)(result + (0xFF & message[offset + b]));
            ++b;
        }
        return result;
    }

    private long parseLong(byte[] message, int offset) {
        long result = 0L;
        int b = 0;
        while (b < 8) {
            result <<= 8;
            result += (long)(0xFF & message[offset + b]);
            ++b;
        }
        return result;
    }

    private int parseInt(byte[] message, int offset) {
        int result = 0;
        int b = 0;
        while (b < 4) {
            result <<= 8;
            result += 0xFF & message[offset + b];
            ++b;
        }
        return result;
    }

    public SwissTimingMessage parse(DatagramPacket p) throws SwissTimingFormatException {
        return this.parse(p.getData(), p.getOffset(), p.getLength());
    }
}

