/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.swisstimingadapter;

import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;

public interface SwissTimingArchiveConfiguration
extends WithQualifiedObjectIdentifier {
    public String getJsonURL();

    public String getCreatorName();

    default public String getName() {
        return this.getJsonURL();
    }

    default public QualifiedObjectIdentifier getIdentifier() {
        return this.getPermissionType().getQualifiedObjectIdentifier(this.getTypeRelativeObjectIdentifier());
    }

    default public HasPermissions getPermissionType() {
        return SecuredDomainType.SWISS_TIMING_ARCHIVE_ACCOUNT;
    }

    default public TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier() {
        return SwissTimingArchiveConfiguration.getTypeRelativeObjectIdentifier(this.getJsonURL(), this.getCreatorName());
    }

    public static TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier(String jsonUrl, String username) {
        return username == null ? new TypeRelativeObjectIdentifier(new String[]{jsonUrl}) : new TypeRelativeObjectIdentifier(new String[]{jsonUrl, username});
    }
}

