/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.landscape.procedures;

import com.jcraft.jsch.JSchException;
import com.sap.sailing.landscape.SailingAnalyticsHost;
import com.sap.sailing.landscape.SailingAnalyticsMetrics;
import com.sap.sailing.landscape.SailingAnalyticsProcess;
import com.sap.sailing.landscape.impl.SailingAnalyticsHostImpl;
import com.sap.sailing.landscape.impl.SailingAnalyticsProcessImpl;
import com.sap.sailing.landscape.procedures.SailingProcessConfigurationVariables;
import com.sap.sailing.landscape.procedures.StartFromSailingAnalyticsImage;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Util;
import com.sap.sse.landscape.Region;
import com.sap.sse.landscape.application.ApplicationProcess;
import com.sap.sse.landscape.aws.AmazonMachineImage;
import com.sap.sse.landscape.aws.AwsInstance;
import com.sap.sse.landscape.aws.HostSupplier;
import com.sap.sse.landscape.aws.Tags;
import com.sap.sse.landscape.aws.impl.AwsRegion;
import com.sap.sse.landscape.aws.orchestration.StartEmptyServer;
import com.sap.sse.landscape.orchestration.Procedure;
import com.sap.sse.shared.util.Wait;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.ImageState;
import software.amazon.awssdk.services.ec2.model.Instance;
import software.amazon.awssdk.services.ec2.model.InstanceStateName;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.Snapshot;

public class UpgradeAmi<ShardingKey>
extends StartEmptyServer<UpgradeAmi<ShardingKey>, ShardingKey, SailingAnalyticsHost<ShardingKey>>
implements Procedure<ShardingKey>,
StartFromSailingAnalyticsImage {
    private static final Logger logger = Logger.getLogger(UpgradeAmi.class.getName());
    private static final Pattern imageNamePattern = Pattern.compile("^(.*) ([0-9]+)\\.([0-9]+)(\\.([0-9]+))?$");
    private static final String IMAGE_UPGRADE_USER_DATA = "image-upgrade";
    private final AwsRegion region;
    private final String upgradedImageName;
    private final String imageType;
    private final boolean keyPairIsTemporaryAndNeedsToBeRemovedWhenDone;
    private final boolean waitForShutdown;
    private final Map<String, String> deviceNamesToSnapshotBaseNames;
    private final Optional<Duration> optionalTimeout;
    private AmazonMachineImage<ShardingKey> upgradedAmi;

    public static <BuilderT extends Builder<BuilderT, ShardingKey, SailingAnalyticsProcess<ShardingKey>>, ShardingKey, HostT extends AwsInstance<ShardingKey>> Builder<BuilderT, ShardingKey, SailingAnalyticsProcess<ShardingKey>> builder() {
        return new BuilderImpl();
    }

    protected UpgradeAmi(BuilderImpl<?, ShardingKey> builder) {
        super(builder);
        this.optionalTimeout = builder.getOptionalTimeout();
        this.region = builder.getRegion();
        this.imageType = builder.getImageType();
        this.upgradedImageName = builder.getUpgradedImageName();
        this.waitForShutdown = !builder.isNoShutdown();
        this.deviceNamesToSnapshotBaseNames = builder.getDeviceNamesToSnapshotBaseNames();
        this.keyPairIsTemporaryAndNeedsToBeRemovedWhenDone = builder.isKeyPairIsTemporaryAndNeedsToBeRemovedWhenDone();
        this.addUserData(Collections.singleton(IMAGE_UPGRADE_USER_DATA));
    }

    public void run() throws Exception {
        try {
            super.run();
            Instance[] instance = new Instance[1];
            if (this.waitForShutdown) {
                Wait.wait(() -> {
                    instanceArray[0] = this.getLandscape().getInstance(((SailingAnalyticsHost)this.getHost()).getInstanceId(), (Region)((SailingAnalyticsHost)this.getHost()).getRegion());
                    return instanceArray[0] != null && instance[0].state().name() == InstanceStateName.STOPPED;
                }, result -> result, (boolean)true, this.optionalTimeout, (Duration)Duration.ONE_SECOND.times(5L), (Level)Level.INFO, (String)("Waiting for shutdown of instance " + ((SailingAnalyticsHost)this.getHost()).getInstanceId()));
            }
            this.upgradedAmi = this.getLandscape().createImage(this.getHost(), this.upgradedImageName, Optional.of(Tags.with((String)"image-type", (String)this.imageType)));
            Wait.wait(() -> {
                this.upgradedAmi = this.getLandscape().getImage(this.upgradedAmi.getRegion(), this.upgradedAmi.getId());
                return this.upgradedAmi.getState() == ImageState.AVAILABLE;
            }, this.optionalTimeout, (Duration)Duration.ONE_SECOND.times(5L), (Level)Level.INFO, (String)("Waiting for Image " + this.upgradedAmi.getId() + " to become " + ImageState.AVAILABLE));
            for (BlockDeviceMapping blockDeviceMapping : this.upgradedAmi.getBlockDeviceMappings()) {
                if (blockDeviceMapping.ebs() == null) continue;
                String snapshotId = blockDeviceMapping.ebs().snapshotId();
                String deviceName = blockDeviceMapping.deviceName();
                String snapshotName = this.getSnapshotName(deviceName);
                this.getLandscape().setSnapshotName((Region)((SailingAnalyticsHost)this.getHost()).getRegion(), snapshotId, snapshotName);
            }
        }
        finally {
            if (this.keyPairIsTemporaryAndNeedsToBeRemovedWhenDone) {
                logger.info("Removing temporary key " + this.getKeyName());
                this.getLandscape().deleteKeyPair((Region)this.region, this.getKeyName());
            }
            if (this.getHost() != null) {
                ((SailingAnalyticsHost)this.getHost()).terminate();
            }
        }
    }

    private String getSnapshotName(String deviceName) {
        StringBuilder result = new StringBuilder();
        result.append(this.upgradedImageName);
        String baseName = this.deviceNamesToSnapshotBaseNames.get(deviceName);
        if (baseName != null) {
            result.append(" (");
            result.append(baseName);
            result.append(")");
        }
        return result.toString();
    }

    public AmazonMachineImage<ShardingKey> getUpgradedAmi() {
        return this.upgradedAmi;
    }

    public static interface Builder<BuilderT extends Builder<BuilderT, ShardingKey, SailingAnalyticsProcess<ShardingKey>>, ShardingKey, ProcessT extends ApplicationProcess<ShardingKey, SailingAnalyticsMetrics, ProcessT>>
    extends StartEmptyServer.Builder<BuilderT, UpgradeAmi<ShardingKey>, ShardingKey, SailingAnalyticsHost<ShardingKey>> {
        public BuilderT setUpgradedImageName(String var1);

        public BuilderT setVersionPartToIncrement(VersionPart var1);

        public BuilderT setSnapshotBaseName(String var1, String var2);

        public static enum VersionPart {
            MAJOR,
            MINOR,
            MICRO;

        }
    }

    protected static class BuilderImpl<BuilderT extends Builder<BuilderT, ShardingKey, SailingAnalyticsProcess<ShardingKey>>, ShardingKey>
    extends StartEmptyServer.BuilderImpl<BuilderT, UpgradeAmi<ShardingKey>, ShardingKey, SailingAnalyticsHost<ShardingKey>>
    implements Builder<BuilderT, ShardingKey, SailingAnalyticsProcess<ShardingKey>> {
        private String upgradedImageName;
        private Builder.VersionPart versionPartToIncrement;
        private Map<String, String> deviceNamesToSnapshotBaseNames;
        private boolean keyPairIsTemporaryAndNeedsToBeRemovedWhenDone;

        private BuilderImpl() {
        }

        protected String getImageType() {
            return super.getImageType() == null ? (this.getMachineImage() == null ? "sailing-analytics-server" : Util.stream((Iterable)this.getMachineImage().getTags()).filter(tag -> tag.key().equals("image-type")).findAny().map(tag -> tag.value()).orElse("sailing-analytics-server")) : super.getImageType();
        }

        protected String getInstanceName() {
            return super.getInstanceName() == null ? "image-upgrade for " + this.getMachineImage().getId() : super.getInstanceName();
        }

        protected InstanceType getInstanceType() {
            return super.getInstanceType() == null ? InstanceType.T2_MEDIUM : super.getInstanceType();
        }

        protected boolean isNoShutdown() {
            return super.isNoShutdown();
        }

        protected String getKeyName() {
            if (super.getKeyName() == null) {
                this.keyPairIsTemporaryAndNeedsToBeRemovedWhenDone = true;
                String keyName = "MyKey-" + UUID.randomUUID();
                logger.info("No key name provided; creating temporary key " + keyName);
                this.setPrivateKeyEncryptionPassphrase(UUID.randomUUID().toString().getBytes());
                try {
                    this.getLandscape().createKeyPair((Region)this.getRegion(), keyName, this.getPrivateKeyEncryptionPassphrase());
                }
                catch (JSchException e) {
                    throw new RuntimeException(e);
                }
                this.setKeyName(keyName);
            }
            return super.getKeyName();
        }

        boolean isKeyPairIsTemporaryAndNeedsToBeRemovedWhenDone() {
            return this.keyPairIsTemporaryAndNeedsToBeRemovedWhenDone;
        }

        @Override
        public BuilderT setVersionPartToIncrement(Builder.VersionPart versionPartToIncrement) {
            this.versionPartToIncrement = versionPartToIncrement;
            return (BuilderT)((Builder)this.self());
        }

        private String increaseVersionNumber(String imageName) {
            String result;
            Matcher versionNumberMatcher = imageNamePattern.matcher(imageName);
            if (versionNumberMatcher.matches()) {
                Integer oldMicroVersion;
                String imageBaseName = versionNumberMatcher.group(1);
                Integer oldMajorVersion = Integer.valueOf(versionNumberMatcher.group(2));
                Integer oldMinorVersion = Integer.valueOf(versionNumberMatcher.group(3));
                Integer n = oldMicroVersion = versionNumberMatcher.group(5) == null ? null : Integer.valueOf(versionNumberMatcher.group(5));
                Builder.VersionPart partToEffectivelyIncrement = this.versionPartToIncrement == null ? (oldMicroVersion == null ? Builder.VersionPart.MINOR : Builder.VersionPart.MICRO) : this.versionPartToIncrement;
                Integer newMajorVersion = partToEffectivelyIncrement == Builder.VersionPart.MAJOR ? oldMajorVersion + 1 : oldMajorVersion;
                Integer newMinorVersion = partToEffectivelyIncrement == Builder.VersionPart.MINOR ? oldMinorVersion + 1 : oldMinorVersion;
                Integer newMicroVersion = oldMicroVersion == null ? (partToEffectivelyIncrement == Builder.VersionPart.MICRO ? Integer.valueOf(0) : null) : (partToEffectivelyIncrement == Builder.VersionPart.MICRO ? Integer.valueOf(oldMicroVersion + 1) : oldMicroVersion);
                StringBuilder sb = new StringBuilder(imageBaseName);
                sb.append(' ');
                sb.append(newMajorVersion);
                sb.append('.');
                sb.append(newMinorVersion);
                if (newMicroVersion != null) {
                    sb.append('.');
                    sb.append(newMicroVersion);
                }
                result = sb.toString();
            } else {
                result = String.valueOf(imageName) + " (1)";
            }
            return result;
        }

        @Override
        public BuilderT setUpgradedImageName(String upgradedImageName) {
            this.upgradedImageName = upgradedImageName;
            return (BuilderT)((Builder)this.self());
        }

        @Override
        public BuilderT setSnapshotBaseName(String deviceName, String snapshotBaseName) {
            if (this.deviceNamesToSnapshotBaseNames == null) {
                this.deviceNamesToSnapshotBaseNames = new HashMap<String, String>();
            }
            this.deviceNamesToSnapshotBaseNames.put(deviceName, snapshotBaseName);
            return (BuilderT)((Builder)this.self());
        }

        public HostSupplier<ShardingKey, SailingAnalyticsHost<ShardingKey>> getHostSupplier() {
            return (instanceId, az, privateIpAddress, launchTimePoint, landscape) -> new SailingAnalyticsHostImpl(instanceId, az, privateIpAddress, launchTimePoint, landscape, (host, port, serverDirectory, telnetPort, serverName, additionalProperties) -> {
                try {
                    Number expeditionUdpPort = (Number)additionalProperties.get(SailingProcessConfigurationVariables.EXPEDITION_PORT.name());
                    Number igtimiRiotPort = (Number)additionalProperties.get(SailingProcessConfigurationVariables.IGTIMI_RIOT_PORT.name());
                    return new SailingAnalyticsProcessImpl(port, host, serverDirectory, telnetPort, serverName, expeditionUdpPort == null ? null : Integer.valueOf(expeditionUdpPort.intValue()), igtimiRiotPort == null ? null : Integer.valueOf(igtimiRiotPort.intValue()), landscape);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }

        protected String getUpgradedImageName() {
            return this.upgradedImageName;
        }

        protected Map<String, String> getDeviceNamesToSnapshotBaseNames() {
            return Collections.unmodifiableMap(this.deviceNamesToSnapshotBaseNames);
        }

        protected AwsRegion getRegion() {
            return super.getRegion();
        }

        public UpgradeAmi<ShardingKey> build() {
            if (this.upgradedImageName == null) {
                this.upgradedImageName = this.increaseVersionNumber(this.getMachineImage().getName());
            }
            if (this.deviceNamesToSnapshotBaseNames == null) {
                this.deviceNamesToSnapshotBaseNames = new HashMap<String, String>();
                AmazonMachineImage image = this.getLandscape().getImage((Region)this.getRegion(), this.getMachineImage().getId());
                for (BlockDeviceMapping blockDeviceMapping : image.getBlockDeviceMappings()) {
                    Snapshot snapshot = this.getLandscape().getSnapshot(this.getRegion(), blockDeviceMapping.ebs().snapshotId());
                    snapshot.tags().stream().filter(t -> t.key().equals("Name")).findAny().ifPresent(nameTag -> {
                        Pattern snapshotNamePattern = Pattern.compile("^.* \\((.*)\\) *$");
                        Matcher matcher = snapshotNamePattern.matcher(nameTag.value());
                        if (matcher.matches()) {
                            String baseName = matcher.group(1);
                            this.deviceNamesToSnapshotBaseNames.put(blockDeviceMapping.deviceName(), baseName);
                        }
                    });
                }
            }
            return new UpgradeAmi(this);
        }

        protected Optional<Duration> getOptionalTimeout() {
            return super.getOptionalTimeout();
        }
    }
}

