/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.landscape;

import com.sap.sailing.domain.common.DataImportProgress;
import com.sap.sailing.landscape.AwsSessionCredentialsWithExpiry;
import com.sap.sailing.landscape.SailingAnalyticsHost;
import com.sap.sailing.landscape.SailingAnalyticsMetrics;
import com.sap.sailing.landscape.SailingAnalyticsProcess;
import com.sap.sailing.landscape.procedures.DeployProcessOnMultiServer;
import com.sap.sailing.landscape.procedures.SailingAnalyticsMasterConfiguration;
import com.sap.sailing.landscape.procedures.SailingAnalyticsReplicaConfiguration;
import com.sap.sailing.landscape.procedures.StartMultiServer;
import com.sap.sailing.server.gateway.interfaces.CompareServersResult;
import com.sap.sailing.server.gateway.interfaces.SailingServer;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Util;
import com.sap.sse.landscape.Release;
import com.sap.sse.landscape.aws.AmazonMachineImage;
import com.sap.sse.landscape.aws.AwsApplicationReplicaSet;
import com.sap.sse.landscape.aws.AwsAvailabilityZone;
import com.sap.sse.landscape.aws.AwsLandscape;
import com.sap.sse.landscape.aws.impl.AwsRegion;
import com.sap.sse.landscape.mongodb.MongoEndpoint;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Rule;

public interface LandscapeService {
    public static final Optional<Duration> MDI_TIMEOUT = Optional.of(Duration.ONE_HOUR.times(6L));
    public static final Duration TIME_TO_WAIT_BETWEEN_MDI_COMPLETION_CHECKS = Duration.ONE_SECOND.times(15L);
    public static final String USER_PREFERENCE_FOR_SESSION_TOKEN = "___aws.session.token___";
    public static final String SAILING_TARGET_GROUP_NAME_PREFIX = "S-";

    public void createMfaSessionCredentials(String var1, String var2, String var3);

    public void createSessionCredentials(String var1, String var2, String var3);

    public boolean hasValidSessionCredentials();

    public AwsSessionCredentialsWithExpiry getSessionCredentials();

    public void clearSessionCredentials();

    public AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> createApplicationReplicaSet(String var1, String var2, boolean var3, String var4, String var5, boolean var6, String var7, String var8, byte[] var9, String var10, String var11, String var12, Integer var13, Integer var14, Integer var15, Optional<Integer> var16, Optional<Integer> var17) throws Exception;

    public AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> deployApplicationToExistingHost(String var1, SailingAnalyticsHost<String> var2, String var3, boolean var4, String var5, String var6, byte[] var7, String var8, String var9, String var10, Optional<Integer> var11, Optional<Integer> var12, Integer var13, Integer var14, Integer var15, Optional<InstanceType> var16, Optional<SailingAnalyticsHost<String>> var17) throws Exception;

    public Util.Triple<DataImportProgress, CompareServersResult, String> archiveReplicaSet(String var1, AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> var2, String var3, String var4, Duration var5, int var6, boolean var7, MongoEndpoint var8, String var9, byte[] var10) throws Exception;

    public String removeApplicationReplicaSet(String var1, AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> var2, MongoEndpoint var3, String var4, byte[] var5) throws Exception;

    public Release getRelease(String var1);

    public String getFullyQualifiedHostname(String var1, Optional<String> var2);

    public AwsLandscape<String> getLandscape();

    public String getDefaultRedirectPath(Rule var1);

    public AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> upgradeApplicationReplicaSet(AwsRegion var1, AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> var2, String var3, String var4, byte[] var5, String var6) throws InterruptedException, ExecutionException, MalformedURLException, IOException, TimeoutException, Exception;

    public SailingAnalyticsProcess<String> ensureAtLeastOneReplicaExistsStopReplicatingAndRemoveMasterFromTargetGroups(AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> var1, String var2, byte[] var3, String var4) throws Exception, MalformedURLException, IOException, TimeoutException, InterruptedException, ExecutionException;

    public <AppConfigBuilderT extends SailingAnalyticsReplicaConfiguration.Builder<AppConfigBuilderT, String>, MultiServerDeployerBuilderT extends DeployProcessOnMultiServer.Builder<MultiServerDeployerBuilderT, String, SailingAnalyticsHost<String>, SailingAnalyticsReplicaConfiguration<String>, AppConfigBuilderT>> SailingAnalyticsProcess<String> deployReplicaToExistingHost(AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> var1, SailingAnalyticsHost<String> var2, String var3, byte[] var4, String var5, Integer var6, Integer var7, Integer var8) throws Exception;

    public Iterable<SailingAnalyticsHost<String>> getEligibleSharedHostsForReplicaSet(AwsRegion var1, AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> var2, String var3, byte[] var4);

    public AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> getApplicationReplicaSet(AwsRegion var1, String var2, Long var3, String var4, byte[] var5) throws Exception;

    public <BuilderT extends StartMultiServer.Builder<BuilderT, String>> SailingAnalyticsHost<String> createEmptyMultiServer(AwsRegion var1, Optional<InstanceType> var2, Optional<AwsAvailabilityZone> var3, Optional<String> var4, Optional<String> var5, byte[] var6) throws Exception;

    public Iterable<AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>>> updateImageForReplicaSets(AwsRegion var1, Iterable<AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>>> var2, Optional<AmazonMachineImage<String>> var3, Optional<Duration> var4, Optional<String> var5, byte[] var6) throws InterruptedException, ExecutionException, TimeoutException;

    public <AppConfigBuilderT extends SailingAnalyticsReplicaConfiguration.Builder<AppConfigBuilderT, String>, MultiServerDeployerBuilderT extends DeployProcessOnMultiServer.Builder<MultiServerDeployerBuilderT, String, SailingAnalyticsHost<String>, SailingAnalyticsReplicaConfiguration<String>, AppConfigBuilderT>> AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> useDedicatedAutoScalingReplicasInsteadOfShared(AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> var1, String var2, byte[] var3) throws Exception;

    public <AppConfigBuilderT extends SailingAnalyticsReplicaConfiguration.Builder<AppConfigBuilderT, String>, MultiServerDeployerBuilderT extends DeployProcessOnMultiServer.Builder<MultiServerDeployerBuilderT, String, SailingAnalyticsHost<String>, SailingAnalyticsReplicaConfiguration<String>, AppConfigBuilderT>> AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> useSingleSharedInsteadOfDedicatedAutoScalingReplica(AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> var1, String var2, byte[] var3, String var4, Integer var5, Integer var6, Optional<InstanceType> var7) throws Exception;

    public String getEffectiveBearerToken(String var1);

    public <AppConfigBuilderT extends SailingAnalyticsMasterConfiguration.Builder<AppConfigBuilderT, String>, MultiServerDeployerBuilderT extends DeployProcessOnMultiServer.Builder<MultiServerDeployerBuilderT, String, SailingAnalyticsHost<String>, SailingAnalyticsMasterConfiguration<String>, AppConfigBuilderT>> AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> moveMasterToOtherInstance(AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> var1, boolean var2, Optional<InstanceType> var3, Optional<SailingAnalyticsHost<String>> var4, String var5, byte[] var6, String var7, String var8, Integer var9, Integer var10) throws MalformedURLException, IOException, TimeoutException, InterruptedException, ExecutionException, Exception;

    public AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> changeAutoScalingReplicasInstanceType(AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> var1, InstanceType var2, Optional<Duration> var3, Optional<String> var4, byte[] var5) throws Exception;

    public <ShardingKey> boolean isEligibleForDeployment(SailingAnalyticsHost<ShardingKey> var1, String var2, int var3, Integer var4, Optional<Duration> var5, String var6, byte[] var7) throws Exception;

    public SailingServer getSailingServer(String var1, String var2, String var3, Optional<Integer> var4) throws MalformedURLException;

    public SailingServer getSailingServer(String var1, String var2, Optional<Integer> var3) throws MalformedURLException;

    public void removeShardingKeysFromShard(Iterable<String> var1, AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> var2, AwsRegion var3, String var4, String var5) throws Exception;

    public void appendShardingKeysToShard(Iterable<String> var1, AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> var2, AwsRegion var3, String var4, String var5) throws Exception;

    public void removeShard(AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> var1, String var2) throws Exception;

    public void addShard(Iterable<String> var1, AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>> var2, AwsRegion var3, String var4, String var5) throws Exception;

    public Util.Triple<SailingAnalyticsHost<String>, Map<String, SailingAnalyticsProcess<String>>, Map<String, SailingAnalyticsProcess<String>>> moveAllApplicationProcessesAwayFrom(SailingAnalyticsHost<String> var1, Optional<InstanceType> var2, String var3, byte[] var4) throws Exception;

    public String getHostname(String var1, String var2);
}

