/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.windimport.bravo;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.impl.WindImpl;
import com.sap.sailing.domain.common.impl.WindSourceWithAdditionalID;
import com.sap.sailing.domain.common.tracking.DoubleVectorFix;
import com.sap.sailing.domain.trackfiles.TrackFileImportDeviceIdentifier;
import com.sap.sailing.domain.trackimport.BaseDoubleVectorFixImporter;
import com.sap.sailing.domain.trackimport.FormatNotSupportedException;
import com.sap.sailing.server.gateway.windimport.AbstractWindImporter;
import com.sap.sailing.server.gateway.windimport.bravo.FunnyDegreeConverter;
import com.sap.sailing.server.trackfiles.impl.BaseBravoDataImporterImpl;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class BravoWindImporter
extends AbstractWindImporter {
    private static final String BRAVO_WIND_IMPORT = "Bravo Wind Import";
    private static final String GZIP_SUFFIX = ".gz";
    private static final Logger logger = Logger.getLogger(BravoWindImporter.class.getName());

    @Override
    protected WindSource getDefaultWindSource(AbstractWindImporter.UploadRequest uploadRequest) {
        logger.info("Importing Bravo wind data from " + uploadRequest.files);
        String sourceName = uploadRequest.files != null && !uploadRequest.files.isEmpty() ? uploadRequest.files.stream().map(f -> f.getName()).collect(Collectors.joining(", ")) : BRAVO_WIND_IMPORT;
        WindSourceWithAdditionalID windSource = new WindSourceWithAdditionalID(WindSourceType.EXPEDITION, String.valueOf(sourceName) + "@" + MillisecondsTimePoint.now());
        return windSource;
    }

    @Override
    protected Map<WindSource, Iterable<Wind>> importWind(WindSource defaultWindSource, Map<InputStream, Util.Pair<String, Charset>> inputStreamsAndFilenamesAndCharsets) throws IOException, InterruptedException, FormatNotSupportedException {
        Iterable<Object> windFixes;
        if (inputStreamsAndFilenamesAndCharsets != null && inputStreamsAndFilenamesAndCharsets.size() == 1) {
            Util.Pair<String, Charset> filenameAndCharset = inputStreamsAndFilenamesAndCharsets.values().iterator().next();
            logger.info("Reading Bravo wind data from " + filenameAndCharset);
            windFixes = this.readWind((String)filenameAndCharset.getA(), inputStreamsAndFilenamesAndCharsets.keySet().iterator().next(), (Charset)filenameAndCharset.getB());
        } else {
            LinkedList windList = new LinkedList();
            for (Map.Entry<InputStream, Util.Pair<String, Charset>> inputStreamAndFileName : inputStreamsAndFilenamesAndCharsets.entrySet()) {
                logger.info("Reading Bravo wind data from " + (String)inputStreamAndFileName.getValue().getA());
                Util.addAll(this.readWind((String)inputStreamAndFileName.getValue().getA(), inputStreamAndFileName.getKey(), (Charset)inputStreamAndFileName.getValue().getB()), windList);
            }
            windFixes = windList;
        }
        HashMap<WindSource, Iterable<Wind>> result = new HashMap<WindSource, Iterable<Wind>>();
        result.put(defaultWindSource, windFixes);
        return result;
    }

    private Iterable<Wind> readWind(String filename, InputStream inputStream, Charset charset) throws InterruptedException, IOException, FormatNotSupportedException {
        LinkedList<Wind> result;
        block14: {
            String actualFileName;
            result = new LinkedList<Wind>();
            HashMap<String, Integer> columnsMap = new HashMap<String, Integer>();
            Fields[] fieldsArray = Fields.values();
            int n = fieldsArray.length;
            int n2 = 0;
            while (n2 < n) {
                Fields field = fieldsArray[n2];
                columnsMap.put(field.name(), field.ordinal());
                ++n2;
            }
            BaseBravoDataImporterImpl importer = new BaseBravoDataImporterImpl(columnsMap, BRAVO_WIND_IMPORT);
            BaseDoubleVectorFixImporter.Callback callback = new BaseDoubleVectorFixImporter.Callback(){

                public void addFixes(Iterable<DoubleVectorFix> fixes, TrackFileImportDeviceIdentifier device) {
                    for (DoubleVectorFix fix : fixes) {
                        WindImpl wind = new WindImpl((Position)new DegreePosition(FunnyDegreeConverter.funnyLatLng(fix.get(Fields.Lat.ordinal())), FunnyDegreeConverter.funnyLatLng(fix.get(Fields.Lon.ordinal()))), fix.getTimePoint(), (SpeedWithBearing)new KnotSpeedWithBearingImpl(fix.get(Fields.TWS.ordinal()).doubleValue(), new DegreeBearingImpl(fix.get(Fields.TWD.ordinal()).doubleValue()).reverse()));
                        result.add(wind);
                    }
                }
            };
            if (filename.toLowerCase().endsWith(".zip")) {
                logger.info("Bravo file " + filename + " is a ZIP file");
                Throwable throwable = null;
                fieldsArray = null;
                try (ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
                    ZipEntry entry;
                    while ((entry = zipInputStream.getNextEntry()) != null) {
                        if (!entry.getName().toLowerCase().endsWith(".txt")) continue;
                        logger.info("Reading Bravo wind data from " + filename + "'s ZIP entry " + entry.getName());
                        importer.importFixes((InputStream)zipInputStream, Charset.forName("UTF-8"), callback, entry.getName(), BRAVO_WIND_IMPORT, false);
                    }
                    break block14;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            if (filename.toLowerCase().endsWith(GZIP_SUFFIX)) {
                inputStream = new GZIPInputStream(inputStream);
                actualFileName = filename.substring(0, filename.length() - GZIP_SUFFIX.length());
            } else {
                actualFileName = filename;
            }
            importer.importFixes(inputStream, Charset.forName("UTF-8"), callback, actualFileName, BRAVO_WIND_IMPORT, false);
        }
        return result;
    }

    private static enum Fields {
        Lat,
        Lon,
        TWS,
        TWD;

    }
}

