/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.windimport;

import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.RegattaNameAndRaceName;
import com.sap.sailing.server.gateway.AbstractJsonHttpServlet;
import com.sap.sailing.server.gateway.windimport.AbstractWindImporter;
import com.sap.sse.common.fileupload.FileUploadUtil;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public abstract class AbstractWindImportServlet
extends AbstractJsonHttpServlet {
    private static final Logger logger = Logger.getLogger(AbstractWindImportServlet.class.getName());
    private static final long serialVersionUID = 1L;
    private final AbstractWindImporter importer;

    public AbstractWindImportServlet(AbstractWindImporter importer) {
        this.importer = importer;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            response.sendError(400);
            return;
        }
        AbstractWindImporter.WindImportResult windImportResult = new AbstractWindImporter.WindImportResult();
        try {
            AbstractWindImporter.UploadRequest uploadRequest = this.readRequest(request);
            for (RegattaAndRaceIdentifier trackedRace : uploadRequest.races) {
                this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)trackedRace);
            }
            this.importer.importWindForUploadRequest(this.getService(), windImportResult, uploadRequest);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error ocurred trying to import wind fixes", e);
            windImportResult.error = e.toString();
        }
        response.getWriter().write(FileUploadUtil.getHtmlWithEmbeddedJsonContent((String)windImportResult.json().toJSONString()));
    }

    private AbstractWindImporter.UploadRequest readRequest(HttpServletRequest req) throws FileUploadException, ParseException {
        AbstractWindImporter.UploadRequest result = new AbstractWindImporter.UploadRequest();
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        List items = upload.parseRequest(req);
        for (FileItem item : items) {
            if (item.isFormField() && item.getString() != null && item.getString().trim().length() > 0) {
                if ("boatId".equals(item.getFieldName())) {
                    result.boatId = item.getString().trim();
                    continue;
                }
                if (!"races".equals(item.getFieldName())) continue;
                JSONArray races = (JSONArray)new JSONParser().parse(item.getString().trim());
                for (Object raceEntry : races) {
                    result.races.add((RegattaAndRaceIdentifier)new RegattaNameAndRaceName((String)((JSONObject)raceEntry).get((Object)"regatta"), (String)((JSONObject)raceEntry).get((Object)"race")));
                }
                continue;
            }
            if (item.getSize() <= 0L) continue;
            result.files.add(item);
        }
        return result;
    }
}

