/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.trackfiles.impl;

import com.sap.sailing.server.gateway.impl.AbstractFileUploadServlet;
import com.sap.sailing.server.gateway.trackfiles.impl.ImportResult;
import com.sap.sailing.server.gateway.trackfiles.impl.ImportResultSerializer;
import com.sap.sailing.server.gateway.trackfiles.impl.TrackFilesImporter;
import com.sap.sse.common.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.json.simple.JSONAware;

public class TrackFilesImportServlet
extends AbstractFileUploadServlet {
    public static final String PREFERRED_IMPORTER = "preferredImporter";
    private static final long serialVersionUID = 1120226743039934620L;
    private static final Logger logger = Logger.getLogger(TrackFilesImportServlet.class.getName());

    @Override
    protected void process(List<FileItem> fileItems, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ImportResult importResult = new ImportResult(logger);
        try {
            try {
                String prefImporterType = null;
                ArrayList<Util.Pair<String, FileItem>> files = new ArrayList<Util.Pair<String, FileItem>>();
                for (FileItem item : fileItems) {
                    if (!item.isFormField()) {
                        files.add((Util.Pair<String, FileItem>)new Util.Pair((Object)item.getName(), (Object)item));
                        continue;
                    }
                    if (item.getFieldName() == null || !item.getFieldName().equals(PREFERRED_IMPORTER)) continue;
                    prefImporterType = item.getString();
                }
                new TrackFilesImporter(this.getService(), this.getServiceFinderFactory(), this.getContext()).importFixes(importResult, prefImporterType, files);
            }
            catch (Exception e) {
                importResult.add(e);
                this.writeJsonIntoHtmlResponse(resp, (JSONAware)ImportResultSerializer.serializeImportResult(importResult));
            }
        }
        finally {
            this.writeJsonIntoHtmlResponse(resp, (JSONAware)ImportResultSerializer.serializeImportResult(importResult));
        }
    }
}

