/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.trackfiles.impl;

import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.domain.common.tracking.DoubleVectorFix;
import com.sap.sailing.domain.trackfiles.TrackFileImportDeviceIdentifier;
import com.sap.sailing.domain.trackimport.BaseDoubleVectorFixImporter;
import com.sap.sailing.domain.trackimport.DoubleVectorFixImporter;
import com.sap.sailing.domain.trackimport.FormatNotSupportedException;
import com.sap.sailing.server.gateway.trackfiles.impl.ImportResult;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sse.common.NoCorrespondingServiceRegisteredException;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.Util;
import com.sap.sse.util.FileItemHelper;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.fileupload.FileItem;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class SensorDataImporter {
    private static final Logger logger = Logger.getLogger(SensorDataImporter.class.getName());
    private final RacingEventService service;
    private final BundleContext context;

    public SensorDataImporter(RacingEventService service, BundleContext context) {
        this.service = service;
        this.context = context;
    }

    public void importFiles(boolean enableDownsampler, ImportResult result, Iterable<Util.Pair<String, FileItem>> importerNamesAndFiles) throws IOException {
        LinkedHashSet<DoubleVectorFixImporter> availableImporters = new LinkedHashSet<DoubleVectorFixImporter>();
        availableImporters.addAll(this.getOSGiRegisteredImporters());
        for (Util.Pair<String, FileItem> file : importerNamesAndFiles) {
            String requestedImporterName = (String)file.getA();
            FileItem fi = (FileItem)file.getB();
            Object importerToUse = null;
            for (DoubleVectorFixImporter candidate : availableImporters) {
                if (!candidate.getType().equals(requestedImporterName)) continue;
                importerToUse = candidate;
                break;
            }
            if (importerToUse == null) {
                throw new RuntimeException("Sensor importer not found: " + requestedImporterName);
            }
            logger.log(Level.INFO, "Going to import sensor data file  with importer " + importerToUse.getClass().getSimpleName());
            final HashSet deviceIds = new HashSet();
            Object object = null;
            Iterator iterator = null;
            try (BufferedInputStream in = new BufferedInputStream(fi.getInputStream());){
                String filename = fi.getName();
                try {
                    Charset charset = FileItemHelper.getCharset((FileItem)fi);
                    importerToUse.importFixes((InputStream)in, charset, new BaseDoubleVectorFixImporter.Callback(){

                        public void addFixes(Iterable<DoubleVectorFix> fixes, TrackFileImportDeviceIdentifier device) {
                            SensorDataImporter.this.storeFixes(fixes, (DeviceIdentifier)device);
                            deviceIds.add(device);
                        }
                    }, filename, requestedImporterName, enableDownsampler);
                    logger.log(Level.INFO, "Successfully imported file " + requestedImporterName);
                }
                catch (FormatNotSupportedException e) {
                    result.add(requestedImporterName, filename, (Exception)((Object)e));
                }
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                } else if (object != throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                throw object;
            }
            for (TrackFileImportDeviceIdentifier device : deviceIds) {
                TimeRange range = this.service.getSensorFixStore().getTimeRangeCoveredByFixes((DeviceIdentifier)device);
                long amount = this.service.getSensorFixStore().getNumberOfFixes((DeviceIdentifier)device);
                result.addTrackData(new ImportResult.TrackImportDTO(device.getId(), range, amount));
            }
        }
    }

    private void storeFixes(Iterable<DoubleVectorFix> fixes, DeviceIdentifier deviceIdentifier) {
        try {
            this.service.getSensorFixStore().storeFixes(deviceIdentifier, fixes, false, false);
        }
        catch (NoCorrespondingServiceRegisteredException e) {
            logger.log(Level.WARNING, "Could not store fix for " + deviceIdentifier);
        }
    }

    private Collection<DoubleVectorFixImporter> getOSGiRegisteredImporters() {
        ArrayList<DoubleVectorFixImporter> result = new ArrayList<DoubleVectorFixImporter>();
        try {
            Collection refs = this.context.getServiceReferences(DoubleVectorFixImporter.class, null);
            for (ServiceReference ref : refs) {
                result.add((DoubleVectorFixImporter)this.context.getService(ref));
            }
        }
        catch (InvalidSyntaxException e) {
            logger.log(Level.WARNING, "Could not create OSGi filter");
        }
        return result;
    }
}

