/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.trackfiles.impl;

import com.sap.sailing.server.trackfiles.impl.ExpeditionImportFileHandler;
import java.util.Arrays;

class ExpeditionImportFilenameUtils {
    private static final Iterable<String> supportedExpeditionArchiveFileExtensions = Arrays.asList("gz", "zip");

    ExpeditionImportFilenameUtils() {
    }

    static String truncateFilenameExtentions(String filenameWithExtensions, ExpeditionImportFileHandler fileHandler) {
        return ExpeditionImportFilenameUtils.removeTailIfExists(ExpeditionImportFilenameUtils.removeTailIfExists(filenameWithExtensions, supportedExpeditionArchiveFileExtensions), fileHandler.getSupportedFileExtensions());
    }

    private static String removeTailIfExists(String source, Iterable<String> extensionsToRemove) {
        for (String toRemove : extensionsToRemove) {
            String tailToRemove = "." + toRemove;
            if (!source.toLowerCase().endsWith(tailToRemove)) continue;
            return source.substring(0, source.length() - tailToRemove.length());
        }
        return source;
    }
}

