/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.trackfiles.impl;

import com.sap.sailing.domain.abstractlog.AbstractLogEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogCourseDesignChangedEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLog;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogDefineMarkEventImpl;
import com.sap.sailing.domain.base.ControlPoint;
import com.sap.sailing.domain.base.ControlPointWithTwoMarks;
import com.sap.sailing.domain.base.CourseBase;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.base.impl.CourseDataImpl;
import com.sap.sailing.domain.base.impl.WaypointImpl;
import com.sap.sailing.domain.common.CourseDesignerMode;
import com.sap.sailing.domain.common.PassingInstruction;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.TrackedRaceStatusEnum;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.domain.common.sensordata.ExpeditionExtendedSensorDataMetadata;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.impl.GPSFixImpl;
import com.sap.sailing.domain.racelogtracking.RaceLogTrackingAdapter;
import com.sap.sailing.domain.trackimport.FormatNotSupportedException;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.TrackedRaceStatus;
import com.sap.sailing.domain.tracking.impl.TrackedRaceStatusImpl;
import com.sap.sailing.server.gateway.trackfiles.impl.ExpeditionStartData;
import com.sap.sailing.server.gateway.trackfiles.impl.ExpeditionStartDataImpl;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.trackfiles.impl.CompressedStreamsUtil;
import com.sap.sailing.server.trackfiles.impl.ExpeditionExtendedDataImporterImpl;
import com.sap.sailing.server.trackfiles.impl.ExpeditionImportFileHandler;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

public class ExpeditionCourseInferrer {
    private static final Logger logger = Logger.getLogger(ExpeditionCourseInferrer.class.getName());
    private static final String START_LINE_PORT_END_LAT = "port lat";
    private static final String START_LINE_PORT_END_LON = "port lon";
    private static final String START_LINE_STARBOARD_END_LAT = "stbd lat";
    private static final String START_LINE_STARBOARD_END_LON = "stbd lon";
    private static final String START_LINE_PORT_END_MARK_NAME = "start p";
    private static final String START_LINE_STARBOARD_END_MARK_NAME = "start s";
    private static final String START_LINE_CONTROL_POINT_NAME = "start";
    private final RaceLogTrackingAdapter raceLogTrackingAdapter;

    public ExpeditionCourseInferrer(RaceLogTrackingAdapter raceLogTrackingAdapter) {
        this.raceLogTrackingAdapter = raceLogTrackingAdapter;
    }

    public ExpeditionStartData getStartData(InputStream inputStream, final String filenameWithSuffix, Charset charset) throws IOException, FormatNotSupportedException {
        final ArrayList<TimePoint> startTimeCandidates = new ArrayList<TimePoint>();
        final ArrayList<GPSFix> startLinePortEndFixes = new ArrayList<GPSFix>();
        final ArrayList<GPSFix> startLineStarboardEndFixes = new ArrayList<GPSFix>();
        CompressedStreamsUtil.handlePotentiallyCompressedFiles((String)filenameWithSuffix, (InputStream)inputStream, (Charset)charset, (CompressedStreamsUtil.FileHandler)new ExpeditionImportFileHandler(){

            protected void handleExpeditionFile(String fileName, InputStream inputStream, Charset charset) throws IOException, FormatNotSupportedException {
                logger.fine("Start parsing Expedition file");
                AtomicLong lineNr = new AtomicLong();
                Throwable throwable = null;
                Object var6_7 = null;
                try (BufferedReader buffer = new BufferedReader(new InputStreamReader(inputStream, charset));){
                    String headerLine = buffer.readLine();
                    lineNr.incrementAndGet();
                    logger.fine("Validate and parse header columns");
                    ExpeditionExtendedDataImporterImpl importer = new ExpeditionExtendedDataImporterImpl();
                    Map colIndices = importer.parseHeader(headerLine);
                    importer.validateHeader(colIndices);
                    Double[] lastTimeToGunValue = new Double[1];
                    buffer.lines().forEach(line -> {
                        lineNr.incrementAndGet();
                        if (!line.trim().isEmpty()) {
                            importer.parseLine(lineNr.get(), filenameWithSuffix, line, colIndices, (timePoint, lineContentTokens, columnsInFileFromHeader) -> {
                                Double timeToGunValue = ExpeditionCourseInferrer.this.getColumnValue(lineContentTokens, columnsInFileFromHeader, ExpeditionExtendedSensorDataMetadata.EXPEDITION_TMTOGUN.getColumnName());
                                if (lastTimeToGunValue[0] != null && lastTimeToGunValue[0] > 0.0 && timeToGunValue != null && timeToGunValue <= 0.0) {
                                    startTimeCandidates.add(timePoint);
                                }
                                doubleArray[0] = timeToGunValue;
                                Double startLinePortEndLat = ExpeditionCourseInferrer.this.getColumnValue(lineContentTokens, columnsInFileFromHeader, ExpeditionCourseInferrer.START_LINE_PORT_END_LAT);
                                Double startLinePortEndLon = ExpeditionCourseInferrer.this.getColumnValue(lineContentTokens, columnsInFileFromHeader, ExpeditionCourseInferrer.START_LINE_PORT_END_LON);
                                Double startLineStarboardEndLat = ExpeditionCourseInferrer.this.getColumnValue(lineContentTokens, columnsInFileFromHeader, ExpeditionCourseInferrer.START_LINE_STARBOARD_END_LAT);
                                Double startLineStarboardEndLon = ExpeditionCourseInferrer.this.getColumnValue(lineContentTokens, columnsInFileFromHeader, ExpeditionCourseInferrer.START_LINE_STARBOARD_END_LON);
                                ExpeditionCourseInferrer.this.addFixIfCoordinatesValid(startLinePortEndLat, startLinePortEndLon, timePoint, startLinePortEndFixes);
                                ExpeditionCourseInferrer.this.addFixIfCoordinatesValid(startLineStarboardEndLat, startLineStarboardEndLon, timePoint, startLineStarboardEndFixes);
                            });
                        }
                    });
                    buffer.close();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        });
        return new ExpeditionStartDataImpl(startLinePortEndFixes, startLineStarboardEndFixes, startTimeCandidates);
    }

    private void addFixIfCoordinatesValid(Double lat, Double lon, TimePoint timePoint, List<GPSFix> listToAddTo) {
        if (lat != null && lon != null) {
            listToAddTo.add((GPSFix)new GPSFixImpl((Position)new DegreePosition(lat.doubleValue(), lon.doubleValue()), timePoint));
        }
    }

    private Double getColumnValue(String[] lineContentTokens, Map<String, Integer> columnsInFileFromHeader, String columnName) {
        return this.getColumnValue(lineContentTokens, columnsInFileFromHeader.get(columnName.toLowerCase()));
    }

    private Double getColumnValue(String[] lineContentTokens, Integer columnIndex) {
        return columnIndex == null ? null : (columnIndex >= lineContentTokens.length ? null : (lineContentTokens[columnIndex].trim().isEmpty() ? null : Double.valueOf(Double.parseDouble(lineContentTokens[columnIndex]))));
    }

    public void setStartLine(ExpeditionStartData startData, Iterable<DynamicTrackedRace> trackedRaces, RacingEventService racingEventService) {
        if (!Util.isEmpty(trackedRaces)) {
            for (DynamicTrackedRace trackedRace : trackedRaces) {
                trackedRace.setStatus((TrackedRaceStatus)new TrackedRaceStatusImpl(TrackedRaceStatusEnum.LOADING, 0.5));
            }
            DynamicTrackedRace anyTrackedRace = trackedRaces.iterator().next();
            logger.info("Adding mark pings for start p using tracked race " + anyTrackedRace.getRace().getName());
            Mark portMark = this.getOrCreateMarkAndAddPings(anyTrackedRace, START_LINE_PORT_END_MARK_NAME, startData.getStartLinePortFixes(), racingEventService);
            logger.info("Adding mark pings for start s using tracked race " + anyTrackedRace.getRace().getName());
            Mark starboardMark = this.getOrCreateMarkAndAddPings(anyTrackedRace, START_LINE_STARBOARD_END_MARK_NAME, startData.getStartLineStarboardFixes(), racingEventService);
            for (DynamicTrackedRace trackedRace : trackedRaces) {
                this.setCourseWithStartLine(trackedRace, racingEventService, portMark, starboardMark);
            }
            for (DynamicTrackedRace trackedRace : trackedRaces) {
                trackedRace.setStatus((TrackedRaceStatus)new TrackedRaceStatusImpl(TrackedRaceStatusEnum.TRACKING, 1.0));
            }
        }
    }

    private void setCourseWithStartLine(DynamicTrackedRace trackedRace, RacingEventService racingEventService, Mark portMark, Mark starboardMark) {
        logger.info("Creating start line in tracked race " + trackedRace.getRace().getName());
        ControlPointWithTwoMarks startLine = racingEventService.getBaseDomainFactory().getOrCreateControlPointWithTwoMarks((Serializable)UUID.randomUUID(), START_LINE_CONTROL_POINT_NAME, portMark, starboardMark, START_LINE_CONTROL_POINT_NAME);
        CourseDataImpl course = new CourseDataImpl("Auto-Course " + trackedRace.getRace().getName());
        course.addWaypoint(0, (Waypoint)new WaypointImpl((ControlPoint)startLine, PassingInstruction.Line));
        RaceLog raceLog = (RaceLog)trackedRace.getAttachedRaceLogs().iterator().next();
        RaceLogCourseDesignChangedEventImpl event = new RaceLogCourseDesignChangedEventImpl(MillisecondsTimePoint.now(), racingEventService.getServerAuthor(), raceLog.getCurrentPassId(), (CourseBase)course, CourseDesignerMode.ADMIN_CONSOLE);
        raceLog.add((AbstractLogEvent)event);
    }

    private Mark getOrCreateMarkAndAddPings(DynamicTrackedRace trackedRace, String markName, Iterable<GPSFix> markFixes, RacingEventService racingEventService) {
        Mark mark = this.getOrCreateMark(trackedRace, markName, racingEventService);
        for (GPSFix fix : markFixes) {
            this.recordFix(mark, fix, trackedRace, racingEventService);
        }
        return mark;
    }

    private void recordFix(Mark mark, GPSFix fix, DynamicTrackedRace trackedRace, RacingEventService racingEventService) {
        this.raceLogTrackingAdapter.pingMark((RegattaLog)trackedRace.getAttachedRegattaLogs().iterator().next(), mark, fix, racingEventService);
    }

    private Mark getOrCreateMark(DynamicTrackedRace trackedRace, String markName, RacingEventService racingEventService) {
        Mark mark = null;
        Regatta regatta = trackedRace.getTrackedRegatta().getRegatta();
        block0: for (RaceColumn raceColumn : regatta.getRaceColumns()) {
            for (Fleet fleet : raceColumn.getFleets()) {
                TrackedRace trackedRaceForFleet = raceColumn.getTrackedRace(fleet);
                if (trackedRaceForFleet != trackedRace) continue;
                for (Mark availableMark : raceColumn.getAvailableMarks(fleet)) {
                    if (!availableMark.getName().equals(markName)) continue;
                    mark = availableMark;
                    break block0;
                }
                if (mark != null) break block0;
                mark = racingEventService.getBaseDomainFactory().getOrCreateMark((Serializable)UUID.randomUUID(), markName, markName);
                TimePoint now = MillisecondsTimePoint.now();
                RegattaLogDefineMarkEventImpl defineMarkEvent = new RegattaLogDefineMarkEventImpl(now, racingEventService.getServerAuthor(), now, (Serializable)UUID.randomUUID(), mark);
                regatta.getRegattaLog().add((AbstractLogEvent)defineMarkEvent);
                break block0;
            }
        }
        return mark;
    }
}

