/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.subscription;

import com.sap.sailing.server.gateway.subscription.SubscriptionWebHookServlet;
import com.sap.sse.security.shared.UserManagementException;
import com.sap.sse.security.shared.impl.User;
import com.sap.sse.security.shared.subscription.Subscription;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;

public abstract class SubscriptionWebHookHandler {
    private static final Logger logger = Logger.getLogger(SubscriptionWebHookHandler.class.getName());
    protected SubscriptionWebHookServlet context;

    public abstract void handle(HttpServletRequest var1, HttpServletResponse var2);

    public abstract String getHandlerPath();

    public void setServletContext(SubscriptionWebHookServlet context) {
        this.context = context;
    }

    protected User getUser(String customerId) {
        return this.context.getSecurityService().getUserByName(customerId);
    }

    protected void updateUserSubscription(User user, Subscription subscription) throws UserManagementException {
        logger.info(() -> "Update subscription, user " + user.getName() + ", new subscription " + (subscription != null ? subscription.toString() : "null"));
        this.context.getSecurityService().updateUserSubscription(user.getName(), subscription);
    }

    protected void sendSuccess(HttpServletResponse response) {
        response.setStatus(Response.Status.OK.getStatusCode());
    }

    protected void sendFail(HttpServletResponse response) {
        response.setStatus(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
    }
}

