/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.subscription;

import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.web.filter.authz.PermissionsAuthorizationFilter;

public abstract class SubscriptionPermissionsAuthorizationFilter
extends PermissionsAuthorizationFilter {
    private static final Logger logger = Logger.getLogger(SubscriptionPermissionsAuthorizationFilter.class.getName());

    public boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) throws IOException {
        boolean isAllowed;
        String username = this.getSubscriptionUserName(request);
        boolean bl = isAllowed = !StringUtils.isEmpty((String)username) && super.isAccessAllowed(request, response, (Object)new String[]{SecuredSecurityTypes.USER.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)SecuredSecurityTypes.UserActions.ADD_SUBSCRIPTION, new TypeRelativeObjectIdentifier(new String[]{username}))});
        if (!isAllowed) {
            logger.warning(() -> "Subscription webhook event requested by " + this.getSubject(request, response).getPrincipal() + " is denied for user " + (username != null ? username : ""));
        }
        return isAllowed;
    }

    protected abstract String getSubscriptionUserName(ServletRequest var1);
}

