/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.jaxrs.spi;

import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.configuration.DeviceConfiguration;
import com.sap.sailing.domain.base.impl.CompetitorSerializationCustomizer;
import com.sap.sailing.domain.common.media.MediaTrack;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboard;
import com.sap.sailing.domain.masterdataimport.TopLevelMasterData;
import com.sap.sailing.domain.tracking.RaceTrackingConnectivityParameters;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.shared.server.gateway.jaxrs.AbstractSailingServerResource;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import com.sap.sse.security.shared.impl.User;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.shiro.authz.AuthorizationException;

@Path(value="/v1/masterdata/leaderboardgroups")
public class MasterDataResource
extends AbstractSailingServerResource {
    private static final Logger logger = Logger.getLogger(MasterDataResource.class.getName());

    @POST
    @Produces(value={"application/x-java-serialized-object"})
    public Response getMasterDataByLeaderboardGroups(@QueryParam(value="uuids[]") List<UUID> requestedLeaderboardGroupsUuids, @QueryParam(value="compress") Boolean compress, @QueryParam(value="exportWind") Boolean exportWind, @QueryParam(value="exportDeviceConfigs") Boolean exportDeviceConfigs, @QueryParam(value="exportTrackedRacesAndStartTracking") Boolean exportTrackedRacesAndStartTracking) throws UnsupportedEncodingException {
        SecurityService securityService = this.getSecurityService();
        User user = securityService.getCurrentUser();
        securityService.checkCurrentUserServerPermission(SecuredSecurityTypes.ServerActions.CAN_EXPORT_MASTERDATA);
        long startTime = System.currentTimeMillis();
        logger.info("Masterdataexport has started; requesting user: " + user.getName());
        if (compress == null) {
            compress = false;
        }
        if (exportWind == null) {
            exportWind = true;
        }
        if (exportDeviceConfigs == null) {
            exportDeviceConfigs = false;
        }
        if (exportTrackedRacesAndStartTracking == null) {
            exportTrackedRacesAndStartTracking = false;
        }
        logger.info(String.format("Masterdataexport gzip compression is turned %s", compress != false ? "on" : "off"));
        Map allLeaderboardGroups = this.getService().getLeaderboardGroups();
        HashSet<LeaderboardGroup> groupsToExport = new HashSet<LeaderboardGroup>();
        if (requestedLeaderboardGroupsUuids.isEmpty()) {
            for (LeaderboardGroup group : allLeaderboardGroups.values()) {
                if (!securityService.hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)group)) continue;
                groupsToExport.add(group);
            }
        } else {
            for (UUID uuid : requestedLeaderboardGroupsUuids) {
                LeaderboardGroup group = (LeaderboardGroup)allLeaderboardGroups.get(uuid);
                if (group == null) continue;
                if (!securityService.hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)group)) {
                    throw new AuthorizationException("No permission to read leaderboard group with uuid'" + uuid + "'");
                }
                groupsToExport.add(group);
            }
        }
        ArrayList<Serializable> competitorIds = new ArrayList<Serializable>();
        HashSet<RaceTrackingConnectivityParameters> connectivityParametersToRestore = new HashSet<RaceTrackingConnectivityParameters>();
        for (LeaderboardGroup lg : groupsToExport) {
            for (Leaderboard leaderboard : lg.getLeaderboards()) {
                if (!securityService.hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard) || leaderboard instanceof RegattaLeaderboard && !securityService.hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)((RegattaLeaderboard)leaderboard).getRegatta())) {
                    throw new AuthorizationException("No permission to read all leaderboards and regattas of leaderboard group '" + lg.getName() + "'");
                }
                for (Competitor competitor : leaderboard.getAllCompetitors()) {
                    if (!securityService.hasCurrentUserOneOfExplicitPermissions((WithQualifiedObjectIdentifier)competitor, SecuredSecurityTypes.PublicReadableActions.READ_AND_READ_PUBLIC_ACTIONS)) {
                        throw new AuthorizationException("No permission to read competitor " + competitor.getId() + " for leaderboard '" + leaderboard.getName() + "'");
                    }
                    competitorIds.add(competitor.getId());
                }
                for (Boat boat : leaderboard.getAllBoats()) {
                    if (securityService.hasCurrentUserOneOfExplicitPermissions((WithQualifiedObjectIdentifier)boat, SecuredSecurityTypes.PublicReadableActions.READ_AND_READ_PUBLIC_ACTIONS)) continue;
                    throw new AuthorizationException("No permission to read boat " + boat.getId() + " for leaderboard '" + leaderboard.getName() + "'");
                }
                if (!exportTrackedRacesAndStartTracking.booleanValue()) continue;
                for (TrackedRace trackedRace : leaderboard.getTrackedRaces()) {
                    securityService.checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)trackedRace);
                    connectivityParametersToRestore.add(this.getService().getConnectivityParametersByRace(trackedRace.getRace()));
                }
            }
        }
        HashSet<DeviceConfiguration> raceManagerDeviceConfigurations = new HashSet<DeviceConfiguration>();
        if (exportDeviceConfigs.booleanValue()) {
            for (DeviceConfiguration deviceConfig : this.getAllDeviceConfigs()) {
                if (!securityService.hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)deviceConfig)) continue;
                raceManagerDeviceConfigurations.add(deviceConfig);
            }
        }
        ArrayList<Event> events = new ArrayList<Event>();
        for (Event event : this.getService().getAllEvents()) {
            events.add(event);
        }
        ArrayList<MediaTrack> mediaTracks = new ArrayList<MediaTrack>();
        for (MediaTrack mediaTrack : this.getService().getAllMediaTracks()) {
            mediaTracks.add(mediaTrack);
        }
        HashMap<String, Regatta> regattaRaceIds = new HashMap<String, Regatta>();
        for (Map.Entry entry : this.getService().getPersistentRegattasForRaceIDs().entrySet()) {
            regattaRaceIds.put((String)entry.getKey(), (Regatta)entry.getValue());
        }
        TopLevelMasterData topLevelMasterData = new TopLevelMasterData(groupsToExport, events, regattaRaceIds, mediaTracks, this.getService().getSensorFixStore(), exportWind.booleanValue(), raceManagerDeviceConfigurations, connectivityParametersToRestore);
        for (Event event : topLevelMasterData.getAllEvents()) {
            if (securityService.hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)event)) continue;
            throw new AuthorizationException("No permission to read event " + event.getId());
        }
        for (MediaTrack mediaTrack : topLevelMasterData.getFilteredMediaTracks()) {
            if (securityService.hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)mediaTrack)) continue;
            throw new AuthorizationException("No permission to read media track " + mediaTrack.dbId);
        }
        AbstractStreamingOutput streamingOutput = compress != false ? new CompressingStreamingOutput(topLevelMasterData, competitorIds, startTime, securityService) : new NonCompressingStreamingOutput(topLevelMasterData, competitorIds, startTime, securityService);
        Response.ResponseBuilder resp = Response.ok((Object)streamingOutput);
        if (compress.booleanValue()) {
            resp.header("Content-Encoding", (Object)"gzip");
        }
        Response builtResponse = resp.build();
        long timeToExport = System.currentTimeMillis() - startTime;
        logger.info(String.format("Took %s ms to start masterdataexport-streaming.", timeToExport));
        return builtResponse;
    }

    private Iterable<DeviceConfiguration> getAllDeviceConfigs() {
        return this.getService().getAllDeviceConfigurations();
    }

    private void writeObjects(List<Serializable> competitorIds, TopLevelMasterData masterData, ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(competitorIds);
        objectOutputStream.writeObject(masterData.getAllRegattas());
        objectOutputStream.writeObject(masterData);
    }

    private abstract class AbstractStreamingOutput
    implements StreamingOutput {
        private final TopLevelMasterData masterData;
        private final List<Serializable> competitorIds;
        private final long startTime;
        private final SecurityService securityService;

        protected AbstractStreamingOutput(TopLevelMasterData masterData, List<Serializable> competitorIds, long startTime, SecurityService securityService) {
            this.masterData = masterData;
            this.competitorIds = competitorIds;
            this.startTime = startTime;
            this.securityService = securityService;
        }

        protected abstract OutputStream wrapOutputStream(OutputStream var1) throws IOException;

        public void write(OutputStream output) throws IOException, WebApplicationException {
            CompetitorSerializationCustomizer.doWithCustomizer(c -> !this.securityService.hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)c) && c.getEmail() != null, () -> {
                try {
                    ObjectOutputStream objectOutputStream = null;
                    try {
                        OutputStream gzipOrNot = this.wrapOutputStream(output);
                        ByteCountOutputStreamDecorator outputStreamWithByteCounter = new ByteCountOutputStreamDecorator(gzipOrNot);
                        objectOutputStream = new ObjectOutputStream(outputStreamWithByteCounter);
                        this.masterData.setMasterDataExportFlagOnRaceColumns(true);
                        MasterDataResource.this.writeObjects(this.competitorIds, this.masterData, objectOutputStream);
                    }
                    finally {
                        objectOutputStream.close();
                        this.masterData.setMasterDataExportFlagOnRaceColumns(false);
                    }
                    long timeToExport = System.currentTimeMillis() - this.startTime;
                    logger.info(String.format("Took %s ms to finish masterdataexport", timeToExport));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    private class ByteCountOutputStreamDecorator
    extends FilterOutputStream {
        private long byteCount;

        public ByteCountOutputStreamDecorator(OutputStream out) {
            super(out);
            this.byteCount = 0L;
        }

        @Override
        public void write(byte[] b) throws IOException {
            ++this.byteCount;
            super.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.byteCount += (long)len;
            super.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            ++this.byteCount;
            super.write(b);
        }

        @Override
        public void close() throws IOException {
            logger.info(String.format("Uncompressed data size of masterdataexport: %s bytes", this.byteCount));
            super.close();
        }
    }

    private class CompressingStreamingOutput
    extends AbstractStreamingOutput {
        protected CompressingStreamingOutput(TopLevelMasterData masterData, List<Serializable> competitorIds, long startTime, SecurityService securityService) {
            super(masterData, competitorIds, startTime, securityService);
        }

        @Override
        protected OutputStream wrapOutputStream(OutputStream outputStream) throws IOException {
            return new GZIPOutputStream(outputStream);
        }
    }

    private class NonCompressingStreamingOutput
    extends AbstractStreamingOutput {
        protected NonCompressingStreamingOutput(TopLevelMasterData masterData, List<Serializable> competitorIds, long startTime, SecurityService securityService) {
            super(masterData, competitorIds, startTime, securityService);
        }

        @Override
        protected OutputStream wrapOutputStream(OutputStream outputStream) {
            return outputStream;
        }
    }
}

