/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.jaxrs.sharing;

import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.WithDescription;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.server.gateway.jaxrs.sharing.HomeSharingUtils;
import com.sap.sailing.server.gateway.jaxrs.sharing.TokenizedHomePlaceUrlBuilder;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.shared.server.gateway.jaxrs.AbstractSailingServerResource;
import com.sap.sse.common.Named;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;

@Path(value="/home")
public class HomeSharingResource
extends AbstractSailingServerResource {
    @Context
    UriInfo uriInfo;

    @GET
    @Path(value="/events/{eventId}")
    @Produces(value={"text/html"})
    public String getSharedEvent(@HeaderParam(value="user-agent") String userAgent, @PathParam(value="eventId") String eventId) {
        UUID uuid;
        RacingEventService eventService = this.getService();
        Event event = eventService.getEvent((Serializable)(uuid = UUID.fromString(eventId)));
        if (event != null) {
            SecurityService securityService = this.getSecurityService();
            securityService.checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)event);
            String title = event.getName();
            String description = HomeSharingUtils.findDescription((WithDescription)event);
            String imageUrl = HomeSharingUtils.findTeaserImageUrl(event);
            String placeUrl = new TokenizedHomePlaceUrlBuilder(this.uriInfo).asEventPlaceLink(eventId);
            Map<String, String> replacementMap = HomeSharingUtils.createReplacementMap(title, description, imageUrl, placeUrl, userAgent);
            String content = HomeSharingUtils.loadSharingHTML(((Object)((Object)this)).getClass().getClassLoader(), this.uriInfo);
            return HomeSharingUtils.replaceMetatags(content, replacementMap);
        }
        throw new IllegalArgumentException();
    }

    @GET
    @Path(value="/events/{eventId}/regattas/{regattaId}")
    @Produces(value={"text/html"})
    public String getSharedRegatta(@PathParam(value="eventId") String eventId, @PathParam(value="regattaId") String regattaId, @HeaderParam(value="user-agent") String userAgent) throws UnsupportedEncodingException {
        RacingEventService eventService = this.getService();
        SecurityService securityService = this.getSecurityService();
        UUID uuid = UUID.fromString(eventId);
        Event event = eventService.getEvent((Serializable)uuid);
        if (event != null) {
            String title;
            String decodedRegattaId;
            securityService.checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)event);
            String description = HomeSharingUtils.findDescription((WithDescription)event);
            String imageUrl = HomeSharingUtils.findTeaserImageUrl(event);
            TokenizedHomePlaceUrlBuilder baseUrl = new TokenizedHomePlaceUrlBuilder(this.uriInfo);
            String placeUrl = baseUrl.getBaseUrl().toString();
            try {
                decodedRegattaId = URLDecoder.decode(regattaId, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException();
            }
            Leaderboard leaderboardByName = eventService.getLeaderboardByName(decodedRegattaId);
            if (leaderboardByName != null) {
                securityService.checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboardByName);
                title = HomeSharingUtils.findTitle((Named)leaderboardByName);
                placeUrl = baseUrl.asRegattaPlaceLink(eventId, decodedRegattaId);
            } else {
                Regatta regattaByName = eventService.getRegattaByName(decodedRegattaId);
                if (regattaByName != null) {
                    securityService.checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regattaByName);
                    title = HomeSharingUtils.findTitle((Named)leaderboardByName);
                    placeUrl = baseUrl.asRegattaPlaceLink(eventId, decodedRegattaId);
                } else {
                    throw new IllegalArgumentException();
                }
            }
            Map<String, String> replacementMap = HomeSharingUtils.createReplacementMap(title, description, imageUrl, placeUrl, userAgent);
            String content = HomeSharingUtils.loadSharingHTML(((Object)((Object)this)).getClass().getClassLoader(), this.uriInfo);
            return HomeSharingUtils.replaceMetatags(content, replacementMap);
        }
        throw new IllegalArgumentException();
    }

    @GET
    @Path(value="/series/{seriesId}")
    @Produces(value={"text/html"})
    public String getSharedSeries(@PathParam(value="seriesId") String seriesId, @HeaderParam(value="user-agent") String userAgent) {
        RacingEventService eventService = this.getService();
        SecurityService securityService = this.getSecurityService();
        UUID leaderboardGroupId = UUID.fromString(seriesId);
        LeaderboardGroup leaderboardGroup = eventService.getLeaderboardGroupByID(leaderboardGroupId);
        if (leaderboardGroup != null) {
            securityService.checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboardGroup);
            String description = HomeSharingUtils.findDescription((WithDescription)leaderboardGroup);
            String imageUrl = HomeSharingUtils.findTeaserImageUrl(leaderboardGroup, eventService);
            String title = HomeSharingUtils.findTitle((Named)leaderboardGroup);
            String placeUrl = new TokenizedHomePlaceUrlBuilder(this.uriInfo).asSeriesPlaceLink(seriesId);
            Map<String, String> replacementMap = HomeSharingUtils.createReplacementMap(title, description, imageUrl, placeUrl, userAgent);
            String content = HomeSharingUtils.loadSharingHTML(((Object)((Object)this)).getClass().getClassLoader(), this.uriInfo);
            return HomeSharingUtils.replaceMetatags(content, replacementMap);
        }
        throw new IllegalArgumentException();
    }
}

