/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.jaxrs.api;

import com.sap.sailing.domain.abstractlog.AbstractLog;
import com.sap.sailing.domain.abstractlog.AbstractLogEvent;
import com.sap.sailing.domain.abstractlog.impl.AllEventsOfTypeFinder;
import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.LastPublishedCourseDesignFinder;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogCourseDesignChangedEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLog;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLogEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogDefineMarkEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogDefineMarkEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.impl.MarkFinder;
import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorWithBoat;
import com.sap.sailing.domain.base.CourseBase;
import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.impl.ControlPointWithTwoMarksImpl;
import com.sap.sailing.domain.base.impl.CourseDataImpl;
import com.sap.sailing.domain.base.impl.CourseImpl;
import com.sap.sailing.domain.base.impl.DynamicBoat;
import com.sap.sailing.domain.base.impl.DynamicCompetitor;
import com.sap.sailing.domain.common.CourseDesignerMode;
import com.sap.sailing.domain.common.MarkType;
import com.sap.sailing.domain.common.NotFoundException;
import com.sap.sailing.domain.common.PassingInstruction;
import com.sap.sailing.domain.common.racelog.tracking.CompetitorRegistrationOnRaceLogDisabledException;
import com.sap.sailing.domain.common.racelog.tracking.DoesNotHaveRegattaLogException;
import com.sap.sailing.domain.common.racelog.tracking.MarkAlreadyUsedInRaceException;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.impl.GPSFixImpl;
import com.sap.sailing.domain.coursetemplate.MarkProperties;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboard;
import com.sap.sailing.domain.racelogtracking.RaceLogTrackingAdapter;
import com.sap.sailing.domain.regattalike.HasRegattaLike;
import com.sap.sailing.server.gateway.deserialization.impl.Helpers;
import com.sap.sailing.server.gateway.dto.MarkContext;
import com.sap.sailing.server.gateway.serialization.coursedata.impl.ControlPointJsonSerializer;
import com.sap.sailing.server.gateway.serialization.coursedata.impl.CourseBaseJsonSerializer;
import com.sap.sailing.server.gateway.serialization.coursedata.impl.CourseJsonSerializer;
import com.sap.sailing.server.gateway.serialization.coursedata.impl.GateJsonSerializer;
import com.sap.sailing.server.gateway.serialization.coursedata.impl.MarkJsonSerializer;
import com.sap.sailing.server.gateway.serialization.coursedata.impl.WaypointJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.MarkContextJsonSerializer;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.shared.server.gateway.jaxrs.AbstractSailingServerResource;
import com.sap.sse.common.Color;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.impl.RGBColor;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonSerializer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.shiro.SecurityUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;

@Path(value="/v1/mark")
public class MarkResource
extends AbstractSailingServerResource {
    private static final String TIME_MILLIS = "timeMillis";
    private static final String LAT_DEG = "latDeg";
    private static final String LON_DEG = "lonDeg";
    private static final String FLEET_NAME = "fleetName";
    private static final String RACE_COLUMN_NAME = "raceColumnName";
    private static final String LEADERBOARD_NAME = "leaderboardName";
    private static final String MARK_ID = "markId";
    private static final String REGATTA_NAME = "regattaName";
    private static final String MARK_NAME = "markName";
    private static final String MARK_SHORT_NAME = "shortName";
    private static final String MARK_COLOR = "color";
    private static final String MARK_PATTERN = "pattern";
    private static final String MARK_SHAPE = "shape";
    private static final String MARK_TYPE = "type";
    private static final String CONTROL_POINT_NAME = "controlPointName";
    private static final String CONTROL_POINT_SHORT_NAME = "controlPointShortName";
    private static final String ORIGINATING_MARK_TEMPLATE_ID = "originatingMarkTemplateId";
    private static final String ORIGINATING_MARK_PROPERTIES_ID = "originatingMarkPropertiesId";
    private static final String ORIGINATING_COURSE_TEMPLATE_ID = "originatingCourseTemplateId";
    private static final Logger LOG = Logger.getLogger(MarkResource.class.getName());

    private Response getBadRaceErrorResponse(String regattaName, String raceColumn, String fleet) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a race with raceColumn '" + StringEscapeUtils.escapeHtml((String)raceColumn) + "' and fleet '" + StringEscapeUtils.escapeHtml((String)fleet) + "' in regatta '" + StringEscapeUtils.escapeHtml((String)regattaName) + "'.")).type("text/plain").build();
    }

    private Response getAlreadyTrackedRaceErrorResponse(String regattaName, String raceColumn, String fleet) {
        return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)("Race with raceColumn '" + StringEscapeUtils.escapeHtml((String)raceColumn) + "' and fleet '" + StringEscapeUtils.escapeHtml((String)fleet) + "' in regatta '" + StringEscapeUtils.escapeHtml((String)regattaName) + "' is already tracked.")).type("text/plain").build();
    }

    private Response getBadRegattaErrorResponse(String regattaName) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a regatta with name '" + StringEscapeUtils.escapeHtml((String)regattaName) + "'.")).type("text/plain").build();
    }

    private Response getBadMarkErrorResponse(String regattaName, String raceName, String markId) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a mark with id '" + StringEscapeUtils.escapeHtml((String)markId) + "' in regatta '" + StringEscapeUtils.escapeHtml((String)regattaName) + "' and race '" + StringEscapeUtils.escapeHtml((String)raceName) + "'.")).type("text/plain").build();
    }

    private Response getNoLogFoundErrorResponse(String regattaName) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("No log found for regatta '" + StringEscapeUtils.escapeHtml((String)regattaName) + "'.")).type("text/plain").build();
    }

    private Response getConflictingMarkErrorResponse(String markId, String raceNames) {
        return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)("Mark with id '" + StringEscapeUtils.escapeHtml((String)markId) + "' is already used in race " + StringEscapeUtils.escapeHtml((String)raceNames) + ".")).type("text/plain").build();
    }

    @POST
    @Path(value="/addMarkToRegatta")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Response addMarkToRegatta(String json) throws Exception {
        Response response;
        Object requestBody = JSONValue.parseWithException((String)json);
        JSONObject requestObject = Helpers.toJSONObjectSafe((Object)requestBody);
        String markName = (String)requestObject.get((Object)MARK_NAME);
        String markShortName = (String)requestObject.get((Object)MARK_SHORT_NAME);
        String originatingMarkTemplateIdAsString = (String)requestObject.get((Object)ORIGINATING_MARK_TEMPLATE_ID);
        String originatingMarkPropertiesIdAsString = (String)requestObject.get((Object)ORIGINATING_MARK_PROPERTIES_ID);
        String markColorStr = (String)requestObject.get((Object)MARK_COLOR);
        String markPattern = (String)requestObject.get((Object)MARK_PATTERN);
        String markShape = (String)requestObject.get((Object)MARK_SHAPE);
        String markTypeStr = (String)requestObject.get((Object)MARK_TYPE);
        MarkType markType = null;
        if (markTypeStr != null) {
            try {
                markType = MarkType.valueOf((String)markTypeStr);
            }
            catch (IllegalArgumentException | NullPointerException e) {
                LOG.warning("Invalid mark type '" + markTypeStr + "' received via REST endpoint was ignored.");
            }
        }
        RGBColor markColor = null;
        if (markColorStr != null && !markColorStr.isEmpty()) {
            try {
                markColor = new RGBColor(markColorStr);
            }
            catch (IllegalArgumentException e) {
                LOG.warning("Invalid color '" + markColorStr + "' received via REST endpoint was ignored.");
            }
        }
        UUID markId = UUID.randomUUID();
        UUID originatingMarkTemplateId = originatingMarkTemplateIdAsString != null ? UUID.fromString(originatingMarkTemplateIdAsString) : null;
        UUID originatingMarkPropertiesId = originatingMarkPropertiesIdAsString != null ? UUID.fromString(originatingMarkPropertiesIdAsString) : null;
        Mark mark = this.getService().getBaseDomainFactory().getOrCreateMark((Serializable)markId, markName, markShortName, markType, (Color)markColor, markShape, markPattern, originatingMarkTemplateId, originatingMarkPropertiesId);
        String regattaName = (String)requestObject.get((Object)REGATTA_NAME);
        Regatta regatta = this.getService().getRegattaByName(regattaName);
        if (regatta == null) {
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a regatta with name '" + StringEscapeUtils.escapeHtml((String)regattaName) + "'.")).type("text/plain").build();
        } else {
            this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)regatta);
            RegattaLog regattaLog = this.getRegattaLogInternal(regattaName);
            RegattaLogDefineMarkEventImpl event = new RegattaLogDefineMarkEventImpl(MillisecondsTimePoint.now(), this.getService().getServerAuthor(), MillisecondsTimePoint.now(), (Serializable)UUID.randomUUID(), mark);
            regattaLog.add((AbstractLogEvent)event);
            JSONObject answer = new JSONObject();
            answer.put((Object)MARK_ID, (Object)markId.toString());
            response = Response.ok((Object)this.streamingOutput(answer)).build();
        }
        return response;
    }

    @POST
    @Path(value="/revokeMarkOnRegatta")
    @Consumes(value={"application/json"})
    public Response revokeMarkOnRegatta(String json) throws ParseException, JsonDeserializationException, DoesNotHaveRegattaLogException {
        Object requestBody = JSONValue.parseWithException((String)json);
        JSONObject requestObject = Helpers.toJSONObjectSafe((Object)requestBody);
        String regattaName = (String)requestObject.get((Object)REGATTA_NAME);
        String raceColumnName = (String)requestObject.get((Object)RACE_COLUMN_NAME);
        String fleetName = (String)requestObject.get((Object)FLEET_NAME);
        String markId = (String)requestObject.get((Object)MARK_ID);
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            return this.getBadRegattaErrorResponse(regattaName);
        }
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
        RaceColumn raceColumn = this.findRaceColumnByName(regatta, raceColumnName);
        if (raceColumn == null) {
            return this.getBadRaceErrorResponse(regattaName, raceColumnName, fleetName);
        }
        Fleet fleet = this.findFleetByName(raceColumn, fleetName);
        if (fleet == null) {
            return this.getBadRaceErrorResponse(regattaName, raceColumnName, fleetName);
        }
        if (raceColumn.getTrackedRace(fleet) != null) {
            return this.getAlreadyTrackedRaceErrorResponse(regattaName, raceColumnName, fleetName);
        }
        RegattaLog regattaLog = this.getRegattaLogInternal(regattaName);
        List regattaLogDefineMarkEvents = (List)new AllEventsOfTypeFinder((AbstractLog)regattaLog, true, RegattaLogDefineMarkEvent.class).analyze();
        String markIdToRevoke = null;
        for (RegattaLogEvent event : regattaLogDefineMarkEvents) {
            RegattaLogDefineMarkEvent defineMarkEvent = (RegattaLogDefineMarkEvent)event;
            if (!defineMarkEvent.getMark().getId().toString().equals(markId)) continue;
            markIdToRevoke = markId;
            break;
        }
        if (markIdToRevoke == null) {
            return this.getBadMarkErrorResponse(regattaName, raceColumnName, markId);
        }
        try {
            this.getService().revokeMarkDefinitionEventInRegattaLog(regatta.getName(), raceColumnName, fleetName, markIdToRevoke);
        }
        catch (DoesNotHaveRegattaLogException e) {
            return this.getNoLogFoundErrorResponse(regattaName);
        }
        catch (MarkAlreadyUsedInRaceException e) {
            return this.getConflictingMarkErrorResponse(regattaName, e.getRaceNames());
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="/addMarkFix")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Response addMarkFix(String json) throws DoesNotHaveRegattaLogException, ParseException, JsonDeserializationException {
        Object requestBody = JSONValue.parseWithException((String)json);
        JSONObject requestObject = Helpers.toJSONObjectSafe((Object)requestBody);
        String leaderboardName = (String)requestObject.get((Object)LEADERBOARD_NAME);
        String raceColumnName = (String)requestObject.get((Object)RACE_COLUMN_NAME);
        String fleetName = (String)requestObject.get((Object)FLEET_NAME);
        String markId = (String)requestObject.get((Object)MARK_ID);
        String lonDeg = (String)requestObject.get((Object)LON_DEG);
        String latDeg = (String)requestObject.get((Object)LAT_DEG);
        String timeMillis = (String)requestObject.get((Object)TIME_MILLIS);
        RaceLogTrackingAdapter raceLogTrackingAdapter = this.getRaceLogTrackingAdapter();
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        if (leaderboard != null) {
            SecurityUtils.getSubject().checkPermission(leaderboard.getIdentifier().getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE));
            if (leaderboard instanceof RegattaLeaderboard) {
                Regatta regatta = ((RegattaLeaderboard)leaderboard).getRegatta();
                SecurityUtils.getSubject().checkPermission(regatta.getIdentifier().getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE));
            }
            this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)leaderboard);
            RaceColumn raceColumn = leaderboard.getRaceColumnByName(raceColumnName);
            if (raceColumn != null) {
                RegattaLog regattaLog = raceColumn.getRegattaLog();
                Fleet fleet = raceColumn.getFleetByName(fleetName);
                if (fleet != null) {
                    for (Mark mark : raceColumn.getAvailableMarks(fleet)) {
                        if (!mark.getId().toString().equals(markId)) continue;
                        GPSFixImpl gpsFix = GPSFixImpl.create((double)Double.parseDouble(lonDeg), (double)Double.parseDouble(latDeg), (long)Long.parseLong(timeMillis));
                        raceLogTrackingAdapter.pingMark(regattaLog, mark, (GPSFix)gpsFix, this.getService());
                        return Response.ok().header("Content-Type", (Object)"application/json;charset=UTF-8").build();
                    }
                }
            }
        }
        return Response.notModified().header("Content-Type", (Object)"application/json;charset=UTF-8").build();
    }

    @POST
    @Path(value="/addCourseDefinitionToRaceLog")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Response addCourseDefinitionToRaceLog(String json) throws DoesNotHaveRegattaLogException, NotFoundException, ParseException, JsonDeserializationException {
        CourseBase lastPublishedCourse;
        Object requestBody = JSONValue.parseWithException((String)json);
        JSONObject requestObject = Helpers.toJSONObjectSafe((Object)requestBody);
        String leaderboardName = (String)requestObject.get((Object)LEADERBOARD_NAME);
        String originatingCourseTemplateIdAsString = (String)requestObject.get((Object)ORIGINATING_COURSE_TEMPLATE_ID);
        UUID originatingCourseTemplateId = originatingCourseTemplateIdAsString != null ? UUID.fromString(originatingCourseTemplateIdAsString) : null;
        SecurityUtils.getSubject().checkPermission(SecuredDomainType.LEADERBOARD.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, Leaderboard.getTypeRelativeObjectIdentifier((String)leaderboardName)));
        String raceColumnName = (String)requestObject.get((Object)RACE_COLUMN_NAME);
        String fleetName = (String)requestObject.get((Object)FLEET_NAME);
        RaceLog raceLog = this.getRaceLog(leaderboardName, raceColumnName, fleetName);
        String courseName = "Course of " + raceColumnName;
        if (!"Default".equals(fleetName)) {
            courseName = String.valueOf(courseName) + " - " + fleetName;
        }
        if ((lastPublishedCourse = (CourseBase)new LastPublishedCourseDesignFinder(raceLog, false).analyze()) == null) {
            lastPublishedCourse = new CourseDataImpl(courseName);
        }
        JSONArray controlPointsRaw = (JSONArray)requestObject.get((Object)"controlPoints");
        ArrayList<Util.Pair> controlPoints = new ArrayList<Util.Pair>();
        for (Object controlPointUnsafe : controlPointsRaw) {
            String shortName;
            JSONObject controlPointRaw = Helpers.toJSONObjectSafe(controlPointUnsafe);
            String passingInstructionString = (String)controlPointRaw.get((Object)"passingInstruction");
            PassingInstruction passing = PassingInstruction.valueOfIgnoringCase((String)passingInstructionString);
            JSONArray marksRaw = (JSONArray)controlPointRaw.get((Object)"marks");
            if (marksRaw.size() == 1) {
                String markName = (String)marksRaw.get(0);
                Mark mark = this.getService().getBaseDomainFactory().getExistingMarkByIdAsString(markName);
                if (mark == null) {
                    throw new IllegalStateException("Could not resolve mark " + markName);
                }
                controlPoints.add(new Util.Pair((Object)mark, (Object)passing));
                continue;
            }
            String markNameA = (String)marksRaw.get(0);
            String markNameB = (String)marksRaw.get(1);
            Mark markA = this.getService().getBaseDomainFactory().getExistingMarkByIdAsString(markNameA);
            Mark markB = this.getService().getBaseDomainFactory().getExistingMarkByIdAsString(markNameB);
            if (markA == null) {
                throw new IllegalStateException("Could not resolve mark " + markA);
            }
            if (markB == null) {
                throw new IllegalStateException("Could not resolve mark " + markB);
            }
            String controlPointName = (String)controlPointRaw.get((Object)CONTROL_POINT_NAME);
            if (controlPointName == null || controlPointName.isEmpty()) {
                controlPointName = String.valueOf(markA.getName()) + "-" + markB.getName();
            }
            controlPoints.add(new Util.Pair((Object)new ControlPointWithTwoMarksImpl(markA, markB, controlPointName, (shortName = (String)controlPointRaw.get((Object)CONTROL_POINT_SHORT_NAME)) == null ? controlPointName : shortName), (Object)passing));
        }
        CourseImpl course = new CourseImpl(courseName, lastPublishedCourse.getWaypoints(), originatingCourseTemplateId);
        try {
            course.update(controlPoints, lastPublishedCourse.getAssociatedRoles(), lastPublishedCourse.getOriginatingCourseTemplateIdOrNull(), this.getService().getBaseDomainFactory());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        RaceLogCourseDesignChangedEventImpl event = new RaceLogCourseDesignChangedEventImpl(MillisecondsTimePoint.now(), this.getService().getServerAuthor(), raceLog.getCurrentPassId(), (CourseBase)course, CourseDesignerMode.ADMIN_CONSOLE);
        raceLog.add((AbstractLogEvent)event);
        CourseBase updatedPublishedCourse = (CourseBase)new LastPublishedCourseDesignFinder(raceLog, false).analyze();
        JSONObject jsonResult = new JSONObject();
        jsonResult.put((Object)"course", (Object)new CourseJsonSerializer((JsonSerializer)new CourseBaseJsonSerializer((JsonSerializer)new WaypointJsonSerializer((JsonSerializer)new ControlPointJsonSerializer((JsonSerializer)new MarkJsonSerializer(), (JsonSerializer)new GateJsonSerializer((JsonSerializer)new MarkJsonSerializer()))))).serialize(updatedPublishedCourse));
        return Response.ok((Object)this.streamingOutput(jsonResult)).build();
    }

    @POST
    @Path(value="/addCompetitorToRace")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Response addCompetitorToRace(String json) throws DoesNotHaveRegattaLogException, NotFoundException, ParseException, JsonDeserializationException, CompetitorRegistrationOnRaceLogDisabledException {
        Response response;
        Object requestBody = JSONValue.parseWithException((String)json);
        JSONObject requestObject = Helpers.toJSONObjectSafe((Object)requestBody);
        String leaderboardName = (String)requestObject.get((Object)LEADERBOARD_NAME);
        Leaderboard leaderBoard = this.getService().getLeaderboardByName(leaderboardName);
        if (leaderBoard == null) {
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a leaderboard with name '" + StringEscapeUtils.escapeHtml((String)leaderboardName) + "'.")).type("text/plain").build();
        } else {
            SecurityUtils.getSubject().checkPermission(SecuredDomainType.LEADERBOARD.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, Leaderboard.getTypeRelativeObjectIdentifier((String)leaderboardName)));
            String raceColumnName = (String)requestObject.get((Object)RACE_COLUMN_NAME);
            String fleetName = (String)requestObject.get((Object)FLEET_NAME);
            JSONArray competitorsRaw = (JSONArray)requestObject.get((Object)"competitors");
            HashMap<Competitor, Boat> competitorsToRegister = new HashMap<Competitor, Boat>();
            int i = 0;
            while (i < competitorsRaw.size()) {
                JSONObject competitorRaw = (JSONObject)competitorsRaw.get(i);
                String competitorId = (String)competitorRaw.get((Object)"competitorId");
                String string = (String)competitorRaw.get((Object)"boatId");
                DynamicCompetitor competitor = this.getService().getCompetitorAndBoatStore().getExistingCompetitorByIdAsString(competitorId);
                DynamicBoat boat = this.getService().getCompetitorAndBoatStore().getExistingBoatByIdAsString(string);
                competitorsToRegister.put((Competitor)competitor, (Boat)boat);
                ++i;
            }
            RaceColumn raceColumn = this.getRaceColumn(leaderboardName, raceColumnName);
            Fleet fleet = this.getFleetByName(raceColumn, fleetName);
            HashMap<Competitor, Boat> competitorsRegisteredInRaceLog = new HashMap<Competitor, Boat>();
            for (Map.Entry entry : raceColumn.getCompetitorsRegisteredInRacelog(fleet).entrySet()) {
                competitorsRegisteredInRaceLog.put((Competitor)((CompetitorWithBoat)entry.getKey()), (Boat)entry.getValue());
            }
            Iterable<Competitor> iterable = this.filterCompetitorDuplicates(competitorsToRegister, competitorsRegisteredInRaceLog);
            raceColumn.deregisterCompetitors(iterable, fleet);
            for (Map.Entry competitorToRegister : competitorsToRegister.entrySet()) {
                raceColumn.registerCompetitor((Competitor)competitorToRegister.getKey(), (Boat)competitorToRegister.getValue(), fleet);
            }
            response = Response.ok().header("Content-Type", (Object)"application/json;charset=UTF-8").build();
        }
        return response;
    }

    private Iterable<Competitor> filterCompetitorDuplicates(Map<Competitor, Boat> competitorToBoatMappingsToRegister, Map<Competitor, Boat> competitorToBoatMappingsRegistered) {
        HashSet<Competitor> competitorsToUnregister = new HashSet<Competitor>();
        Util.addAll(competitorToBoatMappingsRegistered.keySet(), competitorsToUnregister);
        for (Map.Entry<Competitor, Boat> e : competitorToBoatMappingsRegistered.entrySet()) {
            Competitor competitor = e.getKey();
            if (competitorToBoatMappingsToRegister.get(competitor) != e.getValue()) continue;
            competitorToBoatMappingsToRegister.remove(competitor);
            competitorsToUnregister.remove(competitor);
        }
        return competitorsToUnregister;
    }

    private RaceLog getRaceLog(String leaderboardName, String raceColumnName, String fleetName) throws NotFoundException {
        RaceColumn raceColumn = this.getRaceColumn(leaderboardName, raceColumnName);
        Fleet fleet = this.getFleetByName(raceColumn, fleetName);
        return raceColumn.getRaceLog(fleet);
    }

    private Fleet getFleetByName(RaceColumn raceColumn, String fleetName) throws NotFoundException {
        Fleet fleet = raceColumn.getFleetByName(fleetName);
        if (fleet == null) {
            throw new NotFoundException("fleet with name " + fleetName + " not found");
        }
        return fleet;
    }

    private RaceColumn getRaceColumn(String leaderboardName, String raceColumnName) throws NotFoundException {
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        if (leaderboard == null) {
            throw new NotFoundException("leaderboard with name " + leaderboardName + " not found");
        }
        RaceColumn raceColumn = leaderboard.getRaceColumnByName(raceColumnName);
        if (raceColumn == null) {
            throw new NotFoundException("raceColumn with name " + raceColumnName + " not found");
        }
        return raceColumn;
    }

    private RegattaLog getRegattaLogInternal(String leaderboardName) throws DoesNotHaveRegattaLogException {
        Leaderboard l = this.getService().getLeaderboardByName(leaderboardName);
        if (!(l instanceof HasRegattaLike)) {
            throw new DoesNotHaveRegattaLogException();
        }
        return ((HasRegattaLike)l).getRegattaLike().getRegattaLog();
    }

    @GET
    @Path(value="/searchMarksByMarkPropertiesObject/{markPropertiesId}")
    @Produces(value={"application/json;charset=UTF-8"})
    public Response searchMarksByMarkPropertiesObject(@PathParam(value="markPropertiesId") UUID markPropertiesId, @QueryParam(value="onlyCurrentlyActive") boolean onlyCurrentlyActive, @QueryParam(value="eventIds") Set<UUID> eventIds, @QueryParam(value="regattaNames") Set<String> regattaNames) {
        MarkProperties markPropertiesObject = this.getSharedSailingData().getMarkPropertiesById(markPropertiesId);
        if (markPropertiesObject == null) {
            throw new IllegalArgumentException("No MarkPropertiesObject with Id: " + markPropertiesId);
        }
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)markPropertiesObject);
        HashSet<MarkContext> regattaMarkContexts = new HashSet<MarkContext>();
        Set<Util.Pair<Regatta, Leaderboard>> regattasWithLeaderBoards = this.getFilteredRegattasWithPermission(regattaNames, onlyCurrentlyActive);
        Iterable<Event> events = this.getFilteredEventsWithPermission(eventIds, onlyCurrentlyActive);
        for (Util.Pair<Regatta, Leaderboard> regattaWithLeaderboard : regattasWithLeaderBoards) {
            Regatta regatta = (Regatta)regattaWithLeaderboard.getA();
            Leaderboard leaderboard = (Leaderboard)regattaWithLeaderboard.getB();
            MarkFinder markFinder = new MarkFinder(((Regatta)regattaWithLeaderboard.getA()).getRegattaLog());
            Set marksOfRegatta = (Set)markFinder.analyze();
            for (Mark mark : marksOfRegatta) {
                UUID originatingMarkPropertiesIdOrNull = mark.getOriginatingMarkPropertiesIdOrNull();
                if (originatingMarkPropertiesIdOrNull == null || !originatingMarkPropertiesIdOrNull.equals(markPropertiesObject.getId())) continue;
                Set regattaContextEvents = this.getService().findEventsContainingLeaderboardAndMatchingAtLeastOneCourseArea(leaderboard, events);
                if (!Util.isEmpty(eventIds) && Util.isEmpty((Iterable)regattaContextEvents)) continue;
                regattaMarkContexts.add(new MarkContext(mark, regatta, regattaContextEvents));
            }
        }
        JSONArray jsonContexts = new JSONArray();
        MarkContextJsonSerializer markContextJsonSerializer = new MarkContextJsonSerializer();
        for (MarkContext markContext : regattaMarkContexts) {
            jsonContexts.add((Object)markContextJsonSerializer.serialize(markContext));
        }
        Response response = Response.ok((Object)this.streamingOutput(jsonContexts)).build();
        return response;
    }

    private Iterable<Event> getFilteredEventsWithPermission(Iterable<UUID> eventIds, boolean onlyIncludeCurrentlyActiveEvents) {
        RacingEventService eventService = this.getService();
        Iterable eventsSelectively = eventIds == null | Util.isEmpty(eventIds) ? eventService.getAllEvents() : eventService.getEventsSelectively(true, eventIds);
        SecurityService securityService = this.getSecurityService();
        HashSet<Event> eventsWithPermission = new HashSet<Event>();
        for (Event event : eventsSelectively) {
            boolean eventIsCurrent;
            boolean hasCurrentUserReadPermission = securityService.hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)event);
            TimePoint endDate = event.getEndDate();
            boolean bl = eventIsCurrent = endDate == null || !endDate.before(TimePoint.now());
            if (!hasCurrentUserReadPermission || onlyIncludeCurrentlyActiveEvents && !eventIsCurrent) continue;
            eventsWithPermission.add(event);
        }
        return eventsWithPermission;
    }

    private Set<Util.Pair<Regatta, Leaderboard>> getFilteredRegattasWithPermission(Set<String> regattaIds, boolean onlyIncludeCurrentlyActiveRegattas) {
        SecurityService securityService = this.getSecurityService();
        Collection allLeaderboards = this.getService().getLeaderboards().values();
        Set regattaLeaderboards = allLeaderboards.stream().filter(lb -> lb instanceof RegattaLeaderboard).map(lb -> (RegattaLeaderboard)lb).collect(Collectors.toSet());
        HashSet<Util.Pair<Regatta, Leaderboard>> filteredRegattasWithLeaderboards = new HashSet<Util.Pair<Regatta, Leaderboard>>();
        for (RegattaLeaderboard leaderboard : regattaLeaderboards) {
            boolean regattaIsCurrent;
            Regatta regatta = leaderboard.getRegatta();
            boolean regattaIsInIds = regattaIds.isEmpty() || regattaIds.contains(regatta.getName());
            boolean hasCurrentUserReadPermission = securityService.hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
            TimePoint endDate = regatta.getEndDate();
            boolean bl = regattaIsCurrent = endDate == null || !regatta.getEndDate().before(TimePoint.now());
            if (!regattaIsInIds || !hasCurrentUserReadPermission || onlyIncludeCurrentlyActiveRegattas && !regattaIsCurrent) continue;
            filteredRegattasWithLeaderboards.add((Util.Pair<Regatta, Leaderboard>)new Util.Pair((Object)regatta, (Object)leaderboard));
        }
        return filteredRegattasWithLeaderboards;
    }
}

