/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.jaxrs.api;

import com.sap.sailing.domain.abstractlog.AbstractLogEvent;
import com.sap.sailing.domain.abstractlog.AbstractLogEventAuthor;
import com.sap.sailing.domain.abstractlog.impl.LogEventAuthorImpl;
import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogCourseDesignChangedEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogEndOfTrackingEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogStartOfTrackingEventImpl;
import com.sap.sailing.domain.abstractlog.race.tracking.impl.RaceLogUseCompetitorsFromRaceLogEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLog;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogCloseOpenEndedDeviceMappingEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogDefineMarkEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogDeviceBoatMappingEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogDeviceCompetitorMappingEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogDeviceMarkMappingEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.impl.OpenEndedDeviceMappingFinder;
import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.ControlPoint;
import com.sap.sailing.domain.base.ControlPointWithTwoMarks;
import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.base.CourseArea;
import com.sap.sailing.domain.base.CourseBase;
import com.sap.sailing.domain.base.DomainFactory;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.base.impl.AbstractRaceColumn;
import com.sap.sailing.domain.base.impl.CourseImpl;
import com.sap.sailing.domain.base.impl.DynamicBoat;
import com.sap.sailing.domain.base.impl.DynamicCompetitor;
import com.sap.sailing.domain.common.CourseDesignerMode;
import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.common.NotFoundException;
import com.sap.sailing.domain.common.PassingInstruction;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.RegattaScoreCorrections;
import com.sap.sailing.domain.common.ScoreCorrectionProvider;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.FleetDTO;
import com.sap.sailing.domain.common.dto.LeaderboardDTO;
import com.sap.sailing.domain.common.dto.LeaderboardEntryDTO;
import com.sap.sailing.domain.common.dto.LeaderboardRowDTO;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import com.sap.sailing.domain.common.impl.MeterDistance;
import com.sap.sailing.domain.common.racelog.RacingProcedureType;
import com.sap.sailing.domain.common.racelog.tracking.NotDenotableForRaceLogTrackingException;
import com.sap.sailing.domain.common.racelog.tracking.NotDenotedForRaceLogTrackingException;
import com.sap.sailing.domain.common.scalablevalue.impl.ScalableBearing;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.domain.common.sharding.ShardingType;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.common.tracking.impl.GPSFixImpl;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboard;
import com.sap.sailing.domain.leaderboard.ScoreCorrectionMapping;
import com.sap.sailing.domain.racelogtracking.RaceLogTrackingAdapter;
import com.sap.sailing.domain.racelogtracking.impl.SmartphoneUUIDIdentifierImpl;
import com.sap.sailing.domain.regattalike.HasRegattaLike;
import com.sap.sailing.domain.regattalike.IsRegattaLike;
import com.sap.sailing.domain.regattalike.LeaderboardThatHasRegattaLike;
import com.sap.sailing.domain.sharding.ShardingContext;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.RaceHandle;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.TrackedRegattaRegistry;
import com.sap.sailing.server.gateway.deserialization.impl.FlatGPSFixJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.Helpers;
import com.sap.sailing.server.gateway.jaxrs.api.AbstractLeaderboardsResource;
import com.sap.sailing.server.gateway.serialization.coursedata.impl.ControlPointJsonSerializer;
import com.sap.sailing.server.gateway.serialization.coursedata.impl.CourseBaseJsonSerializer;
import com.sap.sailing.server.gateway.serialization.coursedata.impl.CourseJsonSerializer;
import com.sap.sailing.server.gateway.serialization.coursedata.impl.GateJsonSerializer;
import com.sap.sailing.server.gateway.serialization.coursedata.impl.MarkJsonSerializer;
import com.sap.sailing.server.gateway.serialization.coursedata.impl.WaypointJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.CPUMeterJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.CompetitorAndBoatJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.CompetitorJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.FlatGPSFixJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.MarkJsonSerializerWithPosition;
import com.sap.sailing.server.hierarchy.SailingHierarchyOwnershipUpdater;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.operationaltransformation.RemoveAndUntrackRace;
import com.sap.sailing.server.operationaltransformation.StopTrackingRace;
import com.sap.sailing.server.operationaltransformation.UpdateCompetitorDisplayNameInLeaderboard;
import com.sap.sailing.server.operationaltransformation.UpdateLeaderboard;
import com.sap.sailing.server.operationaltransformation.UpdateLeaderboardMaxPointsReason;
import com.sap.sailing.server.operationaltransformation.UpdateLeaderboardScoreCorrection;
import com.sap.sailing.server.operationaltransformation.UpdateLeaderboardScoreCorrectionMetadata;
import com.sap.sse.InvalidDateException;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.WithID;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.scalablevalue.ScalableValue;
import com.sap.sse.replication.OperationWithResult;
import com.sap.sse.security.SessionUtils;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.OwnershipAnnotation;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.security.shared.impl.Ownership;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import com.sap.sse.security.shared.impl.UserGroup;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonSerializer;
import com.sap.sse.shared.util.impl.UUIDHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.ws.http.HTTPException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.shiro.SecurityUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;

@Path(value="/v1/leaderboards")
public class LeaderboardsResource
extends AbstractLeaderboardsResource {
    private static final Logger logger = Logger.getLogger(LeaderboardsResource.class.getName());
    public static final String V1_LEADERBOARDS = "/v1/leaderboards";
    private static final Duration TIME_OFFSET_FOR_HEAD_AND_TAIL_OF_TRACK_FOR_LINE_INFERENCE = Duration.ONE_MINUTE;
    private static final Distance LINE_MARGIN = new MeterDistance(20.0);
    private final MarkJsonSerializer markSerializer = new MarkJsonSerializer();
    private final MarkJsonSerializerWithPosition markWithPositionSerializer = new MarkJsonSerializerWithPosition(this.markSerializer, new FlatGPSFixJsonSerializer());
    private final FlatGPSFixJsonDeserializer fixDeserializer = new FlatGPSFixJsonDeserializer();

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    public Response getLeaderboards() {
        JSONArray jsonLeaderboards = new JSONArray();
        Map leaderboards = this.getService().getLeaderboards();
        for (Map.Entry leaderboardName : leaderboards.entrySet()) {
            if (!this.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboardName.getValue())) continue;
            jsonLeaderboards.add(leaderboardName.getKey());
        }
        return Response.ok((Object)this.streamingOutput(jsonLeaderboards)).build();
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{name}")
    public Response getLeaderboard(@PathParam(value="name") String leaderboardName, @DefaultValue(value="Live") @QueryParam(value="resultState") AbstractLeaderboardsResource.ResultStates resultState, @QueryParam(value="maxCompetitorsCount") Integer maxCompetitorsCount, @QueryParam(value="secret") String regattaSecret, @DefaultValue(value="false") @QueryParam(value="competitorAndBoatIdsOnly") boolean competitorAndBoatIdsOnly) {
        ShardingContext.setShardingConstraint((ShardingType)ShardingType.LEADERBOARDNAME, (String)leaderboardName);
        try {
            Response response;
            TimePoint requestTimePoint = MillisecondsTimePoint.now();
            Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
            if (leaderboard == null) {
                response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a leaderboard with name '" + StringEscapeUtils.escapeHtml((String)leaderboardName) + "'.")).type("text/plain").build();
            } else {
                boolean skip = this.getService().skipChecksDueToCorrectSecret(leaderboardName, regattaSecret);
                if (!skip) {
                    this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard);
                }
                try {
                    TimePoint timePoint = this.calculateTimePointForResultState(leaderboard, resultState);
                    JSONObject jsonLeaderboard = this.getLeaderboardJson(resultState, maxCompetitorsCount, requestTimePoint, leaderboard, timePoint, null, null, competitorAndBoatIdsOnly, null, skip, false);
                    response = Response.ok((Object)this.streamingOutput(jsonLeaderboard)).build();
                }
                catch (NoWindException | InterruptedException | ExecutionException e) {
                    response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).type("text/plain").build();
                }
            }
            Response response2 = response;
            return response2;
        }
        finally {
            ShardingContext.clearShardingConstraint((ShardingType)ShardingType.LEADERBOARDNAME);
        }
    }

    @Override
    protected JSONObject getLeaderboardJson(Leaderboard leaderboard, TimePoint resultTimePoint, AbstractLeaderboardsResource.ResultStates resultState, Integer maxCompetitorsCount, List<String> raceColumnNames, List<String> raceDetailNames, boolean competitorIdsOnly, List<String> showOnlyActiveRacesForCompetitorIds, boolean userPresentedValidRegattaSecret, boolean showOnlyCompetitorsWithIdsProvided) throws NoWindException, InterruptedException, ExecutionException {
        LeaderboardDTO leaderboardDTO = leaderboard.getLeaderboardDTO(resultTimePoint, Collections.emptyList(), false, (TrackedRegattaRegistry)this.getService(), this.getService().getBaseDomainFactory(), false);
        JSONObject jsonLeaderboard = new JSONObject();
        this.writeCommonLeaderboardData(jsonLeaderboard, leaderboard, resultState, leaderboardDTO.getTimePoint(), maxCompetitorsCount);
        JSONArray jsonCompetitorEntries = new JSONArray();
        jsonLeaderboard.put((Object)"competitors", (Object)jsonCompetitorEntries);
        int counter = 1;
        for (CompetitorDTO competitor2 : Util.filter((Iterable)leaderboardDTO.competitors, competitor -> userPresentedValidRegattaSecret || SecurityUtils.getSubject().isPermitted(competitor.getIdentifier().getStringPermission((HasPermissions.Action)SecuredSecurityTypes.PublicReadableActions.READ_PUBLIC)) || SecurityUtils.getSubject().isPermitted(competitor.getIdentifier().getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.READ)))) {
            LeaderboardRowDTO leaderboardRowDTO = (LeaderboardRowDTO)leaderboardDTO.rows.get(competitor2);
            if (maxCompetitorsCount != null && counter > maxCompetitorsCount) break;
            JSONObject jsonCompetitor = new JSONObject();
            this.writeCompetitorBaseData(jsonCompetitor, competitor2, leaderboardDTO, competitorIdsOnly);
            jsonCompetitor.put((Object)"rank", (Object)counter);
            jsonCompetitor.put((Object)"carriedPoints", (Object)leaderboardRowDTO.carriedPoints);
            jsonCompetitor.put((Object)"netPoints", (Object)leaderboardRowDTO.netPoints);
            jsonCompetitorEntries.add((Object)jsonCompetitor);
            JSONObject jsonRaceColumns = new JSONObject();
            jsonCompetitor.put((Object)"raceScores", (Object)jsonRaceColumns);
            for (RaceColumnDTO raceColumn : leaderboardDTO.getRaceList()) {
                List regattaRankedCompetitorsForColumn = (List)leaderboardDTO.getCompetitorOrderingPerRaceColumnName().get(raceColumn.getName());
                JSONObject jsonEntry = new JSONObject();
                jsonRaceColumns.put((Object)raceColumn.getName(), (Object)jsonEntry);
                LeaderboardEntryDTO leaderboardEntry = (LeaderboardEntryDTO)leaderboardRowDTO.fieldsByRaceColumnName.get(raceColumn.getName());
                FleetDTO fleetOfCompetitor = leaderboardEntry.fleet;
                jsonEntry.put((Object)"fleet", (Object)(fleetOfCompetitor == null ? "" : fleetOfCompetitor.getName()));
                jsonEntry.put((Object)"totalPoints", (Object)leaderboardEntry.totalPoints);
                jsonEntry.put((Object)"uncorrectedTotalPoints", (Object)leaderboardEntry.totalPoints);
                jsonEntry.put((Object)"netPoints", (Object)leaderboardEntry.netPoints);
                MaxPointsReason maxPointsReason = leaderboardEntry.reasonForMaxPoints;
                jsonEntry.put((Object)"maxPointsReason", (Object)(maxPointsReason != null ? maxPointsReason.toString() : null));
                jsonEntry.put((Object)"rank", (Object)(regattaRankedCompetitorsForColumn.indexOf(competitor2) + 1));
                List raceRankedCompetitorsInColumn = leaderboardDTO.getCompetitorsFromBestToWorst(raceColumn);
                jsonEntry.put((Object)"raceRank", (Object)(raceRankedCompetitorsInColumn.indexOf(competitor2) + 1));
                jsonEntry.put((Object)"isDiscarded", (Object)leaderboardEntry.discarded);
                jsonEntry.put((Object)"isCorrected", (Object)leaderboardEntry.hasScoreCorrection());
            }
            ++counter;
        }
        return jsonLeaderboard;
    }

    @POST
    @Path(value="{name}/update")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Response updateLeaderboard(@PathParam(value="name") String leaderboardName, String json) throws ParseException, JsonDeserializationException {
        int[] resultDiscardingThresholds;
        String newLeaderboardDisplayName;
        Object requestBody = JSONValue.parseWithException((String)json);
        JSONObject requestObject = Helpers.toJSONObjectSafe((Object)requestBody);
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        if (leaderboard != null) {
            JSONArray resultDiscardingThresholdsRaw;
            SecurityUtils.getSubject().checkPermission(SecuredDomainType.LEADERBOARD.getStringPermissionForObject((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, (WithQualifiedObjectIdentifier)leaderboard));
            newLeaderboardDisplayName = leaderboard.getDisplayName();
            if (requestObject.containsKey((Object)"leaderboardDisplayName")) {
                newLeaderboardDisplayName = (String)requestObject.get((Object)"leaderboardDisplayName");
            }
            resultDiscardingThresholds = null;
            if (requestObject.containsKey((Object)"resultDiscardingThresholds") && (resultDiscardingThresholdsRaw = (JSONArray)requestObject.get((Object)"resultDiscardingThresholds")) != null) {
                resultDiscardingThresholds = new int[resultDiscardingThresholdsRaw.size()];
                int i = 0;
                while (i < resultDiscardingThresholdsRaw.size()) {
                    resultDiscardingThresholds[i] = ((Long)resultDiscardingThresholdsRaw.get(i)).intValue();
                    ++i;
                }
            }
        } else {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a leaderboard with name '" + StringEscapeUtils.escapeHtml((String)leaderboardName) + "'.")).type("text/plain").build();
        }
        this.getService().apply((OperationWithResult)new UpdateLeaderboard(leaderboard.getName(), newLeaderboardDisplayName, resultDiscardingThresholds, Util.map((Iterable)leaderboard.getCourseAreas(), CourseArea::getId)));
        return Response.ok().header("Content-Type", (Object)"application/json;charset=UTF-8").build();
    }

    @POST
    @Path(value="{name}/updateCompetitorDisplayName")
    public Response updateCompetitorDisplayName(@PathParam(value="name") String leaderboardName, @QueryParam(value="competitorId") String competitorIdAsString, @QueryParam(value="displayName") String competitorDisplayName) {
        Response response;
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        if (!this.isValidLeaderboard(leaderboard)) {
            logger.warning("Leaderboard does not exist or does not hold a RegattaLog");
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Leaderboard does not exist or does not hold a RegattaLog").type("text/plain").build();
        }
        if (this.getSecurityService().hasCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)leaderboard)) {
            Competitor competitor;
            if (competitorIdAsString == null || (competitor = leaderboard.getCompetitorByIdAsString(competitorIdAsString)) == null) {
                logger.warning("No competitor found for id " + competitorIdAsString);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("No competitor found for id " + StringEscapeUtils.escapeHtml((String)competitorIdAsString))).type("text/plain").build();
            }
            this.getService().apply((OperationWithResult)new UpdateCompetitorDisplayNameInLeaderboard(leaderboardName, competitorIdAsString, competitorDisplayName));
            logger.fine("Successfully set display name for competitor with ID " + competitorIdAsString + " named " + competitor.getName() + " in leaderboard " + leaderboardName + " to " + competitorDisplayName);
            response = Response.status((Response.Status)Response.Status.OK).build();
        } else {
            response = Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        return response;
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="{name}/device_mappings/start")
    public Response postCheckin(String checkinJson, @PathParam(value="name") String leaderboardName) {
        Response response;
        JSONObject requestObject;
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        if (!this.isValidLeaderboard(leaderboard)) {
            logger.warning("Leaderboard does not exist or does not hold a RegattaLog");
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Leaderboard does not exist or does not hold a RegattaLog").type("text/plain").build();
        }
        try {
            logger.fine("Post issued to " + ((Object)((Object)this)).getClass().getName());
            Object requestBody = JSONValue.parseWithException((String)checkinJson);
            requestObject = Helpers.toJSONObjectSafe((Object)requestBody);
            logger.fine("JSON requestObject is: " + requestObject.toString());
        }
        catch (JsonDeserializationException | ParseException e) {
            logger.log(Level.WARNING, "Exception while parsing post request", e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid JSON body in request").type("text/plain").build();
        }
        TimePoint now = MillisecondsTimePoint.now();
        String competitorId = (String)requestObject.get((Object)"competitorId");
        String boatId = (String)requestObject.get((Object)"boatId");
        String markId = (String)requestObject.get((Object)"markId");
        String deviceUuid = (String)requestObject.get((Object)"deviceUuid");
        String regattaSecret = (String)requestObject.get((Object)"secret");
        Long fromMillis = (Long)requestObject.get((Object)"fromMillis");
        boolean allowedViaPermission = this.getSecurityService().hasCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)leaderboard);
        boolean allowedViaSecret = this.getService().skipChecksDueToCorrectSecret(leaderboardName, regattaSecret);
        HasRegattaLike hasRegattaLike = (HasRegattaLike)leaderboard;
        DomainFactory domainFactory = this.getService().getDomainObjectFactory().getBaseDomainFactory();
        LogEventAuthorImpl author = new LogEventAuthorImpl("Compatibility", 16);
        if (allowedViaPermission || allowedViaSecret) {
            RegattaLogDeviceMarkMappingEventImpl event;
            DynamicCompetitor mappedTo;
            if (competitorId == null && boatId == null && markId == null || deviceUuid == null || fromMillis == null) {
                logger.warning("Invalid JSON body in request");
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid JSON body in request").type("text/plain").build();
            }
            SmartphoneUUIDIdentifierImpl device = new SmartphoneUUIDIdentifierImpl(UUID.fromString(deviceUuid));
            MillisecondsTimePoint from = new MillisecondsTimePoint(fromMillis.longValue());
            if (competitorId != null) {
                DynamicCompetitor mappedToCompetitor;
                mappedTo = mappedToCompetitor = domainFactory.getCompetitorAndBoatStore().getExistingCompetitorByIdAsString(competitorId);
                if (mappedToCompetitor == null) {
                    logger.warning("No competitor found for id " + competitorId);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("No competitor found for id " + StringEscapeUtils.escapeHtml((String)competitorId))).type("text/plain").build();
                }
                Set registered = (Set)hasRegattaLike.getAllCompetitors();
                if (!registered.contains(mappedToCompetitor)) {
                    logger.warning("Competitor found but not registered on a race of " + leaderboardName);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Competitor found but not registered on a race of " + StringEscapeUtils.escapeHtml((String)leaderboardName))).type("text/plain").build();
                }
                event = new RegattaLogDeviceCompetitorMappingEventImpl(now, now, (AbstractLogEventAuthor)author, (Serializable)UUID.randomUUID(), (Competitor)mappedToCompetitor, (DeviceIdentifier)device, (TimePoint)from, null);
            } else if (boatId != null) {
                DynamicBoat mappedToBoat = domainFactory.getCompetitorAndBoatStore().getExistingBoatByIdAsString(boatId);
                mappedTo = mappedToBoat;
                if (mappedToBoat == null) {
                    logger.warning("No boat found for id " + boatId);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("No boat found for id " + StringEscapeUtils.escapeHtml((String)boatId))).type("text/plain").build();
                }
                Iterable registered = hasRegattaLike.getAllBoats();
                if (!Util.contains((Iterable)registered, (Object)mappedToBoat)) {
                    logger.warning("Boat found but not registered for leaderboard " + leaderboardName);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Boat found but not registered for leaderboard " + StringEscapeUtils.escapeHtml((String)leaderboardName))).type("text/plain").build();
                }
                event = new RegattaLogDeviceBoatMappingEventImpl(now, now, (AbstractLogEventAuthor)author, (Serializable)UUID.randomUUID(), (Boat)mappedToBoat, (DeviceIdentifier)device, (TimePoint)from, null);
            } else {
                Mark mappedToMark = domainFactory.getExistingMarkById(UUIDHelper.tryUuidConversion((Serializable)((Object)markId)));
                mappedTo = mappedToMark;
                if (mappedToMark == null) {
                    logger.warning("No mark found for id " + markId);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("No mark found for id " + StringEscapeUtils.escapeHtml((String)markId))).type("text/plain").build();
                }
                event = new RegattaLogDeviceMarkMappingEventImpl(now, now, (AbstractLogEventAuthor)author, (Serializable)UUID.randomUUID(), mappedToMark, (DeviceIdentifier)device, (TimePoint)from, null);
            }
            hasRegattaLike.getRegattaLike().getRegattaLog().add((AbstractLogEvent)event);
            logger.fine("Successfully checked in " + (markId != null ? "mark " : "competitor ") + mappedTo.getName());
            response = Response.status((Response.Status)Response.Status.OK).build();
        } else {
            response = Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        return response;
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="{name}/device_mappings/end")
    public Response postCheckout(String json, @PathParam(value="name") String leaderboardName) {
        Response response;
        JSONObject requestObject;
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        if (!this.isValidLeaderboard(leaderboard)) {
            logger.warning("Leaderboard does not exist or does not hold a RegattaLog");
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Leaderboard does not exist or does not hold a RegattaLog").type("text/plain").build();
        }
        IsRegattaLike isRegattaLike = ((HasRegattaLike)leaderboard).getRegattaLike();
        LogEventAuthorImpl author = new LogEventAuthorImpl("Compatibility", 16);
        TimePoint now = MillisecondsTimePoint.now();
        logger.fine("Post issued to " + ((Object)((Object)this)).getClass().getName());
        try {
            Object requestBody = JSONValue.parseWithException((String)json);
            requestObject = Helpers.toJSONObjectSafe((Object)requestBody);
        }
        catch (JsonDeserializationException | ParseException e) {
            logger.warning(String.format("Exception while parsing post request:\n%s", e.toString()));
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid JSON body in request").type("text/plain").build();
        }
        logger.fine("JSON requestObject is: " + requestObject.toString());
        Long toMillis = (Long)requestObject.get((Object)"toMillis");
        String competitorId = (String)requestObject.get((Object)"competitorId");
        String boatId = (String)requestObject.get((Object)"boatId");
        String markId = (String)requestObject.get((Object)"markId");
        String deviceUuidAsString = (String)requestObject.get((Object)"deviceUuid");
        String regattaSecret = (String)requestObject.get((Object)"secret");
        MillisecondsTimePoint closingTimePointInclusive = new MillisecondsTimePoint(toMillis.longValue());
        boolean allowedViaPermission = this.getSecurityService().hasCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)leaderboard);
        boolean allowedViaSecret = this.getService().skipChecksDueToCorrectSecret(leaderboardName, regattaSecret);
        if (allowedViaPermission || allowedViaSecret) {
            DynamicCompetitor mappedTo;
            if (toMillis == null || deviceUuidAsString == null || closingTimePointInclusive == null || competitorId == null && boatId == null && markId == null) {
                logger.warning("Invalid JSON body in request");
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid JSON body in request").type("text/plain").build();
            }
            if (competitorId != null) {
                DynamicCompetitor mappedToCompetitor;
                mappedTo = mappedToCompetitor = this.getService().getCompetitorAndBoatStore().getExistingCompetitorByIdAsString(competitorId);
                if (mappedToCompetitor == null) {
                    logger.warning("No competitor found for id " + competitorId);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("No competitor found for id " + competitorId)).type("text/plain").build();
                }
            } else if (boatId != null) {
                DynamicBoat mappedToBoat = this.getService().getCompetitorAndBoatStore().getExistingBoatByIdAsString(boatId);
                mappedTo = mappedToBoat;
                if (mappedToBoat == null) {
                    logger.warning("No boat found for id " + boatId);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("No boat found for id " + boatId)).type("text/plain").build();
                }
            } else {
                DomainFactory domainFactory = this.getService().getDomainObjectFactory().getBaseDomainFactory();
                Mark mappedToMark = domainFactory.getExistingMarkById(UUIDHelper.tryUuidConversion((Serializable)((Object)markId)));
                mappedTo = mappedToMark;
                if (mappedToMark == null) {
                    logger.warning("No mark found for id " + markId);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("No mark found for id " + markId)).type("text/plain").build();
                }
            }
            String mappedToTypeString = competitorId != null ? "competitor" : (markId != null ? "mark" : "boat");
            OpenEndedDeviceMappingFinder finder = new OpenEndedDeviceMappingFinder(isRegattaLike.getRegattaLog(), (WithID)mappedTo, deviceUuidAsString);
            Serializable deviceMappingEventId = (Serializable)finder.analyze();
            if (deviceMappingEventId == null) {
                logger.warning("No corresponding open " + mappedToTypeString + " to device mapping has been found");
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("No corresponding open " + mappedToTypeString + " to device mapping has been found")).type("text/plain").build();
            }
            RegattaLogCloseOpenEndedDeviceMappingEventImpl event = new RegattaLogCloseOpenEndedDeviceMappingEventImpl(now, (AbstractLogEventAuthor)author, deviceMappingEventId, (TimePoint)closingTimePointInclusive);
            isRegattaLike.getRegattaLog().add((AbstractLogEvent)event);
            logger.fine("Successfully checked out " + mappedToTypeString + mappedTo.getName());
            response = Response.status((Response.Status)Response.Status.OK).build();
        } else {
            response = Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        return response;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{leaderboardName}/competitors/{competitorId}")
    public Response getCompetitor(@PathParam(value="leaderboardName") String leaderboardName, @PathParam(value="competitorId") String competitorIdAsString, @QueryParam(value="secret") String secret) {
        Response response;
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        DynamicCompetitor competitor = this.getService().getCompetitorAndBoatStore().getExistingCompetitorByIdAsString(competitorIdAsString);
        if (competitor == null) {
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a competitor with id '" + StringEscapeUtils.escapeHtml((String)competitorIdAsString) + "'.")).type("text/plain").build();
        } else if (leaderboard == null) {
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a leaderboard with name '" + StringEscapeUtils.escapeHtml((String)leaderboardName) + "'.")).type("text/plain").build();
        } else {
            boolean skip = this.getService().skipChecksDueToCorrectSecret(leaderboardName, secret);
            if (!skip) {
                this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard);
                this.getSecurityService().checkCurrentUserHasOneOfExplicitPermissions((WithQualifiedObjectIdentifier)competitor, SecuredSecurityTypes.PublicReadableActions.READ_AND_READ_PUBLIC_ACTIONS);
            }
            JSONObject json = new CompetitorJsonSerializer().serialize((Competitor)competitor);
            json.put((Object)"displayName", (Object)leaderboard.getDisplayName((Competitor)competitor));
            response = Response.ok((Object)this.streamingOutput(json)).build();
        }
        return response;
    }

    private LeaderboardAndRaceColumnAndFleetAndResponse getLeaderboardAndRaceColumnAndFleet(String leaderboardName, String raceColumnName, String fleetName) {
        Fleet fleet;
        RaceColumn raceColumn;
        Response result;
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        if (leaderboard == null) {
            result = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a leaderboard with name '" + StringEscapeUtils.escapeHtml((String)leaderboardName) + "'.")).type("text/plain").build();
            raceColumn = null;
            fleet = null;
        } else if (raceColumnName == null) {
            result = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Specify a valid race_column parameter.").type("text/plain").build();
            raceColumn = null;
            fleet = null;
        } else {
            raceColumn = leaderboard.getRaceColumnByName(raceColumnName);
            if (raceColumn == null) {
                result = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a race column '" + StringEscapeUtils.escapeHtml((String)raceColumnName) + "' in leaderboard '" + StringEscapeUtils.escapeHtml((String)leaderboardName) + "'.")).type("text/plain").build();
                fleet = null;
            } else if (fleetName == null) {
                result = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Specify a valid fleet parameter.").type("text/plain").build();
                fleet = null;
            } else {
                fleet = raceColumn.getFleetByName(fleetName);
                result = fleet == null ? Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find fleet '" + StringEscapeUtils.escapeHtml((String)fleetName) + "' in leaderboard '" + StringEscapeUtils.escapeHtml((String)leaderboardName) + "' in race column " + raceColumnName + ".")).type("text/plain").build() : Response.ok().build();
            }
        }
        return new LeaderboardAndRaceColumnAndFleetAndResponse(leaderboard, raceColumn, fleet, result);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="{leaderboardName}/settrackingtimes")
    public Response setTrackingTimes(@PathParam(value="leaderboardName") String leaderboardName, @QueryParam(value="race_column") String raceColumnName, @QueryParam(value="fleet") String fleetName, @QueryParam(value="startoftracking") String startOfTrackingAsISO, @QueryParam(value="startoftrackingasmillis") Long startOfTrackingAsMillis, @QueryParam(value="endoftracking") String endOfTrackingAsISO, @QueryParam(value="endoftrackingasmillis") Long endOfTrackingAsMillis) throws InvalidDateException {
        Response result;
        LeaderboardAndRaceColumnAndFleetAndResponse leaderboardAndRaceColumnAndFleetAndResponse = this.getLeaderboardAndRaceColumnAndFleet(leaderboardName, raceColumnName, fleetName);
        SecurityUtils.getSubject().checkPermission(SecuredDomainType.LEADERBOARD.getStringPermissionForObject((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, (WithQualifiedObjectIdentifier)leaderboardAndRaceColumnAndFleetAndResponse.getLeaderboard()));
        if (leaderboardAndRaceColumnAndFleetAndResponse.getFleet() != null) {
            RaceLog raceLog = leaderboardAndRaceColumnAndFleetAndResponse.getRaceColumn().getRaceLog(leaderboardAndRaceColumnAndFleetAndResponse.getFleet());
            AbstractLogEventAuthor author = this.getService().getServerAuthor();
            JSONObject jsonResult = new JSONObject();
            if (startOfTrackingAsISO != null || startOfTrackingAsMillis != null) {
                TimePoint startOfTracking = this.parseTimePoint(startOfTrackingAsISO, startOfTrackingAsMillis, null);
                raceLog.add((AbstractLogEvent)new RaceLogStartOfTrackingEventImpl(startOfTracking, author, raceLog.getCurrentPassId()));
                jsonResult.put((Object)"startoftracking", startOfTracking == null ? null : Long.valueOf(startOfTracking.asMillis()));
            }
            if (endOfTrackingAsISO != null || endOfTrackingAsMillis != null) {
                TimePoint endOfTracking = this.parseTimePoint(endOfTrackingAsISO, endOfTrackingAsMillis, null);
                raceLog.add((AbstractLogEvent)new RaceLogEndOfTrackingEventImpl(endOfTracking, author, raceLog.getCurrentPassId()));
                jsonResult.put((Object)"endoftracking", endOfTracking == null ? null : Long.valueOf(endOfTracking.asMillis()));
            }
            result = Response.ok((Object)this.streamingOutput(jsonResult)).build();
        } else {
            result = leaderboardAndRaceColumnAndFleetAndResponse.getResponse();
        }
        return result;
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="{leaderboardName}/starttracking")
    public Response startRaceLogTracking(@PathParam(value="leaderboardName") String leaderboardName, @QueryParam(value="race_column") String raceColumnName, @QueryParam(value="fleet") String fleetName, @QueryParam(value="trackWind") Boolean trackWind, @QueryParam(value="correctWindDirectionByMagneticDeclination") Boolean correctWindDirectionByMagneticDeclination, @QueryParam(value="trackedRaceName") String optionalTrackedRaceName) throws NotDenotedForRaceLogTrackingException, Exception {
        LeaderboardAndRaceColumnAndFleetAndResponse leaderboardAndRaceColumnAndFleetAndResponse = this.getLeaderboardAndRaceColumnAndFleet(leaderboardName, raceColumnName, fleetName);
        SecurityUtils.getSubject().checkPermission(SecuredDomainType.LEADERBOARD.getStringPermissionForObject((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, (WithQualifiedObjectIdentifier)leaderboardAndRaceColumnAndFleetAndResponse.getLeaderboard()));
        Callable<Response> innerAction = () -> {
            Response result;
            if (leaderboardAndRaceColumnAndFleetAndResponse.getFleet() != null) {
                JSONObject jsonResult = new JSONObject();
                RaceLogTrackingAdapter adapter = this.getRaceLogTrackingAdapter();
                jsonResult.put((Object)"addeddenotation", (Object)adapter.denoteRaceForRaceLogTracking(this.getService(), leaderboardAndRaceColumnAndFleetAndResponse.getLeaderboard(), leaderboardAndRaceColumnAndFleetAndResponse.getRaceColumn(), leaderboardAndRaceColumnAndFleetAndResponse.getFleet(), optionalTrackedRaceName));
                RaceHandle raceHandle = adapter.startTracking(this.getService(), leaderboardAndRaceColumnAndFleetAndResponse.getLeaderboard(), leaderboardAndRaceColumnAndFleetAndResponse.getRaceColumn(), leaderboardAndRaceColumnAndFleetAndResponse.getFleet(), trackWind == null ? true : trackWind, correctWindDirectionByMagneticDeclination == null ? true : correctWindDirectionByMagneticDeclination, this.getService().getPermissionAwareRaceTrackingHandler());
                jsonResult.put((Object)"regatta", (Object)raceHandle.getRegatta().getName());
                result = Response.ok((Object)this.streamingOutput(jsonResult)).build();
            } else {
                result = leaderboardAndRaceColumnAndFleetAndResponse.getResponse();
            }
            return result;
        };
        Leaderboard leaderboard = leaderboardAndRaceColumnAndFleetAndResponse.getLeaderboard();
        Object leaderboardOrRegatta = leaderboard instanceof RegattaLeaderboard ? ((RegattaLeaderboard)leaderboard).getRegatta() : leaderboard;
        OwnershipAnnotation ownership = this.getSecurityService().getOwnership(leaderboardOrRegatta.getIdentifier());
        UserGroup groupOwner = ownership == null ? null : (UserGroup)((Ownership)ownership.getAnnotation()).getTenantOwner();
        Response result = groupOwner == null ? innerAction.call() : (Response)this.getSecurityService().doWithTemporaryDefaultTenant(groupOwner, innerAction);
        return result;
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="{leaderboardName}/autocourse")
    public Response setAutoCourse(@PathParam(value="leaderboardName") String leaderboardName, @QueryParam(value="race_column") String raceColumnName, @QueryParam(value="fleet") String fleetName) throws MalformedURLException, IOException, InterruptedException {
        Response result;
        LeaderboardAndRaceColumnAndFleetAndResponse leaderboardAndRaceColumnAndFleetAndResponse = this.getLeaderboardAndRaceColumnAndFleet(leaderboardName, raceColumnName, fleetName);
        SecurityUtils.getSubject().checkPermission(SecuredDomainType.LEADERBOARD.getStringPermissionForObject((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, (WithQualifiedObjectIdentifier)leaderboardAndRaceColumnAndFleetAndResponse.getLeaderboard()));
        if (leaderboardAndRaceColumnAndFleetAndResponse.getFleet() != null) {
            TrackedRace trackedRace = leaderboardAndRaceColumnAndFleetAndResponse.getRaceColumn().getTrackedRace(leaderboardAndRaceColumnAndFleetAndResponse.getFleet());
            if (trackedRace == null) {
                result = Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)"no tracked race").build();
            } else {
                RaceLog raceLog = leaderboardAndRaceColumnAndFleetAndResponse.getRaceColumn().getRaceLog(leaderboardAndRaceColumnAndFleetAndResponse.getFleet());
                Regatta regatta = trackedRace.getTrackedRegatta().getRegatta();
                RegattaLog regattaLog = regatta.getRegattaLog();
                Course autoCourse = this.createAutoCourse(trackedRace, regattaLog);
                TimePoint now = MillisecondsTimePoint.now();
                RaceLogCourseDesignChangedEventImpl courseDesignChangedEvent = new RaceLogCourseDesignChangedEventImpl(now, now, this.getService().getServerAuthor(), (Serializable)UUID.randomUUID(), raceLog.getCurrentPassId(), (CourseBase)autoCourse, CourseDesignerMode.BY_MARKS);
                raceLog.add((AbstractLogEvent)courseDesignChangedEvent);
                JSONObject jsonResult = new JSONObject();
                JSONObject jsonRace = new JSONObject();
                jsonResult.put((Object)"race", (Object)jsonRace);
                jsonRace.put((Object)"regatta", (Object)regatta.getName());
                RaceDefinition race = trackedRace.getRace();
                jsonRace.put((Object)"race", (Object)race.getName());
                jsonResult.put((Object)"course", (Object)new CourseJsonSerializer((JsonSerializer)new CourseBaseJsonSerializer((JsonSerializer)new WaypointJsonSerializer((JsonSerializer)new ControlPointJsonSerializer((JsonSerializer)new MarkJsonSerializer(), (JsonSerializer)new GateJsonSerializer((JsonSerializer)new MarkJsonSerializer()))))).serialize((CourseBase)autoCourse));
                result = Response.ok((Object)this.streamingOutput(jsonResult)).build();
            }
        } else {
            result = leaderboardAndRaceColumnAndFleetAndResponse.getResponse();
        }
        return result;
    }

    private Course createAutoCourse(TrackedRace trackedRace, RegattaLog regattaLog) {
        Waypoint finishLine;
        ArrayList<Waypoint> waypoints = new ArrayList<Waypoint>();
        Waypoint startLine = this.inferStartLine(trackedRace, regattaLog);
        if (startLine != null) {
            waypoints.add(startLine);
        }
        if ((finishLine = this.inferFinishLine(trackedRace, regattaLog, startLine)) != null) {
            waypoints.add(finishLine);
        }
        CourseImpl result = new CourseImpl("Auto-Course", waypoints);
        return result;
    }

    private Waypoint inferFinishLine(TrackedRace trackedRace, RegattaLog regattaLog, Waypoint startLine) {
        TimePoint startTime = this.getStartTime(trackedRace);
        TimePoint endTime = this.getEndTime(trackedRace);
        return this.createLineEnclosingTracks(trackedRace, regattaLog, startTime, true, "Finish", endTime, false);
    }

    private TimePoint getEndTime(TrackedRace trackedRace) {
        Object when = trackedRace.getEndOfRace() != null ? trackedRace.getEndOfRace() : (trackedRace.getFinishedTime() != null ? trackedRace.getFinishedTime() : (trackedRace.getEndOfTracking() != null ? trackedRace.getEndOfTracking() : (this.getStartTime(trackedRace) != null ? this.getStartTime(trackedRace).plus(Duration.ONE_HOUR.times(12L)) : null)));
        return when;
    }

    private Waypoint inferStartLine(TrackedRace trackedRace, RegattaLog regattaLog) {
        TimePoint startTime = this.getStartTime(trackedRace);
        return this.createLineEnclosingTracks(trackedRace, regattaLog, startTime, true, "Start", startTime, true);
    }

    private Waypoint createLineEnclosingTracks(TrackedRace trackedRace, RegattaLog regattaLog, TimePoint timePointForMarkFixes, boolean extrapolate, String waypointName, TimePoint timePointForCogAndSogRetrieval, boolean searchForward) {
        Waypoint result;
        if (timePointForMarkFixes != null) {
            Iterable<Util.Pair<Position, SpeedWithBearing>> positionsAndCogsAndSogs = this.getPositionsAndCogsAndSogs(trackedRace, timePointForCogAndSogRetrieval, extrapolate, searchForward);
            Bearing averageCourse = this.getAverageCourse(positionsAndCogsAndSogs);
            if (averageCourse != null) {
                Bearing fromStartBoatToPinEnd = averageCourse.add((Bearing)new DegreeBearingImpl(-90.0));
                Util.Pair<Position, Position> leftmostAndRightmostPositionsAtStart = this.getPositionsFarthestAheadAndFurthestBack(positionsAndCogsAndSogs, averageCourse.add((Bearing)new DegreeBearingImpl(90.0)));
                Position farthestAhead = (Position)this.getPositionsFarthestAheadAndFurthestBack(positionsAndCogsAndSogs, averageCourse).getA();
                if (leftmostAndRightmostPositionsAtStart.getA() != null && leftmostAndRightmostPositionsAtStart.getB() != null && farthestAhead != null) {
                    Position startBoatPosition = ((Position)leftmostAndRightmostPositionsAtStart.getB()).translateGreatCircle(fromStartBoatToPinEnd.reverse(), LINE_MARGIN);
                    Position pinEndPosition = ((Position)leftmostAndRightmostPositionsAtStart.getA()).translateGreatCircle(fromStartBoatToPinEnd, LINE_MARGIN);
                    Mark startBoat = this.getService().getBaseDomainFactory().getOrCreateMark((Serializable)UUID.randomUUID(), "Auto " + waypointName + " Boat", String.valueOf(waypointName) + "/S");
                    RegattaLogDefineMarkEventImpl defineStartBoatEvent = new RegattaLogDefineMarkEventImpl(MillisecondsTimePoint.now(), this.getService().getServerAuthor(), timePointForMarkFixes, (Serializable)UUID.randomUUID(), startBoat);
                    regattaLog.add((AbstractLogEvent)defineStartBoatEvent);
                    Mark pinEnd = this.getService().getBaseDomainFactory().getOrCreateMark((Serializable)UUID.randomUUID(), "Auto " + waypointName + " Pin End", String.valueOf(waypointName) + "/P");
                    RegattaLogDefineMarkEventImpl definePinEndEvent = new RegattaLogDefineMarkEventImpl(MillisecondsTimePoint.now(), this.getService().getServerAuthor(), timePointForMarkFixes, (Serializable)UUID.randomUUID(), pinEnd);
                    regattaLog.add((AbstractLogEvent)definePinEndEvent);
                    this.getRaceLogTrackingAdapter().pingMark(regattaLog, startBoat, (GPSFix)new GPSFixImpl(startBoatPosition, timePointForMarkFixes), this.getService());
                    this.getRaceLogTrackingAdapter().pingMark(regattaLog, pinEnd, (GPSFix)new GPSFixImpl(pinEndPosition, timePointForMarkFixes), this.getService());
                    ControlPointWithTwoMarks startLineControlPoint = this.getService().getBaseDomainFactory().getOrCreateControlPointWithTwoMarks((Serializable)UUID.randomUUID(), "Auto " + waypointName + " Line", pinEnd, startBoat, "Auto " + waypointName + " Line");
                    result = this.getService().getBaseDomainFactory().createWaypoint((ControlPoint)startLineControlPoint, PassingInstruction.Line);
                } else {
                    result = null;
                }
            } else {
                result = null;
                logger.warning(() -> "COG/SOG information for race " + trackedRace.getRace().getName() + " at " + timePointForMarkFixes + " missing. Cannot construct a line for waypoint " + waypointName + " enclosing tracks with unknown course.");
            }
        } else {
            result = null;
        }
        return result;
    }

    private TimePoint getStartTime(TrackedRace trackedRace) {
        TimePoint when = trackedRace.getStartOfRace() != null ? trackedRace.getStartOfRace() : trackedRace.getStartOfTracking();
        return when;
    }

    private Util.Pair<Position, Position> getPositionsFarthestAheadAndFurthestBack(Iterable<Util.Pair<Position, SpeedWithBearing>> positionsAndCogsAndSogs, Bearing averageCourse) {
        Position base = null;
        Distance.NullDistance maxDistance = null;
        Distance.NullDistance minDistance = null;
        Position positionFarthestAhead = null;
        Position positionFurthestBack = null;
        for (Util.Pair<Position, SpeedWithBearing> i : positionsAndCogsAndSogs) {
            Distance.NullDistance distanceFromBaseAlongAverageCourse;
            Position position = (Position)i.getA();
            if (base == null) {
                base = position;
                distanceFromBaseAlongAverageCourse = Distance.NULL;
            } else {
                Position projected = position.projectToLineThrough(base, averageCourse);
                distanceFromBaseAlongAverageCourse = projected.alongTrackDistance(base, averageCourse);
            }
            if (maxDistance == null || distanceFromBaseAlongAverageCourse.compareTo((Object)maxDistance) > 0) {
                maxDistance = distanceFromBaseAlongAverageCourse;
                positionFarthestAhead = position;
            }
            if (minDistance != null && distanceFromBaseAlongAverageCourse.compareTo((Object)minDistance) >= 0) continue;
            minDistance = distanceFromBaseAlongAverageCourse;
            positionFurthestBack = position;
        }
        return new Util.Pair(positionFarthestAhead, positionFurthestBack);
    }

    private Iterable<Util.Pair<Position, SpeedWithBearing>> getPositionsAndCogsAndSogs(TrackedRace trackedRace, TimePoint timePointForCogAndSogRetrievalSearchStart, boolean extrapolate, boolean searchForward) {
        ArrayList<Util.Pair<Position, SpeedWithBearing>> result = new ArrayList<Util.Pair<Position, SpeedWithBearing>>();
        TimePoint best = null;
        for (Competitor c : trackedRace.getRace().getCompetitors()) {
            GPSFixMoving firstQualifyingFix;
            GPSFixTrack track = trackedRace.getTrack(c);
            if (track == null) continue;
            GPSFixMoving gPSFixMoving = firstQualifyingFix = searchForward ? (GPSFixMoving)track.getFirstFixAtOrAfter(timePointForCogAndSogRetrievalSearchStart) : (GPSFixMoving)track.getLastFixAtOrBefore(timePointForCogAndSogRetrievalSearchStart);
            if (firstQualifyingFix == null || best != null && firstQualifyingFix.getTimePoint().compareTo((Object)best) < 0 != searchForward) continue;
            best = firstQualifyingFix.getTimePoint();
        }
        if (best != null) {
            TimePoint timePointForCogAndSogRetrieval = searchForward ? best.plus(TIME_OFFSET_FOR_HEAD_AND_TAIL_OF_TRACK_FOR_LINE_INFERENCE) : best.minus(TIME_OFFSET_FOR_HEAD_AND_TAIL_OF_TRACK_FOR_LINE_INFERENCE);
            for (Competitor c : trackedRace.getRace().getCompetitors()) {
                GPSFixTrack track = trackedRace.getTrack(c);
                if (track == null) continue;
                Position position = track.getEstimatedPosition(timePointForCogAndSogRetrieval, extrapolate);
                SpeedWithBearing speedWithBearing = track.getEstimatedSpeed(timePointForCogAndSogRetrieval);
                if (position == null || speedWithBearing == null) continue;
                result.add((Util.Pair<Position, SpeedWithBearing>)new Util.Pair((Object)position, (Object)speedWithBearing));
            }
        }
        return result;
    }

    private Bearing getAverageCourse(Iterable<Util.Pair<Position, SpeedWithBearing>> positionsAndCogsAndSogs) {
        ScalableBearing bearingSum = null;
        int size = 0;
        for (Util.Pair<Position, SpeedWithBearing> i : positionsAndCogsAndSogs) {
            ScalableBearing sb = new ScalableBearing(((SpeedWithBearing)i.getB()).getBearing());
            if (bearingSum == null) {
                bearingSum = sb;
            } else {
                bearingSum.add((ScalableValue)sb);
            }
            ++size;
        }
        return bearingSum == null ? null : bearingSum.divide((double)size);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="{leaderboardName}/removeTrackedRace")
    public Response removeTrackedRace(@PathParam(value="leaderboardName") String leaderboardName, @QueryParam(value="race_column") String raceColumnName, @QueryParam(value="fleet") String fleetName) throws MalformedURLException, IOException, InterruptedException {
        Leaderboard leaderBoard = this.getService().getLeaderboardByName(leaderboardName);
        Response result = null;
        if (leaderBoard == null) {
            result = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a leaderboard with name '" + StringEscapeUtils.escapeHtml((String)leaderboardName) + "'.")).type("text/plain").build();
        } else {
            this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)leaderBoard);
            result = this.stopOrRemoveTrackedRace(leaderboardName, raceColumnName, fleetName, true);
        }
        return result;
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="{leaderboardName}/stoptracking")
    public Response stopTracking(@PathParam(value="leaderboardName") String leaderboardName, @QueryParam(value="race_column") String raceColumnName, @QueryParam(value="fleet") String fleetName) throws MalformedURLException, IOException, InterruptedException {
        SecurityUtils.getSubject().checkPermission(SecuredDomainType.LEADERBOARD.getStringPermissionForObject((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, (WithQualifiedObjectIdentifier)this.getService().getLeaderboardByName(leaderboardName)));
        return this.stopOrRemoveTrackedRace(leaderboardName, raceColumnName, fleetName, false);
    }

    private Response stopOrRemoveTrackedRace(String leaderboardName, String raceColumnName, String fleetName, boolean remove) throws MalformedURLException, IOException, InterruptedException {
        Response result;
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        if (leaderboard == null) {
            result = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a leaderboard with name '" + StringEscapeUtils.escapeHtml((String)leaderboardName) + "'.")).type("text/plain").build();
        } else {
            JSONArray jsonResultArray = new JSONArray();
            for (RaceColumn raceColumn : leaderboard.getRaceColumns()) {
                if (raceColumnName != null && !raceColumn.getName().equals(raceColumnName)) continue;
                for (Fleet fleet : raceColumn.getFleets()) {
                    if (fleetName != null && !fleet.getName().equals(fleetName)) continue;
                    JSONObject jsonResult = new JSONObject();
                    TrackedRace trackedRace = raceColumn.getTrackedRace(fleet);
                    if (trackedRace == null) continue;
                    Regatta regatta = trackedRace.getTrackedRegatta().getRegatta();
                    RaceDefinition race = trackedRace.getRace();
                    this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)trackedRace);
                    if (remove) {
                        this.getService().apply((OperationWithResult)new RemoveAndUntrackRace(trackedRace.getRaceIdentifier()));
                    } else {
                        this.getService().apply((OperationWithResult)new StopTrackingRace(trackedRace.getRaceIdentifier()));
                    }
                    jsonResult.put((Object)"regatta", (Object)regatta.getName());
                    jsonResult.put((Object)"race", (Object)race.getName());
                    jsonResultArray.add((Object)jsonResult);
                }
            }
            result = Response.ok((Object)this.streamingOutput(jsonResultArray)).build();
        }
        return result;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{leaderboardName}/marks")
    public Response getMarksForRace(@PathParam(value="leaderboardName") String leaderboardName, @QueryParam(value="race_column") String raceColumnName, @QueryParam(value="fleet") String fleetName, @QueryParam(value="secret") String secret) {
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        if (leaderboard == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a leaderboard with name '" + StringEscapeUtils.escapeHtml((String)leaderboardName) + "'.")).type("text/plain").build();
        }
        if (!(leaderboard instanceof HasRegattaLike)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Leaderboard with name '" + leaderboardName + "'does not contain a RegattaLog'.")).type("text/plain").build();
        }
        boolean skip = this.getService().skipChecksDueToCorrectSecret(leaderboardName, secret);
        if (!skip) {
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard);
        }
        HashSet marks = new HashSet();
        if (raceColumnName == null) {
            if (fleetName != null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Either specify neither raceColumnName nor fleetName, only raceColumnName, or raceColumnName and fleetName but not only fleetName").type("text/plain").build();
            }
            for (RaceColumn raceColumn : leaderboard.getRaceColumns()) {
                Util.addAll((Iterable)raceColumn.getAvailableMarks(), marks);
            }
        } else {
            RaceColumn raceColumn;
            raceColumn = leaderboard.getRaceColumnByName(raceColumnName);
            if (raceColumn == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a race column '" + StringEscapeUtils.escapeHtml((String)raceColumnName) + "' in leaderboard '" + StringEscapeUtils.escapeHtml((String)leaderboardName) + "'.")).type("text/plain").build();
            }
            if (fleetName != null) {
                Fleet fleet = raceColumn.getFleetByName(fleetName);
                if (fleet == null) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find fleet '" + StringEscapeUtils.escapeHtml((String)fleetName) + "' in leaderboard '" + StringEscapeUtils.escapeHtml((String)leaderboardName) + "'.")).type("text/plain").build();
                }
                Util.addAll((Iterable)raceColumn.getAvailableMarks(fleet), marks);
            } else {
                Util.addAll((Iterable)raceColumn.getAvailableMarks(), marks);
            }
        }
        JSONArray array = new JSONArray();
        for (Mark mark : marks) {
            TimePoint now = MillisecondsTimePoint.now();
            Position lastKnownPosition = this.getService().getMarkPosition(mark, (LeaderboardThatHasRegattaLike)leaderboard, now);
            array.add((Object)this.markWithPositionSerializer.serialize(new Util.Pair((Object)mark, (Object)lastKnownPosition)));
        }
        JSONObject result = new JSONObject();
        result.put((Object)"marks", (Object)array);
        return Response.ok((Object)this.streamingOutput(result)).build();
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{leaderboardName}/starttime")
    public Response getStartTime(@PathParam(value="leaderboardName") String leaderboardName, @QueryParam(value="race_column") String raceColumnName, @QueryParam(value="fleet") String fleetName) {
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        if (leaderboard == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a leaderboard with name '" + StringEscapeUtils.escapeHtml((String)leaderboardName) + "'.")).type("text/plain").build();
        }
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard);
        RaceColumn raceColumn = leaderboard.getRaceColumnByName(raceColumnName);
        if (raceColumn == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a race column '" + StringEscapeUtils.escapeHtml((String)raceColumnName) + "' in leaderboard '" + StringEscapeUtils.escapeHtml((String)leaderboardName) + "'.")).type("text/plain").build();
        }
        Fleet fleet = raceColumn.getFleetByName(fleetName);
        if (fleet == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a fleet '" + StringEscapeUtils.escapeHtml((String)fleetName) + "' in raceColumn '" + StringEscapeUtils.escapeHtml((String)raceColumnName) + "'.")).type("text/plain").build();
        }
        Util.Triple result = this.getService().getStartTimeAndProcedure(leaderboardName, raceColumnName, fleetName);
        JSONObject responseJson = new JSONObject();
        if (result != null) {
            responseJson.put((Object)"startTimeAsMillis", result.getA() == null ? null : Long.valueOf(((TimePoint)result.getA()).asMillis()));
            responseJson.put((Object)"passId", result.getB());
            responseJson.put((Object)"racingProcedureType", result.getC() == null ? null : ((RacingProcedureType)result.getC()).name());
        }
        return Response.ok((Object)this.streamingOutput(responseJson)).build();
    }

    @PUT
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{leaderboardName}/starttime")
    public Response setStartTime(@PathParam(value="leaderboardName") String leaderboardName, @QueryParam(value="race_column") String raceColumnName, @QueryParam(value="fleet") String fleetName, @QueryParam(value="authorName") String authorName, @QueryParam(value="authorPriority") Integer authorPriority, @QueryParam(value="passId") Integer passId, @QueryParam(value="startTime") Long startTime, @QueryParam(value="startProcedureType") String racingProcedure, @QueryParam(value="courseAreaIdAsString") String courseAreaIdAsString) {
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        if (leaderboard == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a leaderboard with name '" + StringEscapeUtils.escapeHtml((String)leaderboardName) + "'.")).type("text/plain").build();
        }
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)leaderboard);
        RaceColumn raceColumn = leaderboard.getRaceColumnByName(raceColumnName);
        if (raceColumn == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a race column '" + StringEscapeUtils.escapeHtml((String)raceColumnName) + "' in leaderboard '" + StringEscapeUtils.escapeHtml((String)leaderboardName) + "'.")).type("text/plain").build();
        }
        Fleet fleet = raceColumn.getFleetByName(fleetName);
        if (fleet == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a fleet '" + StringEscapeUtils.escapeHtml((String)fleetName) + "' in raceColumn '" + StringEscapeUtils.escapeHtml((String)raceColumnName) + "'.")).type("text/plain").build();
        }
        TimePoint effectiveStartTime = this.getService().setStartTimeAndProcedure(leaderboardName, raceColumnName, fleetName, authorName, authorPriority.intValue(), passId.intValue(), MillisecondsTimePoint.now(), (TimePoint)new MillisecondsTimePoint(startTime.longValue()), racingProcedure == null ? null : RacingProcedureType.valueOf((String)racingProcedure), courseAreaIdAsString == null ? null : UUID.fromString(courseAreaIdAsString));
        JSONObject responseJson = new JSONObject();
        responseJson.put((Object)"startTimeAsMillis", (Object)effectiveStartTime.asMillis());
        return Response.ok((Object)this.streamingOutput(responseJson)).build();
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{leaderboardName}/startorder")
    public Response getStartOrder(@PathParam(value="leaderboardName") String leaderboardName, @QueryParam(value="race_column") String raceColumnName, @QueryParam(value="fleet") String fleetName) {
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        if (leaderboard == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a leaderboard with name '" + StringEscapeUtils.escapeHtml((String)leaderboardName) + "'.")).type("text/plain").build();
        }
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard);
        RaceColumn raceColumn = leaderboard.getRaceColumnByName(raceColumnName);
        if (raceColumn == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a race column '" + StringEscapeUtils.escapeHtml((String)raceColumnName) + "' in leaderboard '" + StringEscapeUtils.escapeHtml((String)leaderboardName) + "'.")).type("text/plain").build();
        }
        Fleet fleet = raceColumn.getFleetByName(fleetName);
        if (fleet == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a fleet '" + StringEscapeUtils.escapeHtml((String)fleetName) + "' in raceColumn '" + StringEscapeUtils.escapeHtml((String)raceColumnName) + "'.")).type("text/plain").build();
        }
        TrackedRace trackedRace = raceColumn.getTrackedRace(fleet);
        if (trackedRace == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a tracked race for raceColumn '" + StringEscapeUtils.escapeHtml((String)raceColumnName) + " and fleet '" + StringEscapeUtils.escapeHtml((String)fleetName) + "'.")).type("text/plain").build();
        }
        Course course = trackedRace.getRace().getCourse();
        ArrayList competitors = new ArrayList();
        Waypoint firstWaypoint = course.getFirstWaypoint();
        TimePoint timeToUseForStart = trackedRace.getStartOfRace() != null ? trackedRace.getStartOfRace() : MillisecondsTimePoint.now();
        if (firstWaypoint != null) {
            List startWaypointMarkPositions = StreamSupport.stream(firstWaypoint.getMarks().spliterator(), false).map(mark -> trackedRace.getTrack(mark)).filter(markTrack -> markTrack != null).map(markTrack -> markTrack.getEstimatedPosition(timeToUseForStart, false)).collect(Collectors.toList());
            Util.addAll((Iterable)Util.filter((Iterable)trackedRace.getRace().getCompetitors(), competitor -> SecurityUtils.getSubject().isPermitted(competitor.getIdentifier().getStringPermission((HasPermissions.Action)SecuredSecurityTypes.PublicReadableActions.READ_PUBLIC)) || SecurityUtils.getSubject().isPermitted(competitor.getIdentifier().getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.READ))), competitors);
            competitors.sort((a, b) -> {
                MarkPassing aStartMarkPassing = trackedRace.getMarkPassing(a, firstWaypoint);
                MarkPassing bStartMarkPassing = trackedRace.getMarkPassing(b, firstWaypoint);
                int result = aStartMarkPassing == null ? (bStartMarkPassing == null ? this.compareDistanceFromStartLine(trackedRace, startWaypointMarkPositions, timeToUseForStart, (Competitor)a, (Competitor)b) : 1) : (bStartMarkPassing == null ? -1 : aStartMarkPassing.getTimePoint().compareTo((Object)bStartMarkPassing.getTimePoint()));
                return result;
            });
        }
        CompetitorAndBoatJsonSerializer serializer = CompetitorAndBoatJsonSerializer.create((boolean)false);
        JSONArray result = new JSONArray();
        for (Competitor c : competitors) {
            Boat boat = trackedRace.getBoatOfCompetitor(c);
            JSONObject jsonCompetitor = serializer.serialize(new Util.Pair((Object)c, (Object)boat));
            result.add((Object)jsonCompetitor);
        }
        return Response.ok((Object)this.streamingOutput(result)).header("Content-Type", (Object)"application/json;charset=UTF-8").build();
    }

    private int compareDistanceFromStartLine(TrackedRace trackedRace, Iterable<Position> startWaypointMarkPositions, TimePoint timeToUseForStart, Competitor a, Competitor b) {
        Position aPos = trackedRace.getTrack(a).getEstimatedPosition(timeToUseForStart, true);
        Position bPos = trackedRace.getTrack(b).getEstimatedPosition(timeToUseForStart, true);
        Distance aDist = aPos == null ? null : this.getDistanceFromStartWaypoint(aPos, startWaypointMarkPositions);
        Distance bDist = bPos == null ? null : this.getDistanceFromStartWaypoint(bPos, startWaypointMarkPositions);
        return Comparator.nullsLast(Comparator.naturalOrder()).compare(aDist, bDist);
    }

    private Distance getDistanceFromStartWaypoint(Position pos, Iterable<Position> startWaypointMarkPositions) {
        Distance result;
        if (Util.isEmpty(startWaypointMarkPositions)) {
            result = null;
        } else if (Util.size(startWaypointMarkPositions) == 1) {
            result = startWaypointMarkPositions.iterator().next().getDistance(pos);
        } else {
            Position first = (Position)Util.get(startWaypointMarkPositions, (int)0);
            Position second = (Position)Util.get(startWaypointMarkPositions, (int)1);
            result = pos.getDistanceToLine(first, second).abs();
        }
        return result;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{leaderboardName}/marks/{markId}")
    public Response getMark(@PathParam(value="leaderboardName") String leaderboardName, @PathParam(value="markId") String markId, @QueryParam(value="secret") String secret) {
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        if (leaderboard == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a leaderboard with name '" + StringEscapeUtils.escapeHtml((String)leaderboardName) + "'.")).type("text/plain").build();
        }
        if (!(leaderboard instanceof HasRegattaLike)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Leaderboard with name '" + leaderboardName + "'does not contain a RegattaLog'.")).type("text/plain").build();
        }
        Mark mark = null;
        block0: for (RaceColumn raceColumn : leaderboard.getRaceColumns()) {
            for (Mark availableMark : raceColumn.getAvailableMarks()) {
                if (!availableMark.getId().toString().equals(markId)) continue;
                mark = availableMark;
                continue block0;
            }
        }
        if (mark == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a mark with ID '" + StringEscapeUtils.escapeHtml((String)markId) + "'.")).type("text/plain").build();
        }
        boolean skip = this.getService().skipChecksDueToCorrectSecret(leaderboardName, secret);
        if (!skip) {
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard);
        }
        TimePoint now = MillisecondsTimePoint.now();
        Position lastKnownPosition = this.getService().getMarkPosition(mark, (LeaderboardThatHasRegattaLike)leaderboard, now);
        JSONObject result = this.markWithPositionSerializer.serialize(new Util.Pair((Object)mark, (Object)lastKnownPosition));
        return Response.ok((Object)this.streamingOutput(result)).build();
    }

    @POST
    @Path(value="{leaderboardName}/marks/{markId}/gps_fixes")
    @Consumes(value={"application/json"})
    public Response pingMark(String json, @PathParam(value="leaderboardName") String leaderboardName, @PathParam(value="markId") String markId, @QueryParam(value="secret") String regattaSecret) throws HTTPException {
        GPSFix fix;
        logger.fine("Post issued to " + ((Object)((Object)this)).getClass().getName());
        RacingEventService service = this.getService();
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        if (leaderboard == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a leaderboard with name '" + StringEscapeUtils.escapeHtml((String)leaderboardName) + "'.")).type("text/plain").build();
        }
        RegattaLog regattaLog = null;
        if (!(leaderboard instanceof HasRegattaLike)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Leaderboard '" + StringEscapeUtils.escapeHtml((String)leaderboardName) + "' does not have an attached RegattaLog.")).type("text/plain").build();
        }
        regattaLog = ((HasRegattaLike)leaderboard).getRegattaLike().getRegattaLog();
        Mark mark = service.getBaseDomainFactory().getExistingMarkByIdAsString(markId);
        if (mark == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a mark with ID '" + StringEscapeUtils.escapeHtml((String)markId) + "'.")).type("text/plain").build();
        }
        if (!this.getService().skipChecksDueToCorrectSecret(leaderboardName, regattaSecret)) {
            this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)leaderboard);
        }
        try {
            Object requestBody = JSONValue.parseWithException((String)json);
            JSONObject requestObject = Helpers.toJSONObjectSafe((Object)requestBody);
            logger.fine("JSON requestObject is: " + requestObject.toString());
            fix = this.fixDeserializer.deserialize(requestObject);
        }
        catch (JsonDeserializationException | NumberFormatException | ParseException e) {
            logger.warning(String.format("Exception while parsing post request:\n%s", e.toString()));
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid JSON body in request").type("text/plain").build();
        }
        RaceLogTrackingAdapter adapter = this.getRaceLogTrackingAdapter();
        adapter.pingMark(regattaLog, mark, fix, service);
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{leaderboardName}/racecolumnfactors")
    public Response getRaceColumnFactors(@PathParam(value="leaderboardName") String leaderboardName, @QueryParam(value="race_column") String raceColumnName) {
        Response response;
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        if (leaderboard == null) {
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a leaderboard with name '" + StringEscapeUtils.escapeHtml((String)leaderboardName) + "'.")).type("text/plain").build();
        } else {
            RaceColumn raceColumn;
            Set<RaceColumn> raceColumns;
            this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)leaderboard);
            if (raceColumnName == null) {
                raceColumns = leaderboard.getRaceColumns();
                raceColumn = null;
            } else {
                raceColumn = leaderboard.getRaceColumnByName(raceColumnName);
                raceColumns = Collections.singleton(raceColumn);
            }
            if (raceColumnName != null && raceColumn == null) {
                response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a race column named '" + StringEscapeUtils.escapeHtml((String)raceColumnName) + "' in leaderboard with name '" + StringEscapeUtils.escapeHtml((String)leaderboardName) + "'.")).type("text/plain").build();
            } else {
                JSONObject json = this.getJsonForColumnFactors(leaderboard, raceColumns);
                response = Response.ok((Object)this.streamingOutput(json)).build();
            }
        }
        return response;
    }

    private JSONObject getJsonForColumnFactors(Leaderboard leaderboard, Iterable<RaceColumn> raceColumns) {
        JSONObject json = new JSONObject();
        json.put((Object)"leaderboard_name", (Object)leaderboard.getName());
        json.put((Object)"leaderboard_display_name", (Object)leaderboard.getDisplayName());
        JSONArray raceColumnsAsJson = new JSONArray();
        json.put((Object)"race_columns", (Object)raceColumnsAsJson);
        for (RaceColumn rc : raceColumns) {
            JSONObject raceColumnAsJson = new JSONObject();
            raceColumnsAsJson.add((Object)raceColumnAsJson);
            raceColumnAsJson.put((Object)"race_column_name", (Object)rc.getName());
            raceColumnAsJson.put((Object)"explicit_factor", (Object)rc.getExplicitFactor());
            raceColumnAsJson.put((Object)"factor", (Object)leaderboard.getScoringScheme().getScoreFactor(rc));
        }
        return json;
    }

    @POST
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{leaderboardName}/racecolumnfactors")
    public Response setExplicitRaceColumnFactor(@PathParam(value="leaderboardName") String leaderboardName, @QueryParam(value="race_column") String raceColumnName, @QueryParam(value="explicit_factor") Double explicitFactor) {
        Response response;
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        if (leaderboard == null) {
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a leaderboard with name '" + StringEscapeUtils.escapeHtml((String)leaderboardName) + "'.")).type("text/plain").build();
        } else {
            this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)leaderboard);
            RaceColumn raceColumn = leaderboard.getRaceColumnByName(raceColumnName);
            if (raceColumn == null) {
                response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a race column named '" + StringEscapeUtils.escapeHtml((String)raceColumnName) + "' in leaderboard with name '" + StringEscapeUtils.escapeHtml((String)leaderboardName) + "'.")).type("text/plain").build();
            } else {
                raceColumn.setFactor(explicitFactor);
                JSONObject json = this.getJsonForColumnFactors(leaderboard, Collections.singleton(raceColumn));
                response = Response.ok((Object)this.streamingOutput(json)).build();
            }
        }
        return response;
    }

    @POST
    @Path(value="{leaderboardName}/denoteForTracking")
    public Response denoteForTracking(@PathParam(value="leaderboardName") String leaderboardName, @QueryParam(value="raceColumnName") String raceColumnName, @QueryParam(value="fleetName") String fleetName, @QueryParam(value="raceName") String raceName) throws NotFoundException, NotDenotableForRaceLogTrackingException {
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)leaderboard);
        if (leaderboard == null) {
            throw new NotFoundException("leaderboard with name " + leaderboardName + " not found");
        }
        RaceColumn raceColumn = leaderboard.getRaceColumnByName(raceColumnName);
        if (raceColumn == null) {
            throw new NotFoundException("raceColumn with name " + raceColumnName + " not found");
        }
        Fleet fleet = raceColumn.getFleetByName(fleetName);
        if (fleet == null) {
            throw new NotFoundException("fleet with name " + fleetName + " not found");
        }
        boolean result = this.getRaceLogTrackingAdapter().denoteRaceForRaceLogTracking(this.getService(), leaderboard, raceColumn, fleet, raceName);
        return (result ? Response.ok() : Response.notModified()).build();
    }

    @POST
    @Path(value="{leaderboardName}/enableRaceLogForCompetitorRegistration")
    public Response enableRaceLogForCompetitorRegistration(@PathParam(value="leaderboardName") String leaderboardName, @QueryParam(value="raceColumnName") String raceColumnName, @QueryParam(value="fleetName") String fleetName, @QueryParam(value="raceName") String raceName) throws NotFoundException, NotDenotableForRaceLogTrackingException {
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)leaderboard);
        if (leaderboard == null) {
            throw new NotFoundException("leaderboard with name " + leaderboardName + " not found");
        }
        RaceColumn raceColumn = leaderboard.getRaceColumnByName(raceColumnName);
        if (raceColumn == null) {
            throw new NotFoundException("raceColumn with name " + raceColumnName + " not found");
        }
        Fleet fleet = raceColumn.getFleetByName(fleetName);
        if (fleet == null) {
            throw new NotFoundException("fleet with name " + fleetName + " not found");
        }
        LogEventAuthorImpl raceLogEventAuthorForRaceColumn = new LogEventAuthorImpl(AbstractRaceColumn.class.getName(), 0);
        TimePoint now = MillisecondsTimePoint.now();
        RaceLog raceLog = raceColumn.getRaceLog(fleet);
        if (raceLog == null) {
            throw new IllegalStateException("Racelog for fleet is null");
        }
        int passId = raceLog.getCurrentPassId();
        raceLog.add((AbstractLogEvent)new RaceLogUseCompetitorsFromRaceLogEventImpl(now, (AbstractLogEventAuthor)raceLogEventAuthorForRaceColumn, now, (Serializable)UUID.randomUUID(), passId));
        return (raceColumn.isCompetitorRegistrationInRacelogEnabled(fleet) ? Response.ok() : Response.notModified()).build();
    }

    @POST
    @Path(value="/{name}/migrate")
    public Response migrateOwnershipForLeaderboard(@PathParam(value="name") String leaderboardName, @QueryParam(value="createNewGroup") Boolean createNewGroup, @QueryParam(value="existingGroupId") UUID existingGroupIdOrNull, @QueryParam(value="newGroupName") String newGroupName, @QueryParam(value="migrateCompetitors") Boolean migrateCompetitors, @QueryParam(value="migrateBoats") Boolean migrateBoats, @QueryParam(value="copyMembersAndRoles") Boolean copyMembersAndRoles) throws ParseException, JsonDeserializationException {
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        SailingHierarchyOwnershipUpdater updater = SailingHierarchyOwnershipUpdater.createOwnershipUpdater((boolean)createNewGroup, (UUID)existingGroupIdOrNull, (String)newGroupName, (boolean)migrateCompetitors, (boolean)migrateBoats, (boolean)(copyMembersAndRoles == null ? true : copyMembersAndRoles), (RacingEventService)this.getService());
        updater.updateGroupOwnershipForLeaderboardHierarchy(leaderboard);
        return Response.ok().build();
    }

    @PUT
    @Path(value="/{name}/results")
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    public Response uploadResults(@PathParam(value="name") String leaderboardName, @QueryParam(value="scoreCorrectionProvider") String scoreCorrectionProviderName, @QueryParam(value="timePointOfLastCorrectionValidityMillis") Long timePointOfLastCorrectionValidityMillis, @QueryParam(value="comment") String comment, @QueryParam(value="allowRaceDefaultsByOrder") Boolean allowRaceDefaultsByOrder, @QueryParam(value="sailId") List<String> sailIds, @QueryParam(value="competitorId") List<String> competitorIdsAsStringForSailIds, @QueryParam(value="raceNumber") List<String> raceNumbers, @QueryParam(value="raceColumnName") List<String> raceColumnNamesForRaceNumbers, @QueryParam(value="allowPartialImport") Boolean allowPartialImport, InputStream inputStream) throws Exception {
        Response result;
        if (sailIds == null != (competitorIdsAsStringForSailIds == null) || sailIds != null && sailIds.size() != competitorIdsAsStringForSailIds.size()) {
            throw new IllegalArgumentException("The competitorId and sailId arrays don't match in presence or length");
        }
        if (raceNumbers == null != (raceColumnNamesForRaceNumbers == null) || raceNumbers != null && raceNumbers.size() != raceColumnNamesForRaceNumbers.size()) {
            throw new IllegalArgumentException("The raceNumber and raceColumnNameForRaceNumber arrays don't match in presence or length");
        }
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        if (leaderboard == null) {
            throw new NotFoundException("leaderboard with name " + leaderboardName + " not found");
        }
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)leaderboard);
        Optional scoreCorrectionProvider = this.getScoreCorrectionProvider(scoreCorrectionProviderName);
        if (!scoreCorrectionProvider.isPresent()) {
            throw new NotFoundException("score correction provider with name " + scoreCorrectionProviderName + " not found");
        }
        HashMap<String, Competitor> sailIdToCompetitorMap = new HashMap<String, Competitor>();
        if (sailIds != null) {
            int i = 0;
            while (i < sailIds.size()) {
                sailIdToCompetitorMap.put(sailIds.get(i), leaderboard.getCompetitorByIdAsString(competitorIdsAsStringForSailIds.get(i)));
                ++i;
            }
        }
        HashMap<String, RaceColumn> raceNumberOrNameToRaceColumnMap = new HashMap<String, RaceColumn>();
        if (raceNumbers != null) {
            int i = 0;
            while (i < raceNumbers.size()) {
                raceNumberOrNameToRaceColumnMap.put(raceNumbers.get(i), leaderboard.getRaceColumnByName(raceColumnNamesForRaceNumbers.get(i)));
                ++i;
            }
        }
        try {
            RegattaScoreCorrections scoreCorrection = ((ScoreCorrectionProvider)scoreCorrectionProvider.get()).getScoreCorrections(inputStream);
            if (comment != null || timePointOfLastCorrectionValidityMillis != null) {
                String finalComment = comment == null ? leaderboard.getScoreCorrection().getComment() : comment;
                Object timePointOfLastCorrectionValidity = timePointOfLastCorrectionValidityMillis == null ? leaderboard.getScoreCorrection().getTimePointOfLastCorrectionsValidity() : new MillisecondsTimePoint(timePointOfLastCorrectionValidityMillis.longValue());
                logger.info("Applying score correction comment \"" + finalComment + "\" and validity time point " + timePointOfLastCorrectionValidity + " to leaderboard " + leaderboardName + " on behalf of " + SessionUtils.getPrincipal());
                this.getService().apply((OperationWithResult)new UpdateLeaderboardScoreCorrectionMetadata(leaderboardName, timePointOfLastCorrectionValidity, finalComment));
            }
            result = this.applyScoreCorrectionToLeaderboard(leaderboard, scoreCorrection, sailIdToCompetitorMap, raceNumberOrNameToRaceColumnMap, allowRaceDefaultsByOrder != null && allowRaceDefaultsByOrder != false, allowPartialImport != null && allowPartialImport != false);
        }
        catch (Exception e) {
            result = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private Response applyScoreCorrectionToLeaderboard(Leaderboard leaderboard, RegattaScoreCorrections scoreCorrection, Map<String, Competitor> sailIdToCompetitorMap, Map<String, RaceColumn> raceNumberOrNameToRaceColumnMap, boolean allowRaceDefaultsByOrder, boolean allowPartialImport) {
        void var13_18;
        ScoreCorrectionMapping scoreCorrectionMapping = leaderboard.mapRegattaScoreCorrections(scoreCorrection, raceNumberOrNameToRaceColumnMap, sailIdToCompetitorMap, allowRaceDefaultsByOrder, allowPartialImport);
        JSONObject result = new JSONObject();
        result.put((Object)"complete", (Object)scoreCorrectionMapping.isComplete());
        result.put((Object)"allowPartialImport", (Object)allowPartialImport);
        JSONArray unmatchedSailIds = new JSONArray();
        JSONArray unmatchedRaceNumbers = new JSONArray();
        JSONArray matchedSailIds = new JSONArray();
        for (Map.Entry e : scoreCorrectionMapping.getCompetitorMappings().entrySet()) {
            if (e.getValue() != null) {
                JSONObject matchedSailId = new JSONObject();
                matchedSailId.put((Object)"sailId", e.getKey());
                matchedSailId.put((Object)"competitorId", (Object)((Competitor)e.getValue()).getId().toString());
                matchedSailIds.add((Object)matchedSailId);
                continue;
            }
            unmatchedSailIds.add(e.getKey());
        }
        JSONArray matchedRaceNumbers = new JSONArray();
        for (Map.Entry entry : scoreCorrectionMapping.getRaceMappings().entrySet()) {
            if (entry.getValue() != null) {
                JSONObject matchedRaceNumber = new JSONObject();
                matchedRaceNumber.put((Object)"raceNumber", entry.getKey());
                matchedRaceNumber.put((Object)"raceColumnName", (Object)((RaceColumn)entry.getValue()).getName());
                matchedRaceNumbers.add((Object)matchedRaceNumber);
                continue;
            }
            unmatchedRaceNumbers.add(entry.getKey());
        }
        result.put((Object)"matchedSailIds", (Object)matchedSailIds);
        result.put((Object)"matchedRaceNumbers", (Object)matchedRaceNumbers);
        result.put((Object)"unmatchedSailIds", (Object)unmatchedSailIds);
        result.put((Object)"unmatchedRaceNumbers", (Object)unmatchedRaceNumbers);
        if (!allowPartialImport && !scoreCorrectionMapping.isComplete()) {
            Response.ResponseBuilder responseBuilder = Response.status((Response.Status)Response.Status.CONFLICT);
        } else {
            try {
                JSONArray applyResult = this.applyMatchedEntriesToLeaderboardScoreCorrections(leaderboard, scoreCorrectionMapping);
                result.put((Object)"applyResult", (Object)applyResult);
                Response.ResponseBuilder responseBuilder = Response.status((Response.Status)Response.Status.OK);
            }
            catch (Exception e) {
                result.put((Object)"errorMessage", (Object)e.getMessage());
                Response.ResponseBuilder responseBuilder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
            }
        }
        return var13_18.entity((Object)this.streamingOutput(result)).build();
    }

    private JSONArray applyMatchedEntriesToLeaderboardScoreCorrections(Leaderboard leaderboard, ScoreCorrectionMapping scoreCorrectionMapping) {
        TimePoint timePoint = MillisecondsTimePoint.now();
        JSONArray result = new JSONArray();
        for (Map.Entry raceColumnEntry : scoreCorrectionMapping.getRaceMappings().entrySet()) {
            if (raceColumnEntry.getValue() == null) continue;
            JSONObject raceColumnResults = new JSONObject();
            raceColumnResults.put((Object)"raceNumber", raceColumnEntry.getKey());
            raceColumnResults.put((Object)"raceColumnName", (Object)((RaceColumn)raceColumnEntry.getValue()).getName());
            JSONArray competitorResults = new JSONArray();
            raceColumnResults.put((Object)"competitors", (Object)competitorResults);
            for (Map.Entry competitorEntry : scoreCorrectionMapping.getCompetitorMappings().entrySet()) {
                if (competitorEntry.getValue() == null) continue;
                JSONObject competitorResult = new JSONObject();
                competitorResult.put((Object)"sailId", competitorEntry.getKey());
                competitorResult.put((Object)"competitorId", (Object)((Competitor)competitorEntry.getValue()).getId().toString());
                Double points = (Double)((Util.Pair)((Map)scoreCorrectionMapping.getScoreCorrections().get(raceColumnEntry.getValue())).get(competitorEntry.getValue())).getA();
                this.getService().apply((OperationWithResult)new UpdateLeaderboardScoreCorrection(leaderboard.getName(), ((RaceColumn)raceColumnEntry.getValue()).getName(), ((Competitor)competitorEntry.getValue()).getId().toString(), points, timePoint));
                competitorResult.put((Object)"score", (Object)points);
                MaxPointsReason maxPointsReason = (MaxPointsReason)((Util.Pair)((Map)scoreCorrectionMapping.getScoreCorrections().get(raceColumnEntry.getValue())).get(competitorEntry.getValue())).getB();
                this.getService().apply((OperationWithResult)new UpdateLeaderboardMaxPointsReason(leaderboard.getName(), ((RaceColumn)raceColumnEntry.getValue()).getName(), ((Competitor)competitorEntry.getValue()).getId().toString(), maxPointsReason, timePoint));
                competitorResult.put((Object)"maxPointsReason", (Object)maxPointsReason);
                competitorResults.add((Object)competitorResult);
            }
            result.add((Object)raceColumnResults);
        }
        return result;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{name}/cpu")
    public Response getCPUMeter(@PathParam(value="name") String leaderboardName) throws NotFoundException {
        Leaderboard leaderboard = this.getService().getLeaderboardByName(leaderboardName);
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)leaderboard);
        if (leaderboard == null) {
            throw new NotFoundException("leaderboard with name " + leaderboardName + " not found");
        }
        return Response.ok().entity((Object)this.streamingOutput(new CPUMeterJsonSerializer().serialize(leaderboard.getCPUMeter()))).build();
    }

    private static class LeaderboardAndRaceColumnAndFleetAndResponse {
        private final Leaderboard leaderboard;
        private final RaceColumn raceColumn;
        private final Fleet fleet;
        private final Response response;

        public LeaderboardAndRaceColumnAndFleetAndResponse(Leaderboard leaderboard, RaceColumn raceColumn, Fleet fleet, Response response) {
            this.leaderboard = leaderboard;
            this.raceColumn = raceColumn;
            this.fleet = fleet;
            this.response = response;
        }

        public Leaderboard getLeaderboard() {
            return this.leaderboard;
        }

        public RaceColumn getRaceColumn() {
            return this.raceColumn;
        }

        public Fleet getFleet() {
            return this.fleet;
        }

        public Response getResponse() {
            return this.response;
        }
    }
}

