/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.jaxrs.api;

import com.sap.sailing.shared.server.gateway.jaxrs.AbstractSailingServerResource;
import com.sap.sse.common.NoCorrespondingServiceRegisteredException;
import com.sap.sse.filestorage.InvalidPropertiesException;
import com.sap.sse.filestorage.OperationFailedException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.UnauthorizedException;
import org.json.simple.JSONObject;

@Path(value="/v1/file")
public class FileStorageResource
extends AbstractSailingServerResource {
    private static final Logger logger = Logger.getLogger(FileStorageResource.class.getName());

    @GET
    public Response getFile(@QueryParam(value="uri") String uri) {
        Response response;
        try {
            this.getService().getFileStorageManagementService().getActiveFileStorageService().doPermissionCheckForGetFile(new URI(uri));
            InputStream inputStream = new URL(uri).openStream();
            Response.ResponseBuilder responseBuilder = Response.ok().entity((Object)inputStream);
            if (uri.toLowerCase().endsWith(".jpg")) {
                responseBuilder.header("Content-Type", (Object)"image/jpeg");
            } else if (uri.toLowerCase().endsWith(".png")) {
                responseBuilder.header("Content-Type", (Object)"image/png");
            }
            response = responseBuilder.build();
        }
        catch (IOException | URISyntaxException ioe) {
            response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ioe.getMessage()).build();
        }
        catch (UnauthorizedException e) {
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        return response;
    }

    @DELETE
    @Produces(value={"application/json;charset=UTF-8"})
    public Response deleteFile(@QueryParam(value="uri") String uri) {
        Response response;
        JSONObject result = new JSONObject();
        try {
            this.getService().getFileStorageManagementService().getActiveFileStorageService().removeFile(new URI(uri));
            result.put((Object)"status", (Object)Response.Status.OK.name());
            response = Response.ok((Object)this.streamingOutput(result)).build();
        }
        catch (NoCorrespondingServiceRegisteredException | InvalidPropertiesException | OperationFailedException | IOException | URISyntaxException e) {
            String errorMessage = "Could not delete file with URI " + uri + ": " + e.getMessage();
            logger.log(Level.WARNING, "Could not delete file with URI " + uri, e);
            result.put((Object)"status", (Object)Response.Status.BAD_REQUEST.name());
            result.put((Object)"message", (Object)errorMessage);
            response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.streamingOutput(result)).build();
        }
        catch (UnauthorizedException e) {
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        return response;
    }
}

