/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.jaxrs.api;

import com.sap.sailing.datamining.SailingPredefinedQueries;
import com.sap.sailing.datamining.data.HasTrackedRaceContext;
import com.sap.sailing.server.gateway.serialization.NotJsonSerializableException;
import com.sap.sailing.shared.server.gateway.jaxrs.AbstractSailingServerResource;
import com.sap.sse.common.Distance;
import com.sap.sse.datamining.DataMiningServer;
import com.sap.sse.datamining.Query;
import com.sap.sse.datamining.StatisticQueryDefinition;
import com.sap.sse.datamining.data.QueryResult;
import com.sap.sse.datamining.shared.DataMiningSession;
import com.sap.sse.datamining.shared.GroupKey;
import com.sap.sse.datamining.shared.dto.StatisticQueryDefinitionDTO;
import com.sap.sse.datamining.shared.impl.CompoundGroupKey;
import com.sap.sse.datamining.shared.impl.GenericGroupKey;
import com.sap.sse.datamining.shared.impl.PredefinedQueryIdentifier;
import com.sap.sse.datamining.shared.impl.UUIDDataMiningSession;
import com.sap.sse.datamining.shared.impl.dto.FunctionDTO;
import com.sap.sse.datamining.shared.impl.dto.ModifiableStatisticQueryDefinitionDTO;
import com.sap.sse.security.SessionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringEscapeUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.osgi.util.tracker.ServiceTracker;

@Path(value="/v1/datamining")
public class DataMiningResource
extends AbstractSailingServerResource {
    private static final Logger logger = Logger.getLogger(DataMiningResource.class.getName());
    private SailingPredefinedQueries predefinedDataMiningQueries;
    private static final Function<Distance, Number> distanceMetersExtractor = distance -> distance.getMeters();
    public static final String QUERY_AVERAGE_SPEED_PER_REGATTA_RACE = "AvgSpeed_Per_Regatta-Race";
    public static final String QUERY_AVERAGE_SPEED_PER_COMPETITOR_LEGTYPE = "AvgSpeed_Per_Competitor-LegType";
    public static final String QUERY_AVERAGE_SPEED_PER_COMPETITOR = "AvgSpeed_Per_Competitor";
    public static final String QUERY_DISTANCE_TRAVELED_PER_COMPETITOR_LEGTYPE = "DistanceTraveled_Per_Competitor-LegType";
    public static final String QUERY_DISTANCE_TRAVELED_PER_COMPETITOR = "DistanceTraveled_Per_Competitor";
    public static final String QUERY_MANEUVERS_PER_COMPETITOR = "Maneuvers_Per_Competitor";

    public List<PredefinedQueryIdentifier> getPredefinedRegattaDataMiningQueries() {
        return this.getPredefinedQueriesByNames(QUERY_AVERAGE_SPEED_PER_COMPETITOR_LEGTYPE, QUERY_AVERAGE_SPEED_PER_COMPETITOR, QUERY_DISTANCE_TRAVELED_PER_COMPETITOR_LEGTYPE, QUERY_DISTANCE_TRAVELED_PER_COMPETITOR, QUERY_MANEUVERS_PER_COMPETITOR);
    }

    public List<PredefinedQueryIdentifier> getPredefinedRaceDataMiningQueries() {
        return this.getPredefinedQueriesByNames(QUERY_AVERAGE_SPEED_PER_REGATTA_RACE, QUERY_AVERAGE_SPEED_PER_COMPETITOR_LEGTYPE, QUERY_AVERAGE_SPEED_PER_COMPETITOR, QUERY_DISTANCE_TRAVELED_PER_COMPETITOR_LEGTYPE, QUERY_DISTANCE_TRAVELED_PER_COMPETITOR, QUERY_MANEUVERS_PER_COMPETITOR);
    }

    public List<PredefinedQueryIdentifier> getPredefinedQueriesByNames(String ... names) {
        ArrayList<PredefinedQueryIdentifier> result = new ArrayList<PredefinedQueryIdentifier>();
        SailingPredefinedQueries predefinedMiningQueries = this.getPredefinedMiningQueries();
        for (PredefinedQueryIdentifier id : predefinedMiningQueries.getQueries().keySet()) {
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (id.getIdentifier().equals(name)) {
                    result.add(id);
                }
                ++n2;
            }
        }
        return result;
    }

    public DataMiningServer getDataMiningServer() {
        ServiceTracker dataMiningServerTracker = (ServiceTracker)this.getServletContext().getAttribute("dataMiningServerTracker");
        return (DataMiningServer)dataMiningServerTracker.getService();
    }

    private Response getBadIdentifierErrorResponse(String identifier) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Couldn't find a predefined query with the identifier '" + identifier + "'.")).type("text/plain").build();
    }

    private Response getBadQueryDefinitionErrorResponse(ModifiableStatisticQueryDefinitionDTO queryDefinitionDTO) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Couldn't create a query for definition '" + StringEscapeUtils.escapeHtml((String)queryDefinitionDTO.toString()) + "'.")).type("text/plain").build();
    }

    private Response getNoDataFoundErrorResponse() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No data found.").type("text/plain").build();
    }

    private Response getNotSerializableErrorResponse(Class<?> type) {
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Can't serialize values of type '" + type.getName() + "'.")).type("text/plain").build();
    }

    private SailingPredefinedQueries getPredefinedMiningQueries() {
        if (this.predefinedDataMiningQueries == null) {
            this.predefinedDataMiningQueries = new SailingPredefinedQueries();
        }
        return this.predefinedDataMiningQueries;
    }

    public Response predefinedQueryIdentifiersToJSON(Iterable<PredefinedQueryIdentifier> identifiers) {
        JSONArray predefinedQueryNames = new JSONArray();
        for (PredefinedQueryIdentifier identifier : identifiers) {
            JSONObject jsonId = new JSONObject();
            jsonId.put((Object)"Identifier", (Object)identifier.getIdentifier());
            jsonId.put((Object)"Description", (Object)identifier.getDescription());
            predefinedQueryNames.add((Object)jsonId);
        }
        return Response.ok((Object)this.streamingOutput(predefinedQueryNames)).header("Content-Type", (Object)"application/json;charset=UTF-8").build();
    }

    public Response avgSpeedPerCompetitorAndLegType(String regattaName) {
        return this.avgSpeedPerCompetitorQuery(QUERY_AVERAGE_SPEED_PER_COMPETITOR_LEGTYPE, regattaName);
    }

    public Response avgSpeedPerCompetitor(String regattaName) {
        return this.avgSpeedPerCompetitorQuery(QUERY_AVERAGE_SPEED_PER_COMPETITOR, regattaName);
    }

    public Response avgSpeedPerCompetitorAndLegType(String regattaName, String raceName) {
        return this.avgSpeedPerCompetitorQuery(QUERY_AVERAGE_SPEED_PER_COMPETITOR_LEGTYPE, regattaName, raceName);
    }

    public Response avgSpeedPerCompetitor(String regattaName, String raceName) {
        return this.avgSpeedPerCompetitorQuery(QUERY_AVERAGE_SPEED_PER_COMPETITOR, regattaName, raceName);
    }

    private Response avgSpeedPerCompetitorQuery(String predefinedQueriesName, String regattaName) {
        return this.avgSpeedPerCompetitorQuery(predefinedQueriesName, regattaName, null);
    }

    private Response avgSpeedPerCompetitorQuery(String predefinedQueriesName, String regattaName, String raceName) {
        Response response;
        ModifiableStatisticQueryDefinitionDTO queryDefinitionDTO = this.getPredefinedQuery(predefinedQueriesName);
        if (queryDefinitionDTO == null) {
            response = this.getBadIdentifierErrorResponse(predefinedQueriesName);
        } else {
            HashMap race_FilterSelection = new HashMap();
            FunctionDTO getRegattaName = new FunctionDTO(true, "getRegatta().getName()", HasTrackedRaceContext.class.getName(), String.class.getName(), new ArrayList(), "", 0);
            HashSet<String> getRegattaName_FilterSelection = new HashSet<String>();
            getRegattaName_FilterSelection.add(regattaName);
            race_FilterSelection.put(getRegattaName, getRegattaName_FilterSelection);
            if (raceName != null) {
                FunctionDTO getRaceName = new FunctionDTO(true, "getRace().getName()", HasTrackedRaceContext.class.getName(), String.class.getName(), new ArrayList(), "", 0);
                HashSet<String> getRaceName_FilterSelection = new HashSet<String>();
                getRaceName_FilterSelection.add(raceName);
                race_FilterSelection.put(getRaceName, getRaceName_FilterSelection);
            }
            queryDefinitionDTO.setFilterSelectionFor(queryDefinitionDTO.getDataRetrieverChainDefinition().getRetrieverLevel(2), race_FilterSelection);
            response = this.runQuery(queryDefinitionDTO, regattaName, raceName, aws -> (Number)aws.getAverage(), "kn", 2);
        }
        return response;
    }

    public Response sumDistanceTraveledPerCompetitor(String regattaName) {
        return this.sumDistanceTraveledPerCompetitorQuery(QUERY_DISTANCE_TRAVELED_PER_COMPETITOR, regattaName);
    }

    public Response sumDistanceTraveledPerCompetitorAndLegType(String regattaName) {
        return this.sumDistanceTraveledPerCompetitorQuery(QUERY_DISTANCE_TRAVELED_PER_COMPETITOR_LEGTYPE, regattaName);
    }

    public Response sumDistanceTraveledPerCompetitor(String regattaName, String raceName) {
        return this.sumDistanceTraveledPerCompetitorQuery(QUERY_DISTANCE_TRAVELED_PER_COMPETITOR, regattaName, raceName);
    }

    public Response sumDistanceTraveledPerCompetitorAndLegType(String regattaName, String raceName) {
        return this.sumDistanceTraveledPerCompetitorQuery(QUERY_DISTANCE_TRAVELED_PER_COMPETITOR_LEGTYPE, regattaName, raceName);
    }

    private Response sumDistanceTraveledPerCompetitorQuery(String predefinedQueriesName, String regattaName) {
        return this.sumDistanceTraveledPerCompetitorQuery(predefinedQueriesName, regattaName, null);
    }

    private Response sumDistanceTraveledPerCompetitorQuery(String predefinedQueriesName, String regattaName, String raceName) {
        Response response;
        ModifiableStatisticQueryDefinitionDTO queryDefinitionDTO = this.getPredefinedQuery(predefinedQueriesName);
        if (queryDefinitionDTO == null) {
            response = this.getBadIdentifierErrorResponse(predefinedQueriesName);
        } else {
            HashMap race_FilterSelection = new HashMap();
            FunctionDTO getRegattaName = new FunctionDTO(true, "getRegatta().getName()", HasTrackedRaceContext.class.getName(), String.class.getName(), new ArrayList(), "", 0);
            HashSet<String> getRegattaName_FilterSelection = new HashSet<String>();
            getRegattaName_FilterSelection.add(regattaName);
            race_FilterSelection.put(getRegattaName, getRegattaName_FilterSelection);
            if (raceName != null) {
                FunctionDTO getRaceName = new FunctionDTO(true, "getRace().getName()", HasTrackedRaceContext.class.getName(), String.class.getName(), new ArrayList(), "", 0);
                HashSet<String> getRaceName_FilterSelection = new HashSet<String>();
                getRaceName_FilterSelection.add(raceName);
                race_FilterSelection.put(getRaceName, getRaceName_FilterSelection);
            }
            queryDefinitionDTO.setFilterSelectionFor(queryDefinitionDTO.getDataRetrieverChainDefinition().getRetrieverLevel(2), race_FilterSelection);
            response = this.runQuery(queryDefinitionDTO, regattaName, raceName, distanceMetersExtractor, "m", 2);
        }
        return response;
    }

    public Response sumManeuversPerCompetitor(String regattaName) {
        return this.sumManeuversPerCompetitorQuery(QUERY_MANEUVERS_PER_COMPETITOR, regattaName);
    }

    public Response sumManeuversPerCompetitor(String regattaName, String raceName) {
        return this.sumManeuversPerCompetitorQuery(QUERY_MANEUVERS_PER_COMPETITOR, regattaName, raceName);
    }

    private Response sumManeuversPerCompetitorQuery(String predefinedQueriesName, String regattaName) {
        return this.sumManeuversPerCompetitorQuery(predefinedQueriesName, regattaName, null);
    }

    private Response sumManeuversPerCompetitorQuery(String predefinedQueriesName, String regattaName, String raceName) {
        Response response;
        ModifiableStatisticQueryDefinitionDTO queryDefinitionDTO = this.getPredefinedQuery(predefinedQueriesName);
        if (queryDefinitionDTO == null) {
            response = this.getBadIdentifierErrorResponse(predefinedQueriesName);
        } else {
            HashMap race_FilterSelection = new HashMap();
            FunctionDTO getRegattaName = new FunctionDTO(true, "getRegatta().getName()", HasTrackedRaceContext.class.getName(), String.class.getName(), new ArrayList(), "", 0);
            HashSet<String> getRegattaName_FilterSelection = new HashSet<String>();
            getRegattaName_FilterSelection.add(regattaName);
            race_FilterSelection.put(getRegattaName, getRegattaName_FilterSelection);
            if (raceName != null) {
                FunctionDTO getRaceName = new FunctionDTO(true, "getRace().getName()", HasTrackedRaceContext.class.getName(), String.class.getName(), new ArrayList(), "", 0);
                HashSet<String> getRaceName_FilterSelection = new HashSet<String>();
                getRaceName_FilterSelection.add(raceName);
                race_FilterSelection.put(getRaceName, getRaceName_FilterSelection);
            }
            queryDefinitionDTO.setFilterSelectionFor(queryDefinitionDTO.getDataRetrieverChainDefinition().getRetrieverLevel(2), race_FilterSelection);
            response = this.runQuery(queryDefinitionDTO, regattaName, raceName, null, null, 0);
        }
        return response;
    }

    private ModifiableStatisticQueryDefinitionDTO getPredefinedQuery(String identifier) {
        DataMiningServer dataMiningServer = this.getDataMiningServer();
        PredefinedQueryIdentifier queryIdentifier = new PredefinedQueryIdentifier(identifier, "");
        return dataMiningServer.getPredefinedQueryDefinitionDTO(queryIdentifier);
    }

    private <ResultType> Response runQuery(ModifiableStatisticQueryDefinitionDTO queryDefinitionDTO, String regattaName, String raceName, Function<ResultType, Number> numberExtractor, String resultUnit, int resultPlaces) {
        Response response;
        Query query;
        DataMiningServer dataMiningServer = this.getDataMiningServer();
        StatisticQueryDefinition queryDefinition = dataMiningServer.getQueryDefinitionForDTO((StatisticQueryDefinitionDTO)queryDefinitionDTO);
        Query query2 = query = queryDefinition == null ? null : dataMiningServer.createQuery(queryDefinition);
        if (query == null) {
            response = this.getBadQueryDefinitionErrorResponse(queryDefinitionDTO);
        } else {
            UUIDDataMiningSession session = new UUIDDataMiningSession(UUID.randomUUID());
            long requestTimepoint = System.currentTimeMillis();
            logger.info("Handing query " + query + " to server for processing on behalf of user " + SessionUtils.getPrincipal());
            QueryResult result = dataMiningServer.runNewQueryAndAbortPreviousQueries((DataMiningSession)session, query);
            logger.info("Obtained result for query " + query + " from server on behalf of user " + SessionUtils.getPrincipal());
            if (result == null || result.isEmpty()) {
                response = this.getNoDataFoundErrorResponse();
            } else {
                try {
                    JSONObject jsonResult = new JSONObject();
                    jsonResult.put((Object)"state", (Object)result.getState());
                    jsonResult.put((Object)"requestTimepoint", (Object)requestTimepoint);
                    jsonResult.put((Object)"calculationDuration-s", (Object)DataMiningResource.roundDouble((Double)result.getCalculationTimeInSeconds(), (int)2));
                    jsonResult.put((Object)"description", (Object)result.getResultSignifier());
                    if (regattaName != null && !regattaName.isEmpty()) {
                        jsonResult.put((Object)"regatta", (Object)regattaName);
                    }
                    if (raceName != null && !raceName.isEmpty()) {
                        jsonResult.put((Object)"race", (Object)raceName);
                    }
                    jsonResult.put((Object)"resultUnit", (Object)(resultUnit != null && !resultUnit.isEmpty() ? resultUnit : "None"));
                    jsonResult.put((Object)"results", (Object)this.resultValuesToJSON(result, numberExtractor, resultPlaces));
                    response = Response.ok((Object)this.streamingOutput(jsonResult)).header("Content-Type", (Object)"application/json;charset=UTF-8").build();
                }
                catch (NotJsonSerializableException e) {
                    response = this.getNotSerializableErrorResponse(e.getNotSerializableClass());
                }
            }
        }
        return response;
    }

    private <ResultType> JSONArray resultValuesToJSON(QueryResult<ResultType> result, Function<ResultType, Number> numberExtractor, int places) throws NotJsonSerializableException {
        if (!Number.class.isAssignableFrom(result.getResultType()) && numberExtractor == null) {
            throw new NotJsonSerializableException(result.getResultType());
        }
        Map values = result.getResults();
        JSONArray jsonResultValues = new JSONArray();
        for (GroupKey groupKey : values.keySet()) {
            JSONObject jsonResultEntry = new JSONObject();
            jsonResultEntry.put((Object)"groupKey", (Object)this.groupKeyToJSON(groupKey));
            Number value = numberExtractor != null ? (Number)numberExtractor.apply(values.get(groupKey)) : (Number)((Number)values.get(groupKey));
            jsonResultEntry.put((Object)"value", (Object)DataMiningResource.roundDouble((Double)value.doubleValue(), (int)places));
            jsonResultValues.add((Object)jsonResultEntry);
        }
        return jsonResultValues;
    }

    private JSONArray groupKeyToJSON(GroupKey groupKey) throws NotJsonSerializableException {
        JSONArray jsonResultEntryGroupKeys = new JSONArray();
        if (groupKey instanceof GenericGroupKey) {
            jsonResultEntryGroupKeys.add(this.simpleGroupKeyToJSON(groupKey));
        } else if (groupKey instanceof CompoundGroupKey) {
            for (GroupKey key : groupKey.getKeys()) {
                jsonResultEntryGroupKeys.add((Object)this.groupKeyToJSON(key));
            }
        } else {
            throw new NotJsonSerializableException(groupKey.getClass());
        }
        return jsonResultEntryGroupKeys;
    }

    private Object simpleGroupKeyToJSON(GroupKey groupKey) {
        return groupKey.asString();
    }
}

