/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.impl.rc;

import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.base.CourseArea;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.racegroup.RaceGroup;
import com.sap.sailing.domain.leaderboard.FlexibleLeaderboard;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboard;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboardWithEliminations;
import com.sap.sailing.server.gateway.AbstractJsonHttpServlet;
import com.sap.sailing.server.gateway.impl.rc.RaceGroupFactory;
import com.sap.sailing.server.gateway.serialization.impl.BoatClassJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.ColorJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.CompetitorJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.FleetJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.PositionJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.RegattaConfigurationJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.TargetTimeInfoSerializer;
import com.sap.sailing.server.gateway.serialization.impl.WindJsonSerializer;
import com.sap.sailing.server.gateway.serialization.racegroup.impl.RaceCellJsonSerializer;
import com.sap.sailing.server.gateway.serialization.racegroup.impl.RaceGroupJsonSerializer;
import com.sap.sailing.server.gateway.serialization.racegroup.impl.RaceRowJsonSerializer;
import com.sap.sailing.server.gateway.serialization.racegroup.impl.RaceRowsOfSeriesWithRowsSerializer;
import com.sap.sailing.server.gateway.serialization.racegroup.impl.SeriesWithRowsJsonSerializer;
import com.sap.sailing.server.gateway.serialization.racegroup.impl.SeriesWithRowsOfRaceGroupSerializer;
import com.sap.sailing.server.gateway.serialization.racelog.impl.RaceLogEventSerializer;
import com.sap.sailing.server.gateway.serialization.racelog.impl.RaceLogSerializer;
import com.sap.sse.common.Util;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.shared.json.ExtensionJsonSerializer;
import com.sap.sse.shared.json.JsonSerializer;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashSet;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.json.simple.JSONArray;

public class RaceGroupJsonExportServlet
extends AbstractJsonHttpServlet {
    private static final long serialVersionUID = 4510175441769759252L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String courseAreaFilter = request.getParameter("courseArea");
        if (courseAreaFilter == null) {
            response.sendError(400, "Need to set a course area filter.");
            return;
        }
        UUID courseAreaId = this.toUUID(courseAreaFilter);
        if (courseAreaId == null) {
            response.sendError(400, "Course area filter must be valid UUID.");
            return;
        }
        CourseArea filterCourseArea = this.getService().getCourseArea((Serializable)courseAreaId);
        if (filterCourseArea == null) {
            response.sendError(404, "No course area found with given UUID.");
            return;
        }
        String clientUuidAsString = request.getParameter("clientuuid");
        UUID clientUuid = clientUuidAsString == null ? null : UUID.fromString(clientUuidAsString);
        JsonSerializer<RaceGroup> serializer = RaceGroupJsonExportServlet.createSerializer(clientUuid);
        JSONArray result = new JSONArray();
        RaceGroupFactory raceGroupFactory = new RaceGroupFactory();
        HashSet<Regatta> regattasForWhichRegattaLeaderboardsWereAdded = new HashSet<Regatta>();
        for (Leaderboard leaderboard : this.getService().getLeaderboards().values()) {
            if (!Util.contains((Iterable)leaderboard.getCourseAreas(), (Object)filterCourseArea)) continue;
            SecurityUtils.getSubject().checkPermission(leaderboard.getIdentifier().getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.READ));
            if (leaderboard instanceof RegattaLeaderboard && !(leaderboard instanceof RegattaLeaderboardWithEliminations)) {
                result.add((Object)serializer.serialize((Object)raceGroupFactory.convert((RegattaLeaderboard)leaderboard)));
                Regatta regatta = ((RegattaLeaderboard)leaderboard).getRegatta();
                SecurityUtils.getSubject().checkPermission(regatta.getIdentifier().getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.READ));
                regattasForWhichRegattaLeaderboardsWereAdded.add(regatta);
                continue;
            }
            if (!(leaderboard instanceof FlexibleLeaderboard)) continue;
            result.add((Object)serializer.serialize((Object)raceGroupFactory.convert((FlexibleLeaderboard)leaderboard)));
        }
        for (Leaderboard leaderboard : this.getService().getLeaderboards().values()) {
            if (!(leaderboard instanceof RegattaLeaderboardWithEliminations) || !Util.contains((Iterable)leaderboard.getCourseAreas(), (Object)filterCourseArea) || regattasForWhichRegattaLeaderboardsWereAdded.contains(((RegattaLeaderboardWithEliminations)leaderboard).getRegatta())) continue;
            result.add((Object)serializer.serialize((Object)raceGroupFactory.convert((RegattaLeaderboard)((RegattaLeaderboardWithEliminations)leaderboard))));
        }
        this.setJsonResponseHeader(response);
        result.writeJSONString((Writer)response.getWriter());
    }

    private UUID toUUID(String value) {
        try {
            return UUID.fromString(value);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    private static JsonSerializer<RaceGroup> createSerializer(UUID clientUuid) {
        return new RaceGroupJsonSerializer((JsonSerializer)new BoatClassJsonSerializer(), (JsonSerializer)RegattaConfigurationJsonSerializer.create(), (ExtensionJsonSerializer)new SeriesWithRowsOfRaceGroupSerializer((JsonSerializer)new SeriesWithRowsJsonSerializer((ExtensionJsonSerializer)new RaceRowsOfSeriesWithRowsSerializer((JsonSerializer)new RaceRowJsonSerializer((JsonSerializer)new FleetJsonSerializer((JsonSerializer)new ColorJsonSerializer()), (JsonSerializer)new RaceCellJsonSerializer(RaceGroupJsonExportServlet.createRaceLogSerializer(clientUuid), (JsonSerializer)new TargetTimeInfoSerializer((JsonSerializer)new WindJsonSerializer((JsonSerializer)new PositionJsonSerializer()))))))));
    }

    private static JsonSerializer<RaceLog> createRaceLogSerializer(UUID clientUuid) {
        return new RaceLogSerializer(RaceLogEventSerializer.create((JsonSerializer)CompetitorJsonSerializer.create()), clientUuid);
    }
}

