/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.impl.rc;

import com.sap.sailing.domain.base.ControlPoint;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.server.gateway.AbstractJsonHttpServlet;
import com.sap.sailing.server.gateway.serialization.coursedata.impl.MarkJsonSerializer;
import com.sap.sailing.server.interfaces.RacingEventService;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.simple.JSONArray;

public class MarksJsonExportServlet
extends AbstractJsonHttpServlet {
    private static final long serialVersionUID = 4510175441769759252L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String leaderboardName = request.getParameter("leaderboard");
        if (leaderboardName == null) {
            response.sendError(400, String.format("Missing parameter '%s'.", "leaderboard"));
            return;
        }
        String raceColumnName = request.getParameter("race_column");
        if (raceColumnName == null) {
            response.sendError(400, String.format("Missing parameter '%s'.", "race_column"));
            return;
        }
        String fleetName = request.getParameter("fleet");
        if (fleetName == null) {
            response.sendError(400, String.format("Missing parameter '%s'.", "fleet"));
            return;
        }
        RacingEventService service = this.getService();
        Leaderboard leaderboard = service.getLeaderboardByName(leaderboardName);
        if (leaderboard == null) {
            response.sendError(404, "No such leaderboard found.");
            return;
        }
        RaceColumn raceColumn = leaderboard.getRaceColumnByName(raceColumnName);
        if (raceColumn == null) {
            response.sendError(404, "No such race column found.");
            return;
        }
        Fleet fleet = raceColumn.getFleetByName(fleetName);
        if (fleet == null) {
            response.sendError(404, "No such fleet found.");
            return;
        }
        JSONArray result = new JSONArray();
        Iterable marks = raceColumn.getAvailableMarks(fleet);
        MarkJsonSerializer serializer = new MarkJsonSerializer();
        for (Mark mark : marks) {
            result.add((Object)serializer.serialize((ControlPoint)mark));
        }
        this.setJsonResponseHeader(response);
        result.writeJSONString((Writer)response.getWriter());
    }
}

