/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.impl.rc;

import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.server.gateway.AbstractJsonHttpServlet;
import com.sap.sailing.server.gateway.serialization.coursedata.impl.MarkJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.PositionJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.PositionedMarkJsonSerializer;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.shared.json.JsonSerializer;
import java.io.IOException;
import java.io.Writer;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.json.simple.JSONArray;

public class MarkPositionsJsonExportServlet
extends AbstractJsonHttpServlet {
    private static final long serialVersionUID = -5489857104922281761L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String leaderboardName = request.getParameter("leaderboard");
        if (leaderboardName == null) {
            response.sendError(400, String.format("Missing parameter '%s'.", "leaderboard"));
            return;
        }
        String raceColumnName = request.getParameter("race_column");
        if (raceColumnName == null) {
            response.sendError(400, String.format("Missing parameter '%s'.", "race_column"));
            return;
        }
        String fleetName = request.getParameter("fleet");
        if (fleetName == null) {
            response.sendError(400, String.format("Missing parameter '%s'.", "fleet"));
            return;
        }
        RacingEventService service = this.getService();
        Leaderboard leaderboard = service.getLeaderboardByName(leaderboardName);
        if (leaderboard == null) {
            response.sendError(404, "No such leaderboard found.");
            return;
        }
        SecurityUtils.getSubject().checkPermission(leaderboard.getIdentifier().getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.READ));
        RaceColumn raceColumn = leaderboard.getRaceColumnByName(raceColumnName);
        if (raceColumn == null) {
            response.sendError(404, "No such race column found.");
            return;
        }
        Fleet fleet = raceColumn.getFleetByName(fleetName);
        if (fleet == null) {
            response.sendError(404, "No such fleet found.");
            return;
        }
        TrackedRace trackedRace = raceColumn.getTrackedRace(fleet);
        JSONArray result = new JSONArray();
        if (trackedRace != null) {
            SecurityUtils.getSubject().checkPermission(trackedRace.getIdentifier().getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.READ));
            MarkJsonSerializer markSerializer = new MarkJsonSerializer();
            PositionJsonSerializer positionSerializer = new PositionJsonSerializer();
            PositionedMarkJsonSerializer positionedMarkSerializer = new PositionedMarkJsonSerializer((JsonSerializer)markSerializer, (JsonSerializer)positionSerializer);
            for (Mark mark : trackedRace.getMarks()) {
                if (this.toUUID(mark.getId().toString()) == null) continue;
                Position position = trackedRace.getOrCreateTrack(mark).getEstimatedPosition(MillisecondsTimePoint.now(), false);
                result.add((Object)positionedMarkSerializer.serialize(new Util.Pair((Object)mark, (Object)position)));
            }
        }
        this.setJsonResponseHeader(response);
        result.writeJSONString((Writer)response.getWriter());
    }

    private boolean isMarkInCourseArea(Position courseAreaCenterPosition, Distance courseAreaRadius, Position position) {
        return position.getDistance(courseAreaCenterPosition).compareTo((Object)courseAreaRadius) < 0;
    }

    private UUID toUUID(String value) {
        try {
            return UUID.fromString(value);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }
}

