/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.impl.rc;

import com.sap.sailing.domain.abstractlog.AbstractLogEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.RaceLogEvent;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.SharedDomainFactory;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.server.gateway.AbstractJsonHttpServlet;
import com.sap.sailing.server.gateway.deserialization.impl.DeviceIdentifierJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.Helpers;
import com.sap.sailing.server.gateway.deserialization.racelog.impl.RaceLogEventDeserializer;
import com.sap.sailing.server.gateway.serialization.impl.CompetitorJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.DeviceIdentifierJsonSerializer;
import com.sap.sailing.server.gateway.serialization.racelog.impl.RaceLogEventSerializer;
import com.sap.sailing.server.gateway.serialization.racelog.tracking.DeviceIdentifierJsonHandler;
import com.sap.sailing.server.gateway.serialization.racelog.tracking.impl.PlaceHolderDeviceIdentifierJsonHandler;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sse.common.TypeBasedServiceFinder;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.shared.json.JsonDeserializer;
import com.sap.sse.shared.json.JsonSerializer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.shiro.SecurityUtils;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;

public class AddEntryToRaceLogJsonPostServlet
extends AbstractJsonHttpServlet {
    private static final long serialVersionUID = 7704668926551060433L;
    private static final Logger logger = Logger.getLogger(AddEntryToRaceLogJsonPostServlet.class.getName());
    private TypeBasedServiceFinder<DeviceIdentifierJsonHandler> deviceJsonServiceFinder;

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.deviceJsonServiceFinder = this.getServiceFinderFactory().createServiceFinder(DeviceIdentifierJsonHandler.class);
        this.deviceJsonServiceFinder.setFallbackService((Object)new PlaceHolderDeviceIdentifierJsonHandler());
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String line;
        String clientUuidAsString = request.getParameter("clientuuid");
        UUID clientUuid = clientUuidAsString == null ? null : UUID.fromString(clientUuidAsString);
        String leaderboardName = request.getParameter("leaderboard");
        if (leaderboardName == null) {
            response.sendError(400, String.format("Missing parameter '%s'.", "leaderboard"));
            return;
        }
        String raceColumnName = request.getParameter("race_column");
        if (raceColumnName == null) {
            response.sendError(400, String.format("Missing parameter '%s'.", "race_column"));
            return;
        }
        String fleetName = request.getParameter("fleet");
        if (fleetName == null) {
            response.sendError(400, String.format("Missing parameter '%s'.", "fleet"));
            return;
        }
        logger.fine("Post issued for race log of " + leaderboardName + ", " + raceColumnName + ", " + fleetName);
        RacingEventService service = this.getService();
        Leaderboard leaderboard = service.getLeaderboardByName(leaderboardName);
        if (leaderboard == null) {
            response.sendError(404, "Leaderboard " + StringEscapeUtils.escapeHtml((String)leaderboardName) + " not found.");
            return;
        }
        SecurityUtils.getSubject().checkPermission(leaderboard.getIdentifier().getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.UPDATE));
        RaceColumn raceColumn = leaderboard.getRaceColumnByName(raceColumnName);
        if (raceColumn == null) {
            response.sendError(404, "Race column " + StringEscapeUtils.escapeHtml((String)raceColumnName) + " not found.");
            return;
        }
        Fleet fleet = raceColumn.getFleetByName(fleetName);
        if (fleet == null) {
            response.sendError(404, "Fleet " + StringEscapeUtils.escapeHtml((String)fleetName) + " not found.");
            return;
        }
        RaceLog raceLog = raceColumn.getRaceLog(fleet);
        if (raceLog == null) {
            response.sendError(404, "Race Log not found.");
            return;
        }
        BufferedReader reader = request.getReader();
        StringBuilder requestBody = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            requestBody.append(line);
        }
        reader.close();
        if (requestBody.length() == 0) {
            logger.fine("Client wants to receive server events");
            this.sendResponse(response, clientUuid, raceLog, raceLog.getEventsToDeliver(clientUuid));
        } else {
            try {
                logger.fine("Client wants to add a race log event");
                RaceLogEventDeserializer deserializer = RaceLogEventDeserializer.create((SharedDomainFactory)this.getService().getBaseDomainFactory(), (JsonDeserializer)new DeviceIdentifierJsonDeserializer(this.deviceJsonServiceFinder));
                Object requestObject = JSONValue.parseWithException((String)requestBody.toString());
                JSONObject requestJsonObject = Helpers.toJSONObjectSafe((Object)requestObject);
                logger.fine("JSON requestObject is: " + requestObject.toString());
                RaceLogEvent logEvent = null;
                try {
                    logEvent = (RaceLogEvent)deserializer.deserialize(requestJsonObject);
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "De-Serialization failed: " + ex.getMessage(), ex);
                    throw ex;
                }
                logger.fine("JSON is deserialized to a RaceLogEvent");
                Iterable eventsToSendBackToClient = raceLog.add((AbstractLogEvent)logEvent, clientUuid);
                this.sendResponse(response, clientUuid, raceLog, eventsToSendBackToClient);
            }
            catch (ParseException pe) {
                response.sendError(400, String.format("Invalid JSON in request body:\n%s", new Object[]{pe}));
                logger.warning(String.format("Exception while parsing post request: %s", pe.toString()));
            }
        }
    }

    protected void sendResponse(HttpServletResponse response, UUID clientUuid, RaceLog raceLog, Iterable<RaceLogEvent> eventsToSendBackToClient) throws IOException {
        JsonSerializer serializer = RaceLogEventSerializer.create((JsonSerializer)new CompetitorJsonSerializer(), (JsonSerializer)new DeviceIdentifierJsonSerializer(this.deviceJsonServiceFinder));
        PrintWriter writer = response.getWriter();
        boolean first = true;
        ((Writer)writer).write(91);
        for (RaceLogEvent eventToSendBackToClient : eventsToSendBackToClient) {
            if (first) {
                first = false;
            } else {
                ((Writer)writer).write(44);
            }
            serializer.serialize((Object)eventToSendBackToClient).writeJSONString((Writer)writer);
        }
        ((Writer)writer).write(93);
    }
}

