/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.impl;

import com.sap.sailing.server.gateway.impl.SailingServerImpl;
import com.sap.sailing.server.gateway.interfaces.SailingServer;
import com.sap.sailing.server.gateway.interfaces.SailingServerFactory;
import com.sap.sse.replication.FullyInitializedReplicableTracker;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.impl.User;
import com.sap.sse.security.util.RemoteServerUtil;
import java.net.URL;
import java.util.logging.Logger;

public class SailingServerFactoryImpl
implements SailingServerFactory {
    private static final Logger logger = Logger.getLogger(SailingServerFactoryImpl.class.getName());
    private final FullyInitializedReplicableTracker<SecurityService> securityServiceTracker;

    public SailingServerFactoryImpl(FullyInitializedReplicableTracker<SecurityService> securityServiceTracker) {
        this.securityServiceTracker = securityServiceTracker;
    }

    public SailingServer getSailingServer(URL baseUrl) {
        String bearerToken;
        try {
            SecurityService securityService = (SecurityService)this.securityServiceTracker.getInitializedService(1000L);
            User user = securityService.getCurrentUser();
            bearerToken = user != null ? securityService.getAccessToken(user.getName()) : null;
        }
        catch (InterruptedException e) {
            logger.warning("Interrupted while trying to obtain security service; continuing without it.");
            bearerToken = null;
        }
        return new SailingServerImpl(baseUrl, bearerToken);
    }

    public SailingServer getSailingServer(URL baseUrl, String bearerToken) {
        Object result = bearerToken == null ? this.getSailingServer(baseUrl) : new SailingServerImpl(baseUrl, bearerToken);
        return result;
    }

    public SailingServer getSailingServer(URL baseUrl, String username, String password) {
        return this.getSailingServer(baseUrl, RemoteServerUtil.resolveBearerTokenForRemoteServer((String)baseUrl.toString(), (String)username, (String)password));
    }
}

