/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.impl;

import com.sap.sailing.expeditionconnector.ExpeditionListener;
import com.sap.sailing.expeditionconnector.ExpeditionMessage;
import com.sap.sailing.expeditionconnector.ExpeditionTrackerFactory;
import com.sap.sailing.expeditionconnector.UDPExpeditionReceiver;
import com.sap.sailing.server.gateway.AbstractHttpPostServlet;
import com.sap.sailing.server.gateway.HttpMessageSenderServletRequestHandler;
import com.sap.sailing.udpconnector.UDPMessageListener;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.SocketException;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class ExpeditionThroughHttpPostServletHandler
extends HttpMessageSenderServletRequestHandler {
    private static final Logger logger = Logger.getLogger(ExpeditionThroughHttpPostServletHandler.class.getName());
    private final ExpeditionListener listener = new ExpeditionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void received(ExpeditionMessage message) {
            PrintWriter printWriter = ExpeditionThroughHttpPostServletHandler.this.getWriter();
            synchronized (printWriter) {
                ExpeditionThroughHttpPostServletHandler.this.send(ExpeditionThroughHttpPostServletHandler.this.getWriter(), message.getOriginalMessage().getBytes());
            }
        }
    };

    public ExpeditionThroughHttpPostServletHandler(HttpServletResponse resp, AbstractHttpPostServlet owner) throws IOException {
        super(resp, owner);
        this.addExpeditionListener(this.listener, false);
    }

    private void addExpeditionListener(ExpeditionListener listener, boolean validMessagesOnly) throws SocketException {
        UDPExpeditionReceiver receiver = ((ExpeditionTrackerFactory)this.createExpeditionTrackerFactory(this.getContext()).getService()).getOrCreateWindReceiverOnDefaultPort();
        receiver.addListener((UDPMessageListener)listener, validMessagesOnly);
    }

    private ServiceTracker<ExpeditionTrackerFactory, ExpeditionTrackerFactory> createExpeditionTrackerFactory(BundleContext context) {
        ServiceTracker result = new ServiceTracker(this.getContext(), ExpeditionTrackerFactory.class.getName(), null);
        result.open();
        return result;
    }

    @Override
    protected void stop() {
        try {
            ExpeditionTrackerFactory windTrackerFactory = (ExpeditionTrackerFactory)this.createExpeditionTrackerFactory(this.getContext()).getService();
            UDPExpeditionReceiver receiver = windTrackerFactory.getOrCreateWindReceiverOnDefaultPort();
            receiver.removeListener((UDPMessageListener)this.listener);
        }
        catch (SocketException e) {
            logger.info("Failed to remove expedition listener " + this.listener + "; exception while trying to retrieve wind receiver: " + e.getMessage());
        }
        super.stop();
    }
}

