/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway;

import com.sap.sailing.server.gateway.AbstractJsonHttpServlet;
import com.sap.sailing.server.gateway.HttpExceptionWithMessage;
import com.sap.sailing.server.gateway.deserialization.impl.Helpers;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonDeserializer;
import com.sap.sse.shared.json.JsonSerializer;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;

public abstract class AbstractJsonPostServlet<RequestT, ResponseT>
extends AbstractJsonHttpServlet {
    private static final long serialVersionUID = 8474205424939759851L;
    private final List<String> requiredParameters;
    private final ArrayList<String> optionalParameters;
    protected final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public abstract JsonDeserializer<RequestT> getRequestDeserializer();

    public abstract JsonSerializer<ResponseT> getResponseSerializer();

    public AbstractJsonPostServlet(List<String> requiredParameters, List<String> optionalParameters) {
        this.requiredParameters = new ArrayList<String>(requiredParameters);
        this.optionalParameters = new ArrayList<String>(optionalParameters);
    }

    public AbstractJsonPostServlet(List<String> requiredParameters) {
        this(requiredParameters, Collections.emptyList());
    }

    public AbstractJsonPostServlet() {
        this(Collections.emptyList(), Collections.emptyList());
    }

    public abstract ResponseT process(Map<String, String> var1, RequestT var2) throws HttpExceptionWithMessage;

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HashMap<String, String> parameterValues = new HashMap<String, String>();
        for (String name : this.requiredParameters) {
            String value = req.getParameter(name);
            if (value == null) {
                resp.sendError(400, String.format("Missing parameter '%s'.", name));
                return;
            }
            parameterValues.put(name, value);
        }
        for (String name : this.optionalParameters) {
            parameterValues.put(name, req.getParameter(name));
        }
        Object domainObject = null;
        if (this.getRequestDeserializer() != null) {
            try {
                this.logger.fine("Post issued to " + ((Object)((Object)this)).getClass().getName());
                Object requestBody = JSONValue.parseWithException((Reader)req.getReader());
                JSONObject requestObject = Helpers.toJSONObjectSafe((Object)requestBody);
                this.logger.fine("JSON requestObject is: " + requestObject.toString());
                domainObject = this.getRequestDeserializer().deserialize(requestObject);
            }
            catch (JsonDeserializationException | ParseException e) {
                resp.sendError(400, String.format("Invalid JSON in request body:\n%s", e));
                this.logger.warning(String.format("Exception while parsing post request:\n%s", e.toString()));
                e.printStackTrace();
                return;
            }
        }
        Object responseObject = null;
        try {
            responseObject = this.process(parameterValues, domainObject);
        }
        catch (HttpExceptionWithMessage e) {
            e.sendError(resp);
            this.logger.warning(String.format("Exception while processing post request:\n%s", e.toString()));
            e.printStackTrace();
            return;
        }
        this.setJsonResponseHeader(resp);
        resp.setStatus(200);
        if (this.getResponseSerializer() != null && responseObject != null) {
            this.getResponseSerializer().serialize(responseObject).writeJSONString((Writer)resp.getWriter());
            this.logger.fine(String.format("Created %s as result of gateway request", responseObject.toString()));
        }
    }
}

