/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.mongodb;

import com.mongodb.ConnectionString;
import com.mongodb.ServerAddress;
import com.sap.sse.mongodb.MongoDBService;
import com.sap.sse.mongodb.internal.MongoDBServiceImpl;
import org.bson.UuidRepresentation;

public class MongoDBConfiguration {
    static final String MONGO_PORT = "mongo.port";
    static final String MONGO_HOSTNAME = "mongo.host";
    static final String MONGO_DB_NAME = "mongo.dbName";
    static final String MONGO_URI = "mongo.uri";
    private static String DEFAULT_DB_NAME = "winddb";
    private static String DEFAULT_TEST_DB_NAME = "winddbTest";
    private final ConnectionString mongoClientURI;

    public static MongoDBConfiguration getDefaultConfiguration() {
        return MongoDBConfiguration.getDefaultConfiguration(DEFAULT_DB_NAME);
    }

    private static MongoDBConfiguration getDefaultConfiguration(String dbName) {
        MongoDBConfiguration result;
        if (System.getProperty(MONGO_URI) != null) {
            result = new MongoDBConfiguration(new ConnectionString(System.getProperty(MONGO_URI)));
        } else {
            String defaultHostName = "127.0.0.1";
            if (System.getProperty(MONGO_HOSTNAME) != null) {
                defaultHostName = System.getProperty(MONGO_HOSTNAME);
            } else if (System.getenv("MONGODB_HOST") != null) {
                defaultHostName = System.getenv("MONGODB_HOST");
            }
            String defaultDatabaseName = System.getProperty(MONGO_DB_NAME, dbName);
            result = System.getProperty(MONGO_PORT) != null ? new MongoDBConfiguration(defaultHostName, Integer.valueOf(System.getProperty(MONGO_PORT).trim()), defaultDatabaseName) : (System.getenv("MONGODB_PORT") != null ? new MongoDBConfiguration(defaultHostName, Integer.valueOf(System.getenv("MONGODB_PORT").trim()), defaultDatabaseName) : new MongoDBConfiguration(defaultHostName, defaultDatabaseName));
        }
        return result;
    }

    public static MongoDBConfiguration getDefaultTestConfiguration() {
        return MongoDBConfiguration.getDefaultConfiguration(DEFAULT_TEST_DB_NAME);
    }

    public MongoDBConfiguration(String mongoClientURIAsString) {
        this.mongoClientURI = MongoDBConfiguration.setUuidRepresentationToJavaLegacy(new ConnectionString(mongoClientURIAsString));
    }

    public MongoDBConfiguration(ConnectionString mongoClientURI) {
        this.mongoClientURI = MongoDBConfiguration.setUuidRepresentationToJavaLegacy(mongoClientURI);
    }

    public MongoDBConfiguration(String hostName, String databaseName) {
        this.mongoClientURI = MongoDBConfiguration.setUuidRepresentationToJavaLegacy(new ConnectionString("mongodb://" + hostName + "/" + databaseName));
    }

    public MongoDBConfiguration(String hostName, int port, String databaseName) {
        this.mongoClientURI = MongoDBConfiguration.setUuidRepresentationToJavaLegacy(new ConnectionString("mongodb://" + hostName + ":" + port + "/" + databaseName));
    }

    private static ConnectionString setUuidRepresentationToJavaLegacy(ConnectionString cs) {
        ConnectionString result;
        if (cs.getUuidRepresentation() == UuidRepresentation.JAVA_LEGACY) {
            result = cs;
        } else {
            String uuidRepresentationParam = "uuidRepresentation=javaLegacy";
            String separator = cs.getConnectionString().contains("?") ? "&" : "?";
            result = new ConnectionString(String.valueOf(cs.getConnectionString()) + separator + "uuidRepresentation=javaLegacy");
        }
        return result;
    }

    public MongoDBService getService() {
        return new MongoDBServiceImpl(this);
    }

    public ConnectionString getMongoClientURI() {
        return this.mongoClientURI;
    }

    public String getDatabaseName() {
        return this.getMongoClientURI().getDatabase();
    }

    public String getHostname() {
        return ((String)this.getMongoClientURI().getHosts().get(0)).split(":")[0];
    }

    public int getPort() {
        int result = ServerAddress.defaultPort();
        if (!this.getMongoClientURI().getHosts().isEmpty() && ((String)this.getMongoClientURI().getHosts().get(0)).split(":").length > 1) {
            result = Integer.valueOf(((String)this.getMongoClientURI().getHosts().get(0)).split(":")[1]);
        }
        return result;
    }

    public String toString() {
        return this.mongoClientURI.toString();
    }
}

