/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.trackfiles.impl;

import com.sap.sailing.domain.shared.tracking.Track;
import com.sap.sailing.server.trackfiles.impl.IterableLocker;
import com.sap.sailing.server.trackfiles.impl.TrackReader;
import com.sap.sse.common.Timed;

class TrackReaderImpl<E, T extends Timed>
implements TrackReader<E, T>,
IterableLocker {
    private final Track<T> track;

    TrackReaderImpl(Track<T> track) {
        this.track = track;
    }

    @Override
    public void lock() {
        this.track.lockForRead();
    }

    @Override
    public void unlock() {
        this.track.unlockAfterRead();
    }

    @Override
    public Iterable<T> getTrack(E e) {
        return this.track.getFixes();
    }

    @Override
    public Iterable<T> getRawTrack(E e) {
        return this.track.getRawFixes();
    }

    @Override
    public IterableLocker getLocker() {
        return new IterableLocker(){

            @Override
            public void lock() {
                TrackReaderImpl.this.track.lockForRead();
            }

            @Override
            public void unlock() {
                TrackReaderImpl.this.track.unlockAfterRead();
            }
        };
    }
}

