/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.trackfiles.impl;

import com.sap.sailing.domain.trackimport.FormatNotSupportedException;
import com.sap.sailing.server.trackfiles.impl.CompressedStreamsUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;

public abstract class ExpeditionImportFileHandler
implements CompressedStreamsUtil.FileHandler {
    public final Iterable<String> supportedExpeditionLogFileExtensions;

    public Iterable<String> getSupportedFileExtensions() {
        return this.supportedExpeditionLogFileExtensions;
    }

    protected ExpeditionImportFileHandler(Iterable<String> supportedFileExtensions) {
        this.supportedExpeditionLogFileExtensions = supportedFileExtensions;
    }

    protected ExpeditionImportFileHandler() {
        this(Arrays.asList("csv", "log", "txt"));
    }

    @Override
    public final void handle(String fileName, InputStream inputStream, Charset charset) throws IOException, FormatNotSupportedException {
        String lowerCaseFileName = fileName.toLowerCase();
        boolean extensionSupported = false;
        for (String extension : this.supportedExpeditionLogFileExtensions) {
            if (!lowerCaseFileName.endsWith(extension)) continue;
            extensionSupported = true;
            break;
        }
        if (extensionSupported) {
            this.handleExpeditionFile(lowerCaseFileName, inputStream, charset);
        }
    }

    protected abstract void handleExpeditionFile(String var1, InputStream var2, Charset var3) throws IOException, FormatNotSupportedException;
}

